/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.jenkins.plugin.scanners;

import com.hcl.appscan.jenkins.plugin.Messages;
import com.hcl.appscan.jenkins.plugin.auth.JenkinsAuthenticationProvider;
import com.hcl.appscan.jenkins.plugin.scanners.ScanDescriptor;
import com.hcl.appscan.jenkins.plugin.scanners.Scanner;
import com.hcl.appscan.sdk.auth.IAuthenticationProvider;
import com.hcl.appscan.sdk.logging.IProgress;
import com.hcl.appscan.sdk.scan.CloudScanServiceProvider;
import com.hcl.appscan.sdk.utils.ServiceUtil;
import hudson.AbortException;
import hudson.Extension;
import hudson.RelativePath;
import hudson.model.ItemGroup;
import hudson.util.FormValidation;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class SoftwareCompositionAnalyzer
extends Scanner {
    @Deprecated
    public SoftwareCompositionAnalyzer(String target) {
        super(target, false);
    }

    public SoftwareCompositionAnalyzer(String target, boolean rescan, String scanId) {
        super(target, false, rescan, scanId);
    }

    @DataBoundConstructor
    public SoftwareCompositionAnalyzer(String target, boolean hasOptions) {
        super(target, hasOptions, false, "");
    }

    @Override
    public String getType() {
        return "Software Composition Analyzer";
    }

    @Override
    public void validateSettings(JenkinsAuthenticationProvider authProvider, Map<String, String> properties, IProgress progress, boolean isAppScan360) throws IOException {
        super.validateSettings(authProvider, properties, progress, isAppScan360);
        if (!ServiceUtil.hasScaEntitlement((IAuthenticationProvider)authProvider)) {
            throw new AbortException(Messages.error_active_subscription_validation(this.getType()));
        }
    }

    @Override
    public Map<String, String> getProperties(VariableResolver<String> resolver) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("target", resolver == null ? this.getTarget() : this.resolvePath(this.getTarget(), resolver));
        if (this.getRescan() && this.isNullOrEmpty(this.getScanId())) {
            properties.put("ScanId", this.getScanId());
        }
        return properties;
    }

    @Symbol(value={"software_composition_analysis"})
    @Extension
    public static final class DescriptorImpl
    extends ScanDescriptor {
        public String getDisplayName() {
            return "Software Composition Analysis (SCA)";
        }

        public FormValidation doCheckScanId(@QueryParameter String scanId, @RelativePath(value="..") @QueryParameter String application, @RelativePath(value="..") @QueryParameter String credentials, @AncestorInPath ItemGroup<?> context) throws JSONException {
            JenkinsAuthenticationProvider provider = new JenkinsAuthenticationProvider(credentials, context);
            if (scanId != null && !scanId.isEmpty()) {
                JSONObject scanDetails = new CloudScanServiceProvider((IAuthenticationProvider)provider).getScanDetails("Software Composition Analyzer", scanId);
                return this.scanIdValidation(scanDetails, application);
            }
            return FormValidation.validateRequired((String)scanId);
        }

        public FormValidation doCheckTarget(@RelativePath(value="..") @QueryParameter String credentials, @AncestorInPath ItemGroup<?> context) {
            JenkinsAuthenticationProvider authProvider = new JenkinsAuthenticationProvider(credentials, context);
            if (!ServiceUtil.hasScaEntitlement((IAuthenticationProvider)authProvider)) {
                return FormValidation.error((String)Messages.error_active_subscription_validation_ui());
            }
            return FormValidation.ok();
        }
    }
}

