/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.jenkins.plugin.scanners;

import com.hcl.appscan.jenkins.plugin.Messages;
import com.hcl.appscan.jenkins.plugin.auth.JenkinsAuthenticationProvider;
import com.hcl.appscan.jenkins.plugin.scanners.ScannerConstants;
import com.hcl.appscan.sdk.auth.IAuthenticationProvider;
import com.hcl.appscan.sdk.logging.IProgress;
import com.hcl.appscan.sdk.logging.Message;
import com.hcl.appscan.sdk.scan.CloudScanServiceProvider;
import hudson.AbortException;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;
import org.kohsuke.stapler.DataBoundSetter;

public abstract class Scanner
extends AbstractDescribableImpl<Scanner>
implements ScannerConstants,
Serializable {
    private static final long serialVersionUID = 1L;
    private String m_target;
    private boolean m_hasOptions;
    private boolean m_rescan;
    private String m_scanId;

    public Scanner(String target, boolean hasOptions) {
        this.m_target = target;
        this.m_hasOptions = hasOptions;
    }

    public Scanner(String target, boolean hasOptions, boolean rescan, String scanId) {
        this.m_target = target;
        this.m_hasOptions = hasOptions;
        this.m_rescan = rescan;
        this.m_scanId = scanId;
    }

    public boolean getHasOptions() {
        return this.m_hasOptions;
    }

    public String getTarget() {
        return this.m_target;
    }

    @DataBoundSetter
    public void setRescan(boolean rescan) {
        this.m_rescan = rescan;
    }

    public boolean getRescan() {
        return this.m_rescan;
    }

    @DataBoundSetter
    public void setScanId(String scanId) {
        this.m_scanId = scanId;
    }

    public String getScanId() {
        return this.m_scanId;
    }

    public abstract Map<String, String> getProperties(VariableResolver<String> var1) throws AbortException;

    public abstract String getType();

    public boolean isNullOrEmpty(String string) {
        return string != null && !string.trim().isEmpty();
    }

    protected String resolvePath(String path, VariableResolver<String> resolver) {
        path = Util.replaceMacro((String)path, resolver);
        Pattern pattern = Pattern.compile("^(\\\\|/|[a-zA-Z]:\\\\)");
        if (!pattern.matcher(path).find()) {
            Object targetPath = "${WORKSPACE}/" + path;
            targetPath = Util.replaceMacro((String)targetPath, resolver);
            return targetPath;
        }
        return path;
    }

    public void validateSettings(JenkinsAuthenticationProvider authProvider, Map<String, String> properties, IProgress progress, boolean isAppScan360) throws IOException {
        if (authProvider.isTokenExpired()) {
            throw new AbortException(Messages.error_token_authentication());
        }
        if (isAppScan360) {
            if (!properties.get("FullyAutomatic").equals("true")) {
                progress.setStatus(new Message(1, Messages.warning_allow_intervention_AppScan360()));
            }
        } else if (authProvider.getacceptInvalidCerts()) {
            progress.setStatus(new Message(1, Messages.warning_asoc_certificates()));
        }
        if (properties.containsKey("ScanId")) {
            if (properties.get("Personal").equals("true")) {
                progress.setStatus(new Message(1, Messages.warning_personal_scan_rescan()));
            }
            try {
                this.validateScanID(properties, authProvider);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    private void validateScanID(Map<String, String> properties, JenkinsAuthenticationProvider authProvider) throws JSONException, IOException {
        JSONObject scanDetails = new CloudScanServiceProvider((IAuthenticationProvider)authProvider).getScanDetails(properties.get("type"), properties.get("ScanId"));
        if (scanDetails == null) {
            throw new AbortException(Messages.error_invalid_scan_id());
        }
        String status = scanDetails.getJSONObject("LatestExecution").getString("Status");
        if (!(status.equals("Ready") || status.equals("Paused") || status.equals("Failed"))) {
            throw new AbortException(Messages.error_scan_id_validation_status(status));
        }
        if (!scanDetails.get("RescanAllowed").equals(true) && scanDetails.get("ParsedFromUploadedFile").equals(true)) {
            throw new AbortException(Messages.error_scan_id_validation_rescan_allowed());
        }
        if (!scanDetails.get("AppId").equals(properties.get("AppId"))) {
            throw new AbortException(Messages.error_invalid_scan_id_application());
        }
    }
}

