/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.jenkins.plugin.scanners;

import com.hcl.appscan.jenkins.plugin.Messages;
import com.hcl.appscan.jenkins.plugin.scanners.Scanner;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;

public abstract class ScanDescriptor
extends Descriptor<Scanner> {
    protected FormValidation scanIdValidation(JSONObject scanDetails, String application) throws JSONException {
        if (scanDetails == null) {
            return FormValidation.error((String)Messages.error_invalid_scan_id_ui());
        }
        String status = scanDetails.getJSONObject("LatestExecution").getString("Status");
        if (!(status.equals("Ready") || status.equals("Paused") || status.equals("Failed"))) {
            return FormValidation.error((String)Messages.error_scan_id_validation_status(status));
        }
        if (!scanDetails.get("RescanAllowed").equals(true) && scanDetails.get("ParsedFromUploadedFile").equals(true)) {
            return FormValidation.error((String)Messages.error_invalid_scan_id_rescan_allowed_ui());
        }
        if (!scanDetails.get("AppId").equals(application)) {
            return FormValidation.error((String)Messages.error_invalid_scan_id_application_ui());
        }
        return FormValidation.ok();
    }
}

