/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.jenkins.plugin.scanners;

import com.hcl.appscan.jenkins.plugin.Messages;
import com.hcl.appscan.jenkins.plugin.auth.JenkinsAuthenticationProvider;
import com.hcl.appscan.jenkins.plugin.scanners.ScanDescriptor;
import com.hcl.appscan.jenkins.plugin.scanners.Scanner;
import com.hcl.appscan.sdk.auth.IAuthenticationProvider;
import com.hcl.appscan.sdk.logging.IProgress;
import com.hcl.appscan.sdk.logging.Message;
import com.hcl.appscan.sdk.presence.CloudPresenceProvider;
import com.hcl.appscan.sdk.scan.CloudScanServiceProvider;
import com.hcl.appscan.sdk.utils.ServiceUtil;
import hudson.AbortException;
import hudson.Extension;
import hudson.RelativePath;
import hudson.Util;
import hudson.model.ItemGroup;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.net.Proxy;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class DynamicAnalyzer
extends Scanner {
    private static final String DYNAMIC_ANALYZER = "Dynamic Analyzer";
    private boolean m_rescanDast;
    private boolean m_incrementalScan;
    private String m_executionId;
    private String m_presenceId;
    private String m_scanFile;
    private String m_scanType;
    private String m_optimization;
    private String m_extraField;
    private String m_loginType;
    private String m_loginUser;
    private Secret m_loginPassword;
    private String m_trafficFile;

    @Deprecated
    public DynamicAnalyzer(String target) {
        this(target, false, false, "", false, "", "", "", "", "", "", "", "", "", "");
    }

    @Deprecated
    public DynamicAnalyzer(String target, boolean hasOptions, boolean rescanDast, String scanId, boolean incrementalScan, String executionId, String presenceId, String scanFile, String scanType, String optimization, String extraField, String loginUser, String loginPassword, String trafficFile, String loginType) {
        super(target, hasOptions, false, scanId);
        this.m_rescanDast = rescanDast;
        this.m_incrementalScan = incrementalScan;
        this.m_executionId = executionId;
        this.m_presenceId = presenceId;
        this.m_scanFile = scanFile;
        this.m_scanType = scanFile != null && !scanFile.equals("") ? "Custom" : scanType;
        this.m_optimization = optimization;
        this.m_extraField = extraField;
        this.m_loginUser = loginUser;
        this.m_loginPassword = Secret.fromString((String)loginPassword);
        this.m_trafficFile = trafficFile;
        this.m_loginType = loginType;
    }

    @DataBoundConstructor
    public DynamicAnalyzer(String target, boolean hasOptions) {
        super(target, hasOptions, false, "");
        this.m_incrementalScan = false;
        this.m_executionId = "";
        this.m_presenceId = "";
        this.m_scanFile = "";
        this.m_scanType = "";
        this.m_optimization = "";
        this.m_extraField = "";
        this.m_loginType = "";
        this.m_loginUser = "";
        this.m_loginPassword = Secret.fromString((String)"");
        this.m_trafficFile = "";
    }

    @DataBoundSetter
    public void setLoginUser(String loginUser) {
        this.m_loginUser = loginUser;
    }

    public String getLoginUser() {
        return this.m_loginUser;
    }

    @DataBoundSetter
    public void setLoginPassword(String loginPassword) {
        this.m_loginPassword = Secret.fromString((String)loginPassword);
    }

    public String getLoginPassword() {
        return Secret.toString((Secret)this.m_loginPassword);
    }

    @DataBoundSetter
    public void setRescanDast(boolean rescanDast) {
        this.m_rescanDast = rescanDast;
    }

    public boolean getRescanDast() {
        return this.m_rescanDast;
    }

    @DataBoundSetter
    public void setIncrementalScan(boolean incrementalScan) {
        this.m_incrementalScan = incrementalScan;
    }

    public boolean getIncrementalScan() {
        return this.m_incrementalScan;
    }

    @DataBoundSetter
    public void setExecutionId(String executionId) {
        this.m_executionId = executionId;
    }

    public String getExecutionId() {
        if (this.m_incrementalScan) {
            return this.m_executionId;
        }
        return "";
    }

    @DataBoundSetter
    public void setPresenceId(String presenceId) {
        this.m_presenceId = presenceId;
    }

    public String getPresenceId() {
        return this.m_presenceId;
    }

    @DataBoundSetter
    public void setScanFile(String scanFile) {
        this.m_scanFile = scanFile;
    }

    public String getScanFile() {
        return this.m_scanFile;
    }

    @DataBoundSetter
    public void setScanType(String scanType) {
        this.m_scanType = this.m_scanFile != null && !this.m_scanFile.equals("") ? "Custom" : scanType;
    }

    public String getScanType() {
        return this.m_scanType;
    }

    @DataBoundSetter
    public void setOptimization(String optimization) {
        this.m_optimization = optimization != null ? this.mapOldtoNewOptLevels(optimization) : null;
    }

    public String getOptimization() {
        this.m_optimization = this.mapOldtoNewOptLevels(this.m_optimization);
        return this.m_optimization;
    }

    @DataBoundSetter
    public void setExtraField(String extraField) {
        this.m_extraField = extraField;
    }

    public String getExtraField() {
        return this.m_extraField;
    }

    @DataBoundSetter
    public void setLoginType(String loginType) {
        this.m_loginType = loginType;
    }

    public String getLoginType() {
        return this.m_loginType;
    }

    @DataBoundSetter
    public void setTrafficFile(String trafficFile) {
        if ("Manual".equals(this.m_loginType)) {
            this.m_trafficFile = trafficFile;
        }
    }

    public String getTrafficFile() {
        return this.m_trafficFile;
    }

    @Override
    public String getType() {
        return DYNAMIC_ANALYZER;
    }

    public String isLoginTypes(String loginTypeName) {
        if (this.m_loginType != null) {
            return this.m_loginType.equalsIgnoreCase(loginTypeName) ? "true" : "";
        }
        if (!this.m_loginUser.equals("") || !this.m_loginPassword.equals((Object)Secret.fromString((String)""))) {
            this.m_loginType = "Automatic";
            return "true";
        }
        if (loginTypeName.equals("None")) {
            return "true";
        }
        return "";
    }

    public String upgradeLoginScenario() {
        if (!this.m_loginUser.equals("") && !this.m_loginPassword.equals((Object)Secret.fromString((String)""))) {
            this.m_loginType = "Automatic";
            return "Automatic";
        }
        this.m_loginType = "None";
        return "None";
    }

    @Override
    public void validateSettings(JenkinsAuthenticationProvider authProvider, Map<String, String> properties, IProgress progress, boolean isAppScan360) throws IOException {
        super.validateSettings(authProvider, properties, progress, isAppScan360);
        if (!ServiceUtil.hasDastEntitlement((IAuthenticationProvider)authProvider)) {
            throw new AbortException(Messages.error_active_subscription_validation(this.getType()));
        }
        if (this.getRescanDast()) {
            if (!properties.containsKey("ScanId")) {
                throw new AbortException(Messages.error_empty_scan_id());
            }
            if (this.m_incrementalScan && !this.isNullOrEmpty(this.m_executionId)) {
                progress.setStatus(new Message(1, Messages.warning_empty_execution_id()));
            }
        }
        if (authProvider.isAppScan360() && properties.containsKey("PresenceId")) {
            throw new AbortException(Messages.error_presence_AppScan360());
        }
        if (!this.getRescanDast()) {
            String target = properties.get("target");
            if (!this.isNullOrEmpty(target)) {
                throw new AbortException(Messages.error_target_empty());
            }
            if (!authProvider.isAppScan360() && !properties.containsKey("PresenceId") || authProvider.isAppScan360() && ServiceUtil.compareVersions((String)"1.4.0", (String)ServiceUtil.getServiceVersion((IAuthenticationProvider)authProvider).substring(0, 5))) {
                boolean isUrlValid = ServiceUtil.isValidUrl((String)target, (IAuthenticationProvider)authProvider, (Proxy)authProvider.getProxy());
                boolean isDomainValid = ServiceUtil.isValidDomain((String)target, (String)properties.get("AppId"), (IAuthenticationProvider)authProvider, (Proxy)authProvider.getProxy());
                if (!isUrlValid) {
                    throw new AbortException(Messages.error_invalid_url_connection());
                }
                if (!isDomainValid) {
                    if (isAppScan360) {
                        throw new AbortException(Messages.error_invalid_domain_AppScan360());
                    }
                    throw new AbortException(Messages.error_invalid_domain_ASoC());
                }
            }
        }
    }

    @Override
    public Map<String, String> getProperties(VariableResolver<String> resolver) throws AbortException {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (resolver == null) {
            properties.put("target", this.getTarget());
            properties.put("ScanFile", this.m_scanFile);
            if (!this.m_extraField.equals("")) {
                properties.put("ExtraField", this.m_extraField);
            }
            if (this.m_loginType == null || this.m_loginType.equals("")) {
                this.m_loginType = this.upgradeLoginScenario();
            }
            if ("Manual".equals(this.m_loginType)) {
                properties.put("trafficFile", this.m_trafficFile);
                if (this.m_trafficFile == null || this.m_trafficFile.equals("")) {
                    throw new AbortException(Messages.error_login_fields_empty_manual());
                }
                if (!this.m_trafficFile.toLowerCase().endsWith(".config")) {
                    throw new AbortException(Messages.error_login_fields_manual());
                }
            } else if ("Automatic".equals(this.m_loginType)) {
                properties.put("LoginUser", this.m_loginUser);
                properties.put("LoginPassword", Secret.toString((Secret)this.m_loginPassword));
                if (this.m_loginUser.equals("") || this.m_loginPassword.equals((Object)Secret.fromString((String)""))) {
                    throw new AbortException(Messages.error_login_fields_automatic());
                }
            }
        } else {
            properties.put("target", Util.replaceMacro((String)this.getTarget(), resolver));
            properties.put("ScanFile", this.m_scanFile.equals("") ? this.m_scanFile : this.resolvePath(this.m_scanFile, resolver));
            properties.put("ExtraField", Util.replaceMacro((String)this.m_extraField, resolver));
            if (this.m_loginType == null || this.m_loginType.equals("")) {
                this.m_loginType = this.upgradeLoginScenario();
            }
            if ("Manual".equals(this.m_loginType)) {
                properties.put("trafficFile", this.resolvePath(this.m_trafficFile, resolver));
                if (this.m_trafficFile == null || this.m_trafficFile.equals("")) {
                    throw new AbortException(Messages.error_login_fields_empty_manual());
                }
                if (!this.resolvePath(this.m_trafficFile, resolver).toLowerCase().endsWith(".config")) {
                    throw new AbortException(Messages.error_login_fields_manual());
                }
            } else if ("Automatic".equals(this.m_loginType)) {
                properties.put("LoginUser", Util.replaceMacro((String)this.m_loginUser, resolver));
                properties.put("LoginPassword", Util.replaceMacro((String)Secret.toString((Secret)this.m_loginPassword), resolver));
                if (this.m_loginUser.equals("") || this.m_loginPassword.equals((Object)Secret.fromString((String)""))) {
                    throw new AbortException(Messages.error_login_fields_automatic());
                }
            }
        }
        properties.put("LoginType", this.m_loginType);
        properties.put("TestOptimizationLevel", this.m_optimization);
        if (!this.m_presenceId.equals("")) {
            properties.put("PresenceId", this.m_presenceId);
        }
        if (this.getRescanDast() && this.isNullOrEmpty(this.getScanId())) {
            properties.put("ScanId", this.getScanId());
            if (this.m_incrementalScan && this.isNullOrEmpty(this.m_executionId)) {
                properties.put("IncrementalBaseJobId", this.m_executionId);
                properties.put("IsIncrementalRetest", "true");
            }
        }
        return properties;
    }

    private String mapOldtoNewOptLevels(String optimization) {
        if (optimization != null) {
            this.m_optimization = optimization.equals("Normal") ? "NoOptimization" : (optimization.equals("Optimized") ? "Fast" : optimization);
        }
        return this.m_optimization;
    }

    @Symbol(value={"dynamic_analyzer"})
    @Extension
    public static final class DescriptorImpl
    extends ScanDescriptor {
        public String getDisplayName() {
            return "Dynamic Analysis (DAST)";
        }

        public ListBoxModel doFillExecutionIdItems(@RelativePath(value="..") @QueryParameter String credentials, @AncestorInPath ItemGroup<?> context, @QueryParameter String scanId) throws JSONException {
            JenkinsAuthenticationProvider authProvider = new JenkinsAuthenticationProvider(credentials, context);
            JSONArray executionDetails = new CloudScanServiceProvider((IAuthenticationProvider)authProvider).getBaseScanDetails(scanId);
            ListBoxModel model = new ListBoxModel();
            if (executionDetails != null) {
                for (int i = 0; i < executionDetails.length(); ++i) {
                    JSONObject value = executionDetails.getJSONObject(i);
                    ZonedDateTime zdt = ZonedDateTime.parse((String)value.get("CreatedAt")).withZoneSameInstant(ZoneId.systemDefault());
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MMMM dd, yyyy, hh:mm a, z");
                    model.add(zdt.format(formatter), (String)value.get("Id"));
                }
            }
            return model;
        }

        public ListBoxModel doFillScanTypeItems() {
            ListBoxModel model = new ListBoxModel();
            model.add(Messages.option_staging(), "Staging");
            model.add(Messages.option_production(), "Production");
            return model;
        }

        public ListBoxModel doFillOptimizationItems() {
            ListBoxModel model = new ListBoxModel();
            model.add(Messages.option_fast(), "Fast");
            model.add(Messages.option_faster(), "Faster");
            model.add(Messages.option_fastest(), "Fastest");
            model.add(Messages.option_nooptimization(), "NoOptimization");
            return model;
        }

        public ListBoxModel doFillPresenceIdItems(@RelativePath(value="..") @QueryParameter String credentials, @AncestorInPath ItemGroup<?> context) {
            JenkinsAuthenticationProvider authProvider = new JenkinsAuthenticationProvider(credentials, context);
            Map presences = new CloudPresenceProvider((IAuthenticationProvider)authProvider).getPresences();
            ListBoxModel model = new ListBoxModel();
            model.add("");
            if (presences != null) {
                List<Map.Entry<String, String>> list = this.sortPresences(presences.entrySet());
                for (Map.Entry<String, String> entry : list) {
                    model.add(entry.getValue(), entry.getKey());
                }
            }
            return model;
        }

        private List<Map.Entry<String, String>> sortPresences(Set<Map.Entry<String, String>> set) {
            ArrayList<Map.Entry<String, String>> list = new ArrayList<Map.Entry<String, String>>(set);
            if (list.size() > 1) {
                Collections.sort(list, new Comparator<Map.Entry<String, String>>(){

                    @Override
                    public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                        return o1.getValue().toLowerCase().compareTo(o2.getValue().toLowerCase());
                    }
                });
            }
            return list;
        }

        public FormValidation doCheckScanFile(@QueryParameter String scanFile) {
            if (!(scanFile.trim().equals("") || scanFile.endsWith(".scant") || scanFile.endsWith(".scan") || scanFile.startsWith("${"))) {
                return FormValidation.error((String)Messages.error_invalid_template_file());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckTarget(@QueryParameter String target, @RelativePath(value="..") @QueryParameter String credentials, @RelativePath(value="..") @QueryParameter String application, @AncestorInPath ItemGroup<?> context, @QueryParameter String presenceId, @QueryParameter boolean rescanDast) {
            JenkinsAuthenticationProvider authProvider = new JenkinsAuthenticationProvider(credentials, context);
            if (!ServiceUtil.hasDastEntitlement((IAuthenticationProvider)authProvider)) {
                return FormValidation.error((String)Messages.error_active_subscription_validation_ui());
            }
            if (rescanDast) {
                return FormValidation.ok();
            }
            if (target.trim().equals("")) {
                return FormValidation.validateRequired((String)target);
            }
            if (presenceId != null && presenceId.equals("") && !authProvider.isAppScan360() || authProvider.isAppScan360() && ServiceUtil.compareVersions((String)"1.4.0", (String)ServiceUtil.getServiceVersion((IAuthenticationProvider)authProvider).substring(0, 5))) {
                boolean isUrlValid = ServiceUtil.isValidUrl((String)target, (IAuthenticationProvider)authProvider, (Proxy)authProvider.getProxy());
                boolean isDomainValid = ServiceUtil.isValidDomain((String)target, (String)application, (IAuthenticationProvider)authProvider, (Proxy)authProvider.getProxy());
                if (!isUrlValid) {
                    return FormValidation.error((String)Messages.error_invalid_url_connection());
                }
                if (!isDomainValid) {
                    if (authProvider.isAppScan360()) {
                        return FormValidation.error((String)Messages.error_invalid_domain_AppScan360());
                    }
                    return FormValidation.error((String)Messages.error_invalid_domain_ASoC());
                }
                return FormValidation.ok();
            }
            return FormValidation.validateRequired((String)target);
        }

        public FormValidation doCheckScanId(@QueryParameter String scanId, @RelativePath(value="..") @QueryParameter String application, @RelativePath(value="..") @QueryParameter String credentials, @AncestorInPath ItemGroup<?> context) throws JSONException {
            JenkinsAuthenticationProvider provider = new JenkinsAuthenticationProvider(credentials, context);
            if (scanId != null && !scanId.isEmpty()) {
                JSONObject scanDetails = new CloudScanServiceProvider((IAuthenticationProvider)provider).getScanDetails(DynamicAnalyzer.DYNAMIC_ANALYZER, scanId);
                return this.scanIdValidation(scanDetails, application);
            }
            return FormValidation.validateRequired((String)scanId);
        }

        public FormValidation doCheckExecutionId(@RelativePath(value="..") @QueryParameter String credentials, @AncestorInPath ItemGroup<?> context, @QueryParameter String scanId) {
            JenkinsAuthenticationProvider authProvider = new JenkinsAuthenticationProvider(credentials, context);
            JSONArray executionDetails = new CloudScanServiceProvider((IAuthenticationProvider)authProvider).getBaseScanDetails(scanId);
            if (executionDetails == null) {
                return FormValidation.error((String)Messages.error_base_scan_empty_ui());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPresenceId(@RelativePath(value="..") @QueryParameter String credentials, @AncestorInPath ItemGroup<?> context, @QueryParameter String presenceId) {
            JenkinsAuthenticationProvider authProvider = new JenkinsAuthenticationProvider(credentials, context);
            if (authProvider.isAppScan360()) {
                return FormValidation.error((String)Messages.error_presence_AppScan360());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckLoginUser(@QueryParameter String loginUser) {
            return FormValidation.validateRequired((String)loginUser);
        }

        public FormValidation doCheckLoginPassword(@QueryParameter String loginPassword) {
            return FormValidation.validateRequired((String)loginPassword);
        }

        public FormValidation doCheckTrafficFile(@QueryParameter String trafficFile) {
            if (trafficFile.trim().equals("")) {
                return FormValidation.validateRequired((String)trafficFile);
            }
            if (!trafficFile.toLowerCase().endsWith(".config") && !trafficFile.startsWith("${")) {
                return FormValidation.error((String)Messages.error_invalid_login_sequence_file());
            }
            return FormValidation.ok();
        }
    }
}

