/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.jenkins.plugin.scanModes;

import com.hcl.appscan.jenkins.plugin.scanModes.ScanMode;
import com.hcl.appscan.jenkins.plugin.scanModes.ScanModeDescriptor;
import hudson.Extension;
import hudson.Util;
import hudson.util.FormValidation;
import hudson.util.Secret;
import hudson.util.VariableResolver;
import java.util.Map;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class TestOnly
extends ScanMode {
    private static final String TEST_ONLY = "Test Only";
    private String m_loginTypeTestScan;
    private String m_trafficFileTestScan;
    private String m_accessIdTestScan;
    private Secret m_secretKeyTestScan;
    private String m_exploreDataTestScan;

    @DataBoundConstructor
    public TestOnly(String loginTypeTestScan, String accessIdTestScan, String secretKeyTestScan, String trafficFileTestScan, String exploreDataTestScan) {
        this.m_loginTypeTestScan = loginTypeTestScan;
        this.m_trafficFileTestScan = trafficFileTestScan;
        this.m_accessIdTestScan = accessIdTestScan;
        this.m_secretKeyTestScan = Secret.fromString((String)secretKeyTestScan);
        this.m_exploreDataTestScan = exploreDataTestScan;
    }

    @DataBoundSetter
    public void setLoginTypeTestScan(String loginTypeTestScan) {
        this.m_loginTypeTestScan = loginTypeTestScan;
    }

    public String getLoginTypeTestScan() {
        return this.m_loginTypeTestScan;
    }

    @DataBoundSetter
    public void setAccessIdTestScan(String accessIdTestScan) {
        this.m_accessIdTestScan = accessIdTestScan;
    }

    public String getAccessIdTestScan() {
        return this.m_accessIdTestScan;
    }

    @DataBoundSetter
    public void setSecretKeyTestScan(String secretKeyTestScan) {
        this.m_secretKeyTestScan = Secret.fromString((String)secretKeyTestScan);
    }

    public String getSecretKeyTestScan() {
        return Secret.toString((Secret)this.m_secretKeyTestScan);
    }

    @DataBoundSetter
    public void setTrafficFileTestScan(String trafficFileTestScan) {
        this.m_trafficFileTestScan = trafficFileTestScan;
    }

    public String getTrafficFileTestScan() {
        return this.m_trafficFileTestScan;
    }

    @DataBoundSetter
    public void setExploreDataTestScan(String exploreDataTestScan) {
        this.m_exploreDataTestScan = exploreDataTestScan;
    }

    public String getExploreDataTestScan() {
        return this.m_exploreDataTestScan;
    }

    public String isLoginTypeTestScan(String loginTypeName) {
        return loginTypeName.equalsIgnoreCase(this.m_loginTypeTestScan) || loginTypeName.equals("Manual") ? "true" : "";
    }

    @Override
    public Map<String, String> configureScanProperties(Map<String, String> properties, VariableResolver<String> resolver) {
        properties.put("scanType", TEST_ONLY);
        properties.put("loginType", this.m_loginTypeTestScan);
        properties.put("exploreData", resolver == null || "".equals(this.m_exploreDataTestScan) ? this.m_exploreDataTestScan : this.resolvePath(this.m_exploreDataTestScan, resolver));
        if ("Manual".equals(this.m_loginTypeTestScan)) {
            properties.put("trafficFile", resolver == null || "".equals(this.m_trafficFileTestScan) ? this.m_trafficFileTestScan : this.resolvePath(this.m_trafficFileTestScan, resolver));
        } else if ("Automatic".equals(this.m_loginTypeTestScan)) {
            properties.put("userName", resolver == null ? this.m_accessIdTestScan : Util.replaceMacro((String)this.m_accessIdTestScan, resolver));
            properties.put("password", resolver == null ? Secret.toString((Secret)this.m_secretKeyTestScan) : Util.replaceMacro((String)Secret.toString((Secret)this.m_secretKeyTestScan), resolver));
        }
        return properties;
    }

    @Symbol(value={"test_only"})
    @Extension
    public static final class DescriptorImpl
    extends ScanModeDescriptor {
        public String getDisplayName() {
            return TestOnly.TEST_ONLY;
        }

        public FormValidation doCheckExploreDataTestScan(@QueryParameter String exploreDataTestScan) {
            return FormValidation.validateRequired((String)exploreDataTestScan);
        }
    }
}

