/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.jenkins.plugin.scanModes;

import com.hcl.appscan.jenkins.plugin.Messages;
import com.hcl.appscan.jenkins.plugin.scanModes.ScanMode;
import com.hcl.appscan.jenkins.plugin.scanModes.ScanModeDescriptor;
import hudson.Extension;
import hudson.Util;
import hudson.util.FormValidation;
import hudson.util.VariableResolver;
import java.util.Map;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class PostmanCollection
extends ScanMode {
    private static final String POSTMAN_COLLECTION = "Postman Collection";
    private String m_postmanCollectionFile;
    private String m_additionalDomains;
    private String m_environmentalVariablesFile;
    private String m_globalVariablesFile;
    private String m_additionalFiles;

    @DataBoundConstructor
    public PostmanCollection() {
        this("", "", "", "", "");
    }

    public PostmanCollection(String postmanCollectionFile, String additionalDomains, String environmentalVariablesFile, String globalVariablesFile, String additionalFiles) {
        this.m_postmanCollectionFile = postmanCollectionFile;
        this.m_additionalDomains = additionalDomains;
        this.m_environmentalVariablesFile = environmentalVariablesFile;
        this.m_globalVariablesFile = globalVariablesFile;
        this.m_additionalFiles = additionalFiles;
    }

    @DataBoundSetter
    public void setPostmanCollectionFile(String postmanCollectionFile) {
        this.m_postmanCollectionFile = postmanCollectionFile;
    }

    public String getPostmanCollectionFile() {
        return this.m_postmanCollectionFile;
    }

    @DataBoundSetter
    public void setAdditionalDomains(String additionalDomains) {
        this.m_additionalDomains = additionalDomains;
    }

    public String getAdditionalDomains() {
        return this.m_additionalDomains;
    }

    @DataBoundSetter
    public void setEnvironmentalVariablesFile(String environmentalVariablesFile) {
        this.m_environmentalVariablesFile = environmentalVariablesFile;
    }

    public String getEnvironmentalVariablesFile() {
        return this.m_environmentalVariablesFile;
    }

    @DataBoundSetter
    public void setGlobalVariablesFile(String globalVariablesFile) {
        this.m_globalVariablesFile = globalVariablesFile;
    }

    public String getGlobalVariablesFile() {
        return this.m_globalVariablesFile;
    }

    @DataBoundSetter
    public void setAdditionalFiles(String additionalFiles) {
        this.m_additionalFiles = additionalFiles;
    }

    public String getAdditionalFiles() {
        return this.m_additionalFiles;
    }

    @Override
    public Map<String, String> configureScanProperties(Map<String, String> properties, VariableResolver<String> resolver) {
        properties.put("scanType", POSTMAN_COLLECTION);
        this.addResolvedProperty(properties, "postmanCollectionFile", this.m_postmanCollectionFile, resolver);
        this.addResolvedProperty(properties, "additionalDomains", this.m_additionalDomains, resolver);
        this.addResolvedProperty(properties, "environmentalVariablesFile", this.m_environmentalVariablesFile, resolver);
        this.addResolvedProperty(properties, "globalVariablesFile", this.m_globalVariablesFile, resolver);
        this.addResolvedProperty(properties, "additionalFiles", this.m_additionalFiles, resolver);
        return properties;
    }

    private void addResolvedProperty(Map<String, String> properties, String key, String value, VariableResolver resolver) {
        if (!this.isNotNullOrEmpty(value)) {
            return;
        }
        String resolvedValue = resolver == null ? value : ("additionalDomains".equals(key) ? Util.replaceMacro((String)value, (VariableResolver)resolver) : this.resolvePath(value, (VariableResolver<String>)resolver));
        properties.put(key, resolvedValue);
    }

    @Symbol(value={"postman_collection"})
    @Extension
    public static final class DescriptorImpl
    extends ScanModeDescriptor {
        public String getDisplayName() {
            return PostmanCollection.POSTMAN_COLLECTION;
        }

        public FormValidation doCheckAdditionalDomains(@QueryParameter String additionalDomains) {
            return FormValidation.validateRequired((String)additionalDomains);
        }

        private FormValidation validateFileExtension(String fileName, String extensionType, boolean required) {
            if (fileName != null && !fileName.isEmpty() && !fileName.endsWith(extensionType)) {
                return FormValidation.error((String)Messages.error_file_type_invalid(extensionType));
            }
            return required ? FormValidation.validateRequired((String)fileName) : FormValidation.ok();
        }

        public FormValidation doCheckPostmanCollectionFile(@QueryParameter String postmanCollectionFile) {
            return this.validateFileExtension(postmanCollectionFile, ".json", true);
        }

        public FormValidation doCheckEnvironmentalVariablesFile(@QueryParameter String environmentalVariablesFile) {
            return this.validateFileExtension(environmentalVariablesFile, ".json", false);
        }

        public FormValidation doCheckGlobalVariablesFile(@QueryParameter String globalVariablesFile) {
            return this.validateFileExtension(globalVariablesFile, ".json", false);
        }

        public FormValidation doCheckAdditionalFiles(@QueryParameter String additionalFiles) {
            return this.validateFileExtension(additionalFiles, ".zip", false);
        }
    }
}

