/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.jenkins.plugin.scanModes;

import com.hcl.appscan.jenkins.plugin.scanModes.ScanMode;
import com.hcl.appscan.jenkins.plugin.scanModes.ScanModeDescriptor;
import hudson.Extension;
import hudson.Util;
import hudson.util.Secret;
import hudson.util.VariableResolver;
import java.util.Map;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class FullScan
extends ScanMode {
    private static final String FULL_SCAN = "Full Scan";
    private String m_loginType;
    private String m_trafficFile;
    private String m_accessId;
    private Secret m_secretKey;
    private String m_exploreData;

    @DataBoundConstructor
    public FullScan(String loginType, String accessId, String secretKey, String trafficFile, String exploreData) {
        this.m_loginType = loginType;
        this.m_accessId = accessId;
        this.m_secretKey = Secret.fromString((String)secretKey);
        this.m_trafficFile = trafficFile;
        this.m_exploreData = exploreData;
    }

    @DataBoundSetter
    public void setLoginType(String loginType) {
        this.m_loginType = loginType;
    }

    public String getLoginType() {
        return this.m_loginType;
    }

    @DataBoundSetter
    public void setAccessId(String accessId) {
        this.m_accessId = accessId;
    }

    public String getAccessId() {
        return this.m_accessId;
    }

    @DataBoundSetter
    public void setSecretKey(String secretKey) {
        this.m_secretKey = Secret.fromString((String)secretKey);
    }

    public String getSecretKey() {
        return Secret.toString((Secret)this.m_secretKey);
    }

    @DataBoundSetter
    public void setTrafficFile(String trafficFile) {
        this.m_trafficFile = trafficFile;
    }

    public String getTrafficFile() {
        return this.m_trafficFile;
    }

    @DataBoundSetter
    public void setExploreData(String exploreData) {
        this.m_exploreData = exploreData;
    }

    public String getExploreData() {
        return this.m_exploreData;
    }

    public String isLoginType(String loginTypeName) {
        return loginTypeName.equalsIgnoreCase(this.m_loginType) || loginTypeName.equals("Manual") ? "true" : "";
    }

    @Override
    public Map<String, String> configureScanProperties(Map<String, String> properties, VariableResolver<String> resolver) {
        properties.put("scanType", FULL_SCAN);
        properties.put("loginType", this.m_loginType);
        properties.put("exploreData", resolver == null || "".equals(this.m_exploreData) ? this.m_exploreData : this.resolvePath(this.m_exploreData, resolver));
        if ("Manual".equals(this.m_loginType)) {
            properties.put("trafficFile", resolver == null || "".equals(this.m_trafficFile) ? this.m_trafficFile : this.resolvePath(this.m_trafficFile, resolver));
        } else if ("Automatic".equals(this.m_loginType)) {
            properties.put("userName", resolver == null ? this.m_accessId : Util.replaceMacro((String)this.m_accessId, resolver));
            properties.put("password", resolver == null ? Secret.toString((Secret)this.m_secretKey) : Util.replaceMacro((String)Secret.toString((Secret)this.m_secretKey), resolver));
        }
        return properties;
    }

    @Symbol(value={"full_scan"})
    @Extension
    public static final class DescriptorImpl
    extends ScanModeDescriptor {
        public String getDisplayName() {
            return "Full Automatic Scan";
        }
    }
}

