/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.jenkins.plugin.results;

import com.hcl.appscan.jenkins.plugin.results.FailureCondition;
import com.hcl.appscan.sdk.results.IResultsProvider;
import java.util.List;

public class ResultsInspector {
    private List<FailureCondition> m_conditions;
    private IResultsProvider m_resultsProvider;

    public ResultsInspector(List<FailureCondition> conditions, IResultsProvider resultsProvider) {
        this.m_conditions = conditions;
        this.m_resultsProvider = resultsProvider;
    }

    public boolean shouldFail() {
        for (FailureCondition condition : this.m_conditions) {
            int threshold;
            String type = condition.getFailureType();
            if (!this.exceedsThreshold(type, threshold = condition.getThreshold())) continue;
            return true;
        }
        return false;
    }

    private boolean exceedsThreshold(String type, int threshold) {
        switch (type.toLowerCase()) {
            case "total": {
                return this.m_resultsProvider.getFindingsCount() > threshold;
            }
            case "critical": {
                return this.m_resultsProvider.getCriticalCount() > threshold;
            }
            case "high": {
                return this.m_resultsProvider.getHighCount() > threshold;
            }
            case "medium": {
                return this.m_resultsProvider.getMediumCount() > threshold;
            }
            case "low": {
                return this.m_resultsProvider.getLowCount() > threshold;
            }
        }
        return false;
    }
}

