/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.jenkins.plugin.results;

import com.hcl.appscan.jenkins.plugin.Messages;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class FailureCondition
extends AbstractDescribableImpl<FailureCondition>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String m_failureType;
    private int m_threshold;

    @DataBoundConstructor
    public FailureCondition(String failureType, int threshold) {
        this.m_failureType = failureType;
        this.m_threshold = threshold;
    }

    public String getFailureType() {
        return this.m_failureType;
    }

    public int getThreshold() {
        return this.m_threshold;
    }

    @Symbol(value={"failure_condition"})
    @Extension
    public static class DescriptorImpl
    extends Descriptor<FailureCondition> {
        public String getDisplayName() {
            return "";
        }

        public ListBoxModel doFillFailureTypeItems() {
            ListBoxModel model = new ListBoxModel();
            model.add(Messages.label_total(), "total");
            model.add(Messages.label_critical(), "critical");
            model.add(Messages.label_high(), "high");
            model.add(Messages.label_medium(), "medium");
            model.add(Messages.label_low(), "low");
            return model;
        }

        public FormValidation doCheckThreshold(@QueryParameter String threshold) {
            return FormValidation.validateNonNegativeInteger((String)threshold);
        }
    }
}

