/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.jenkins.plugin.builders;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.hcl.appscan.jenkins.plugin.Messages;
import com.hcl.appscan.jenkins.plugin.ScanFactory;
import com.hcl.appscan.jenkins.plugin.actions.ResultsRetriever;
import com.hcl.appscan.jenkins.plugin.auth.ASECredentials;
import com.hcl.appscan.jenkins.plugin.auth.ASEJenkinsAuthenticationProvider;
import com.hcl.appscan.jenkins.plugin.results.FailureCondition;
import com.hcl.appscan.jenkins.plugin.results.ResultsInspector;
import com.hcl.appscan.jenkins.plugin.scanModes.ScanMode;
import com.hcl.appscan.jenkins.plugin.scanModes.ScanModeFactory;
import com.hcl.appscan.jenkins.plugin.util.BuildVariableResolver;
import com.hcl.appscan.jenkins.plugin.util.ScanProgress;
import com.hcl.appscan.sdk.app.ASEApplicationProvider;
import com.hcl.appscan.sdk.auth.IASEAuthenticationProvider;
import com.hcl.appscan.sdk.auth.IAuthenticationProvider;
import com.hcl.appscan.sdk.configuration.ase.ConfigurationProviderFactory;
import com.hcl.appscan.sdk.configuration.ase.IComponent;
import com.hcl.appscan.sdk.error.InvalidTargetException;
import com.hcl.appscan.sdk.error.ScannerException;
import com.hcl.appscan.sdk.logging.IProgress;
import com.hcl.appscan.sdk.logging.Message;
import com.hcl.appscan.sdk.logging.StdOutProgress;
import com.hcl.appscan.sdk.results.ASEResultsProvider;
import com.hcl.appscan.sdk.results.IResultsProvider;
import com.hcl.appscan.sdk.scan.IScan;
import com.hcl.appscan.sdk.utils.SystemUtil;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.AutoCompletionCandidates;
import hudson.model.BuildListener;
import hudson.model.ItemGroup;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import hudson.util.VariableResolver;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringEscapeUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.remoting.RoleChecker;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class AppScanEnterpriseBuildStep
extends Builder
implements SimpleBuildStep,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String ASE_DYNAMIC_ANALYZER = "AppScan Enterprise Dynamic Analyzer";
    private static final String SHOW_ALL = "Show All";
    private String m_credentials;
    private String m_application;
    private String m_target;
    private String m_folder;
    private String m_testPolicy;
    private String m_template;
    private String m_agent;
    private String m_jobName;
    private boolean m_email;
    private boolean m_wait;
    private boolean m_failBuild;
    private List<FailureCondition> m_failureConditions;
    private String m_loginType;
    private String m_trafficFile;
    private String m_userName;
    private Secret m_password;
    private String m_exploreData;
    private String m_scanType;
    private String m_testOptimization;
    private String m_scanStatus;
    private String m_description;
    private String m_contact;
    private ScanMode m_scanMode;
    private IAuthenticationProvider m_authProvider;
    private static final File JENKINS_INSTALL_DIR = new File(System.getProperty("user.dir"), ".appscan");

    @DataBoundConstructor
    public AppScanEnterpriseBuildStep(ScanMode scanMode, String credentials, String folder, String testPolicy, String template, String jobName) {
        this.m_scanMode = scanMode;
        this.m_credentials = credentials;
        this.m_application = "";
        this.m_target = "";
        this.m_folder = this.getDescriptor().getFolderId(folder);
        this.m_testPolicy = testPolicy;
        this.m_template = this.getDescriptor().getTemplateId(template);
        this.m_agent = "";
        this.m_jobName = jobName == null || jobName.trim().equals("") ? String.valueOf(ThreadLocalRandom.current().nextInt(0, 10000)) : jobName;
        this.m_email = false;
        this.m_wait = false;
        this.m_failBuild = false;
        this.m_loginType = "";
        this.m_trafficFile = "";
        this.m_userName = "";
        this.m_password = Secret.fromString((String)"");
        this.m_exploreData = "";
        this.m_scanType = "";
        this.m_testOptimization = "";
        this.m_description = "";
        this.m_contact = "";
    }

    public String getCredentials() {
        Jenkins jenkins;
        if (this.m_credentials != null && !this.m_credentials.isEmpty() && this.getDescriptor().folderMap == null && this.getDescriptor().applicationMap == null && this.getDescriptor().templateMap == null && (jenkins = Jenkins.getInstanceOrNull()) != null) {
            this.getDescriptor().setAutoCompleteList(this.m_credentials, (ItemGroup<?>)jenkins.getItemGroup());
        }
        return this.m_credentials;
    }

    public String getFolder() {
        if (this.getDescriptor().folderMap != null && this.getDescriptor().folderMap.get(this.m_folder) != null) {
            String folder = StringEscapeUtils.unescapeHtml((String)this.getDescriptor().folderMap.get(this.m_folder));
            return folder;
        }
        return this.m_folder;
    }

    public String getTestPolicy() {
        return this.m_testPolicy;
    }

    public String getTemplate() {
        if (this.getDescriptor().templateMap != null && this.getDescriptor().templateMap.get(this.m_template) != null) {
            String template = StringEscapeUtils.unescapeHtml((String)this.getDescriptor().templateMap.get(this.m_template));
            return template;
        }
        return this.m_template;
    }

    public String getJobName() {
        return this.m_jobName;
    }

    @DataBoundSetter
    public void setApplication(String application) {
        this.m_application = this.getDescriptor().getApplicationId(application);
    }

    public String getApplication() {
        if (this.getDescriptor().applicationMap != null && this.getDescriptor().applicationMap.get(this.m_application) != null) {
            String appName = StringEscapeUtils.unescapeHtml((String)this.getDescriptor().applicationMap.get(this.m_application));
            return appName;
        }
        return this.m_application;
    }

    @DataBoundSetter
    public void setTarget(String target) {
        this.m_target = target;
    }

    public String getTarget() {
        return this.m_target;
    }

    @DataBoundSetter
    public void setLoginType(String loginType) {
        this.m_loginType = loginType;
    }

    public String getLoginType() {
        return this.m_loginType;
    }

    @DataBoundSetter
    public void setTrafficFile(String trafficFile) {
        if ("Manual".equals(this.m_loginType)) {
            this.m_trafficFile = trafficFile;
        }
    }

    public String getTrafficFile() {
        return this.m_trafficFile;
    }

    @DataBoundSetter
    public void setAccessId(String userName) {
        this.m_userName = userName;
    }

    public String getAccessId() {
        return this.m_userName;
    }

    @DataBoundSetter
    public void setSecretKey(String password) {
        this.m_password = Secret.fromString((String)password);
    }

    public String getSecretKey() {
        return Secret.toString((Secret)this.m_password);
    }

    @DataBoundSetter
    public void setExploreData(String exploreData) {
        this.m_exploreData = exploreData;
    }

    public String getExploreData() {
        return this.m_exploreData;
    }

    @DataBoundSetter
    public void setScanType(String scanType) {
        this.m_scanType = scanType;
    }

    public String getScanType() {
        return this.m_scanType;
    }

    public ScanMode getScanMode() {
        return this.m_scanMode;
    }

    @DataBoundSetter
    public void setTestOptimization(String testOptimization) {
        this.m_testOptimization = testOptimization;
    }

    public String getTestOptimization() {
        return this.m_testOptimization;
    }

    @DataBoundSetter
    public void setAgent(String agent) {
        this.m_agent = agent;
    }

    public String getAgent() {
        return this.m_agent;
    }

    @DataBoundSetter
    public void setEmail(boolean email) {
        this.m_email = email;
    }

    public boolean getEmail() {
        return this.m_email;
    }

    @DataBoundSetter
    public void setWait(boolean wait) {
        this.m_wait = wait;
    }

    public boolean getWait() {
        return this.m_wait;
    }

    @DataBoundSetter
    public void setFailBuild(boolean failBuild) {
        this.m_failBuild = failBuild;
    }

    public boolean getFailBuild() {
        return this.m_failBuild;
    }

    @DataBoundSetter
    public void setDescription(String description) {
        this.m_description = description;
    }

    public String getDescription() {
        return this.m_description;
    }

    @DataBoundSetter
    public void setContact(String contact) {
        this.m_contact = contact;
    }

    public String getContact() {
        return this.m_contact;
    }

    @DataBoundSetter
    public void setFailureConditions(List<FailureCondition> failureConditions) {
        this.m_failureConditions = failureConditions;
    }

    public List<FailureCondition> getFailureConditions() {
        if (this.m_failureConditions == null) {
            return new ArrayList<FailureCondition>();
        }
        return this.m_failureConditions;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    protected Object readResolve() {
        if (this.m_scanMode == null && this.m_scanType != null) {
            this.m_scanMode = ScanModeFactory.getScanTypeMode(this.m_scanType, this.m_loginType, this.m_userName, Secret.toString((Secret)this.m_password), this.m_trafficFile, this.m_exploreData);
        }
        return this;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        this.performScan((Run<?, ?>)build, launcher, (TaskListener)listener);
        return true;
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        this.performScan(run, launcher, listener);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public String isTestOptimization(String testOptimizationLevel) {
        if (this.m_testOptimization != null) {
            return this.m_testOptimization.equalsIgnoreCase(testOptimizationLevel) ? "true" : "";
        }
        if (testOptimizationLevel.equals("1")) {
            return "true";
        }
        return "";
    }

    private Map<String, String> getScanProperties(Run<?, ?> build, TaskListener listener) {
        BuildVariableResolver resolver = build instanceof AbstractBuild ? new BuildVariableResolver((AbstractBuild)build, listener) : null;
        Map<String, String> properties = new HashMap<String, String>();
        properties.put("type", ASE_DYNAMIC_ANALYZER);
        properties.put("credentials", this.m_credentials);
        properties.put("testPolicyId", this.m_testPolicy);
        properties.put("agentServer", this.m_agent);
        properties.put("testOptimization", this.m_testOptimization);
        properties.put("EnableMailNotification", Boolean.toString(this.m_email));
        if (resolver == null) {
            properties.put("application", this.m_application);
            properties.put("startingURL", this.m_target);
            properties.put("folder", this.m_folder);
            properties.put("templateId", this.m_template);
            properties.put("ScanName", this.m_jobName + "_" + SystemUtil.getTimeStamp());
            properties.put("description", this.m_description);
            properties.put("contact", this.m_contact);
        } else {
            properties.put("application", Util.replaceMacro((String)this.m_application, (VariableResolver)resolver));
            properties.put("startingURL", Util.replaceMacro((String)this.m_target, (VariableResolver)resolver));
            properties.put("folder", Util.replaceMacro((String)this.m_folder, (VariableResolver)resolver));
            properties.put("templateId", Util.replaceMacro((String)this.m_template, (VariableResolver)resolver));
            properties.put("ScanName", Util.replaceMacro((String)this.m_jobName, (VariableResolver)resolver) + "_" + SystemUtil.getTimeStamp());
            properties.put("description", Util.replaceMacro((String)this.m_description, (VariableResolver)resolver));
            properties.put("contact", Util.replaceMacro((String)this.m_contact, (VariableResolver)resolver));
        }
        properties = this.m_scanMode.configureScanProperties(properties, resolver);
        return properties;
    }

    private void shouldFailBuild(IResultsProvider provider, Run<?, ?> build) throws AbortException, IOException {
        if (!this.m_failBuild) {
            return;
        }
        String failureMessage = Messages.error_threshold_exceeded();
        try {
            List<FailureCondition> failureConditions = this.m_failureConditions;
            if (new ResultsInspector(failureConditions, provider).shouldFail()) {
                build.setDescription(failureMessage);
                throw new AbortException(failureMessage);
            }
        }
        catch (NullPointerException e) {
            throw new AbortException(Messages.error_checking_results(provider.getStatus()));
        }
    }

    private boolean checkURLAccessibility(String URL2) throws IOException {
        try {
            URL url = new URL(URL2);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            int responseCode = conn.getResponseCode();
            return responseCode >= 200 && responseCode < 300;
        }
        catch (Exception e) {
            throw new AbortException(Messages.error_url_validation(this.m_target));
        }
    }

    private String getUpdatedApplicationId(Map<String, String> application) {
        if (application != null) {
            for (Map.Entry<String, String> entry : application.entrySet()) {
                String appName = StringEscapeUtils.unescapeHtml((String)entry.getValue());
                if (appName == null || !appName.equals(this.m_application)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    private void performScan(Run<?, ?> build, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        String application;
        this.readResolve();
        Map<String, String> properties = this.getScanProperties(build, listener);
        if (this.m_target != null && !this.m_target.isEmpty() && !this.checkURLAccessibility(this.m_target)) {
            throw new AbortException(Messages.error_url_validation(this.m_target));
        }
        this.m_authProvider = new ASEJenkinsAuthenticationProvider(properties.get("credentials"), build.getParent().getParent());
        final ScanProgress progress = new ScanProgress(listener);
        final boolean suspend = this.m_wait;
        if (this.m_application.equals(this.getApplication())) {
            IASEAuthenticationProvider authProvider = (IASEAuthenticationProvider)this.m_authProvider;
            Map appList = new ASEApplicationProvider(authProvider).getApplications();
            this.m_application = this.getUpdatedApplicationId(appList);
            properties.put("application", this.m_application);
            this.getDescriptor().applicationMap = appList;
        }
        final IScan scan = ScanFactory.createScan(properties, progress, this.m_authProvider);
        IResultsProvider provider = (IResultsProvider)launcher.getChannel().call((Callable)new Callable<IResultsProvider, AbortException>(){
            private static final long serialVersionUID = 1L;

            public void checkRoles(RoleChecker arg0) {
            }

            public IResultsProvider call() throws AbortException {
                try {
                    AppScanEnterpriseBuildStep.this.setInstallDir();
                    scan.run();
                    ASEResultsProvider provider = new ASEResultsProvider(scan.getScanId(), scan.getType(), scan.getServiceProvider(), progress, scan.getName());
                    provider.setReportFormat(scan.getReportFormat());
                    try {
                        String ASE_SCAN_STATS = "/Jobs/QuickScanStats.aspx?fiid=%s";
                        URL url = new URL(AppScanEnterpriseBuildStep.this.m_authProvider.getServer() + String.format(ASE_SCAN_STATS, scan.getScanId()));
                        progress.setStatus(new Message(0, Messages.logs_link(scan.getScanId(), new URL(url.getProtocol(), url.getHost(), url.getFile()).toString())));
                    }
                    catch (MalformedURLException e) {
                        progress.setStatus(new Message(2, Messages.error_malformed_url(AppScanEnterpriseBuildStep.this.m_authProvider.getServer())));
                    }
                    if (suspend) {
                        progress.setStatus(new Message(0, Messages.analysis_running()));
                        AppScanEnterpriseBuildStep.this.m_scanStatus = provider.getStatus();
                        while (!(AppScanEnterpriseBuildStep.this.m_scanStatus == null || AppScanEnterpriseBuildStep.this.m_scanStatus.equalsIgnoreCase("Ready") || AppScanEnterpriseBuildStep.this.m_scanStatus.equalsIgnoreCase("Failed") || AppScanEnterpriseBuildStep.this.m_scanStatus.startsWith("Suspended"))) {
                            Thread.sleep(60000L);
                            AppScanEnterpriseBuildStep.this.m_scanStatus = provider.getStatus();
                        }
                    }
                    return provider;
                }
                catch (InvalidTargetException | ScannerException | InterruptedException e) {
                    progress.setStatus(new Message(0, Messages.label_ase_homepage() + ": " + AppScanEnterpriseBuildStep.this.m_authProvider.getServer()));
                    throw new AbortException(Messages.error_running_scan(e.getLocalizedMessage()));
                }
            }
        });
        if (suspend && this.m_scanStatus == null) {
            this.m_scanStatus = provider.getStatus();
        }
        if ("Failed".equalsIgnoreCase(this.m_scanStatus)) {
            Object message = com.hcl.appscan.sdk.Messages.getMessage((String)"error.scan.failed", (Object[])new Object[]{" Scan Name: " + scan.getName()});
            if (provider.getMessage() != null && provider.getMessage().trim().length() > 0) {
                message = (String)message + ", " + provider.getMessage();
            }
            build.setDescription((String)message);
            throw new AbortException(com.hcl.appscan.sdk.Messages.getMessage((String)"error.scan.failed", (Object[])new Object[]{" Scan Id: " + scan.getScanId() + ", Scan Name: " + scan.getName()}));
        }
        provider.setProgress((IProgress)new StdOutProgress());
        Object aseScanUrl = this.m_authProvider.getServer();
        String label = Messages.label_ase_homepage();
        BuildVariableResolver resolver = build instanceof AbstractBuild ? new BuildVariableResolver((AbstractBuild)build, listener) : null;
        String string = application = resolver == null ? this.m_application : Util.replaceMacro((String)this.m_application, (VariableResolver)resolver);
        if (application != null && application.trim().length() > 0) {
            String applicationUrl = "/api/pages/applications.html#appProfile/%s/issues";
            aseScanUrl = (String)aseScanUrl + String.format(applicationUrl, application);
            label = Messages.label_ase_application();
        }
        build.addAction((Action)new ResultsRetriever(build, provider, resolver == null ? this.m_jobName : Util.replaceMacro((String)this.m_jobName, (VariableResolver)resolver), (String)aseScanUrl, label));
        if (this.m_wait) {
            this.shouldFailBuild(provider, build);
        }
    }

    private void setInstallDir() {
        if (SystemUtil.isWindows() && System.getProperty("user.home").toLowerCase().indexOf("system32") >= 0) {
            System.setProperty("SAClientInstall", JENKINS_INSTALL_DIR.getPath());
        }
    }

    @Symbol(value={"appscanenterprise"})
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private List<Map.Entry<String, String>> sortedTemplateList = null;
        private List<Map.Entry<String, String>> sortedFolderList = null;
        private List<Map.Entry<String, String>> sortedApplicationList = null;
        private Map<String, String> templateMap = null;
        private Map<String, String> folderMap = null;
        private Map<String, String> applicationMap = null;

        public boolean isApplicable(Class<? extends AbstractProject> projectType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.label_asebuild_step();
        }

        public ListBoxModel doFillCredentialsItems(@QueryParameter String credentials, @AncestorInPath ItemGroup<?> context) {
            ListBoxModel model = new ListBoxModel();
            List credentialsList = CredentialsProvider.lookupCredentials(ASECredentials.class, context, (Authentication)ACL.SYSTEM, Collections.emptyList());
            boolean hasSelected = false;
            for (ASECredentials creds : credentialsList) {
                Object displayName;
                if (creds.getId().equals(credentials)) {
                    hasSelected = true;
                }
                displayName = (displayName = creds.getDescription()) == null || ((String)displayName).equals("") ? creds.getUsername() + "/******" : displayName;
                model.add((Object)new ListBoxModel.Option((String)displayName, creds.getId(), creds.getId().equals(credentials)));
            }
            if (!hasSelected) {
                model.add((Object)new ListBoxModel.Option("", "", true));
                this.sortedTemplateList = null;
                this.sortedFolderList = null;
                this.sortedApplicationList = null;
                this.templateMap = null;
                this.folderMap = null;
                this.applicationMap = null;
            } else {
                this.setAutoCompleteList(credentials, context);
            }
            return model;
        }

        public AutoCompletionCandidates doAutoCompleteApplication(@QueryParameter String value) {
            AutoCompletionCandidates model = new AutoCompletionCandidates();
            if (this.sortedApplicationList != null) {
                for (Map.Entry<String, String> entry : this.sortedApplicationList) {
                    String appName = StringEscapeUtils.unescapeHtml((String)entry.getValue());
                    if (value.equals(AppScanEnterpriseBuildStep.SHOW_ALL)) {
                        model.add(appName);
                        continue;
                    }
                    if (appName == null || !appName.toLowerCase().contains(value.toLowerCase())) continue;
                    model.add(appName);
                }
            }
            return model;
        }

        public AutoCompletionCandidates doAutoCompleteFolder(@QueryParameter String value) {
            AutoCompletionCandidates model = new AutoCompletionCandidates();
            if (this.sortedFolderList != null) {
                for (Map.Entry<String, String> entry : this.sortedFolderList) {
                    String folderName = StringEscapeUtils.unescapeHtml((String)entry.getValue());
                    if (value.equals(AppScanEnterpriseBuildStep.SHOW_ALL)) {
                        model.add(folderName);
                        continue;
                    }
                    if (folderName == null || !folderName.toLowerCase().contains(value.toLowerCase())) continue;
                    model.add(folderName);
                }
            }
            return model;
        }

        public ListBoxModel doFillTestPolicyItems(@QueryParameter String credentials, @AncestorInPath ItemGroup<?> context) {
            ASEJenkinsAuthenticationProvider authProvider = new ASEJenkinsAuthenticationProvider(credentials, context);
            IComponent componentProvider = ConfigurationProviderFactory.getScanner((String)"TestPolicies", (IASEAuthenticationProvider)authProvider);
            Map items = componentProvider.getComponents();
            ListBoxModel model = new ListBoxModel();
            if (items != null) {
                List<Map.Entry<String, String>> list = this.sortComponents(items.entrySet());
                for (Map.Entry<String, String> entry : list) {
                    model.add(entry.getValue(), entry.getKey());
                }
            }
            return model;
        }

        public AutoCompletionCandidates doAutoCompleteTemplate(@QueryParameter String value) {
            AutoCompletionCandidates model = new AutoCompletionCandidates();
            if (this.sortedTemplateList != null) {
                for (Map.Entry<String, String> entry : this.sortedTemplateList) {
                    String templateName = StringEscapeUtils.unescapeHtml((String)entry.getValue());
                    if (value.equals(AppScanEnterpriseBuildStep.SHOW_ALL)) {
                        model.add(templateName);
                        continue;
                    }
                    if (templateName == null || !templateName.toLowerCase().contains(value.toLowerCase())) continue;
                    model.add(templateName);
                }
            }
            return model;
        }

        public ListBoxModel doFillAgentItems(@QueryParameter String credentials, @AncestorInPath ItemGroup<?> context) {
            ASEJenkinsAuthenticationProvider authProvider = new ASEJenkinsAuthenticationProvider(credentials, context);
            IComponent componentProvider = ConfigurationProviderFactory.getScanner((String)"Agent", (IASEAuthenticationProvider)authProvider);
            Map items = componentProvider.getComponents();
            ListBoxModel model = new ListBoxModel();
            model.add("");
            if (items != null) {
                List<Map.Entry<String, String>> list = this.sortComponents(items.entrySet());
                for (Map.Entry<String, String> entry : list) {
                    model.add(entry.getValue(), entry.getKey());
                }
            }
            return model;
        }

        private List<Map.Entry<String, String>> sortComponents(Set<Map.Entry<String, String>> set) {
            ArrayList<Map.Entry<String, String>> list = new ArrayList<Map.Entry<String, String>>(set);
            if (list.size() > 1) {
                Collections.sort(list, new Comparator<Map.Entry<String, String>>(){

                    @Override
                    public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                        return o1.getValue().toLowerCase().compareTo(o2.getValue().toLowerCase());
                    }
                });
            }
            return list;
        }

        public FormValidation doCheckCredentials(@QueryParameter String credentials, @AncestorInPath ItemGroup<?> context) {
            if (credentials.trim().equals("")) {
                return FormValidation.errorWithMarkup((String)Messages.error_no_creds_ase("/credentials"));
            }
            ASEJenkinsAuthenticationProvider authProvider = new ASEJenkinsAuthenticationProvider(credentials, context);
            if (authProvider.isTokenExpired()) {
                return FormValidation.errorWithMarkup((String)Messages.error_token_expired("/credentials"));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckTemplate(@QueryParameter String template) {
            return FormValidation.validateRequired((String)template);
        }

        public FormValidation doCheckFolder(@QueryParameter String folder) {
            return FormValidation.validateRequired((String)folder);
        }

        public FormValidation doCheckTestPolicy(@QueryParameter String testPolicy) {
            return FormValidation.validateRequired((String)testPolicy);
        }

        public FormValidation doCheckJobName(@QueryParameter String jobName) {
            return FormValidation.validateRequired((String)jobName);
        }

        private void setAutoCompleteList(String credentials, ItemGroup<?> context) {
            ASEJenkinsAuthenticationProvider authProvider = new ASEJenkinsAuthenticationProvider(credentials, context);
            IComponent folderComponentProvider = ConfigurationProviderFactory.getScanner((String)"Folder", (IASEAuthenticationProvider)authProvider);
            this.folderMap = folderComponentProvider.getComponents();
            this.sortedFolderList = this.folderMap != null ? this.sortComponents(this.folderMap.entrySet()) : null;
            IComponent templateComponentProvider = ConfigurationProviderFactory.getScanner((String)"Template", (IASEAuthenticationProvider)authProvider);
            this.templateMap = templateComponentProvider.getComponents();
            this.sortedTemplateList = this.templateMap != null ? this.sortComponents(this.templateMap.entrySet()) : null;
            this.applicationMap = new ASEApplicationProvider((IASEAuthenticationProvider)authProvider).getApplications();
            this.sortedApplicationList = this.applicationMap != null ? this.sortComponents(this.applicationMap.entrySet()) : null;
        }

        private String getApplicationId(String application) {
            if (this.sortedApplicationList != null) {
                for (Map.Entry<String, String> entry : this.sortedApplicationList) {
                    String appName = StringEscapeUtils.unescapeHtml((String)entry.getValue());
                    if (appName == null || !appName.equals(application)) continue;
                    return entry.getKey();
                }
            }
            return application;
        }

        private String getFolderId(String folder) {
            if (this.sortedFolderList != null) {
                for (Map.Entry<String, String> entry : this.sortedFolderList) {
                    String folderName = StringEscapeUtils.unescapeHtml((String)entry.getValue());
                    if (folderName == null || !folderName.equals(folder)) continue;
                    return entry.getKey();
                }
            }
            return folder;
        }

        private String getTemplateId(String template) {
            if (this.sortedTemplateList != null) {
                for (Map.Entry<String, String> entry : this.sortedTemplateList) {
                    String templateName = StringEscapeUtils.unescapeHtml((String)entry.getValue());
                    if (templateName == null || !templateName.equals(template)) continue;
                    return entry.getKey();
                }
            }
            return template;
        }
    }
}

