/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.jenkins.plugin.builders;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.hcl.appscan.jenkins.plugin.Messages;
import com.hcl.appscan.jenkins.plugin.ScanFactory;
import com.hcl.appscan.jenkins.plugin.actions.ResultsRetriever;
import com.hcl.appscan.jenkins.plugin.auth.ASoCCredentials;
import com.hcl.appscan.jenkins.plugin.auth.JenkinsAuthenticationProvider;
import com.hcl.appscan.jenkins.plugin.results.FailureCondition;
import com.hcl.appscan.jenkins.plugin.results.ResultsInspector;
import com.hcl.appscan.jenkins.plugin.scanners.DynamicAnalyzer;
import com.hcl.appscan.jenkins.plugin.scanners.Scanner;
import com.hcl.appscan.jenkins.plugin.scanners.ScannerFactory;
import com.hcl.appscan.jenkins.plugin.scanners.SoftwareCompositionAnalyzer;
import com.hcl.appscan.jenkins.plugin.scanners.StaticAnalyzer;
import com.hcl.appscan.jenkins.plugin.util.BuildVariableResolver;
import com.hcl.appscan.jenkins.plugin.util.JenkinsUtil;
import com.hcl.appscan.jenkins.plugin.util.ScanProgress;
import com.hcl.appscan.sdk.app.CloudApplicationProvider;
import com.hcl.appscan.sdk.auth.IAuthenticationProvider;
import com.hcl.appscan.sdk.error.InvalidTargetException;
import com.hcl.appscan.sdk.error.ScannerException;
import com.hcl.appscan.sdk.logging.IProgress;
import com.hcl.appscan.sdk.logging.Message;
import com.hcl.appscan.sdk.logging.StdOutProgress;
import com.hcl.appscan.sdk.results.CloudResultsProvider;
import com.hcl.appscan.sdk.results.IResultsProvider;
import com.hcl.appscan.sdk.scan.CloudScanServiceProvider;
import com.hcl.appscan.sdk.scan.IScan;
import com.hcl.appscan.sdk.utils.SystemUtil;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.VariableResolver;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.acegisecurity.Authentication;
import org.jenkinsci.Symbol;
import org.jenkinsci.remoting.RoleChecker;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class AppScanBuildStep
extends Builder
implements SimpleBuildStep,
Serializable {
    private static final long serialVersionUID = 1L;
    private Scanner m_scanner;
    private String m_name;
    private String m_type;
    private String m_target;
    private String m_application;
    private String m_credentials;
    private List<FailureCondition> m_failureConditions;
    private boolean m_emailNotification;
    private boolean m_personalScan;
    private boolean m_intervention;
    private boolean m_wait;
    private boolean m_failBuildNonCompliance;
    private boolean m_failBuild;
    private String m_scanStatus;
    private IAuthenticationProvider m_authProvider;
    private static final File JENKINS_INSTALL_DIR = new File(System.getProperty("user.dir"), ".appscan");

    @Deprecated
    public AppScanBuildStep(Scanner scanner, String name, String type, String target, String application, String credentials, List<FailureCondition> failureConditions, boolean failBuildNonCompliance, boolean failBuild, boolean wait, boolean email, boolean personalScan, boolean intervention) {
        this.m_scanner = scanner;
        this.m_name = name == null || name.trim().equals("") ? application.replaceAll(" ", "") + ThreadLocalRandom.current().nextInt(0, 10000) : name;
        this.m_type = scanner.getType();
        this.m_target = target;
        this.m_application = application;
        this.m_credentials = credentials;
        this.m_failureConditions = failureConditions;
        this.m_emailNotification = email;
        this.m_personalScan = personalScan;
        this.m_intervention = intervention;
        this.m_wait = wait;
        this.m_failBuildNonCompliance = failBuildNonCompliance;
        this.m_failBuild = failBuild;
    }

    @DataBoundConstructor
    public AppScanBuildStep(Scanner scanner, String name, String type, String application, String credentials) {
        this.m_scanner = scanner;
        this.m_name = name == null || name.trim().equals("") ? application.replaceAll(" ", "") + ThreadLocalRandom.current().nextInt(0, 10000) : name;
        this.m_type = scanner.getType();
        this.m_target = "";
        this.m_application = application;
        this.m_credentials = credentials;
        this.m_emailNotification = false;
        this.m_personalScan = false;
        this.m_intervention = true;
        this.m_wait = false;
        this.m_failBuildNonCompliance = false;
        this.m_failBuild = false;
    }

    public Scanner getScanner() {
        return this.m_scanner;
    }

    public String getName() {
        return this.m_name;
    }

    public String getType() {
        return this.m_type;
    }

    @DataBoundSetter
    public void setTarget(String target) {
        this.m_target = target;
    }

    public String getTarget() {
        return this.m_target;
    }

    public String getApplication() {
        return this.m_application;
    }

    public String getCredentials() {
        return this.m_credentials;
    }

    @DataBoundSetter
    public void setFailureConditions(List<FailureCondition> failureConditions) {
        this.m_failureConditions = failureConditions;
    }

    public List<FailureCondition> getFailureConditions() {
        if (this.m_failureConditions == null) {
            return new ArrayList<FailureCondition>();
        }
        return this.m_failureConditions;
    }

    @DataBoundSetter
    public void setFailBuild(boolean failBuild) {
        this.m_failBuild = failBuild;
    }

    public boolean getFailBuild() {
        return this.m_failBuild;
    }

    @DataBoundSetter
    public void setIntervention(boolean intervention) {
        this.m_intervention = intervention;
    }

    public boolean isIntervention() {
        return this.m_intervention;
    }

    @DataBoundSetter
    public void setWait(boolean wait) {
        this.m_wait = wait;
    }

    public boolean getWait() {
        return this.m_wait;
    }

    @DataBoundSetter
    public void setFailBuildNonCompliance(boolean failBuildNonCompliance) {
        this.m_failBuildNonCompliance = failBuildNonCompliance;
    }

    public boolean getFailBuildNonCompliance() {
        return this.m_failBuildNonCompliance;
    }

    @DataBoundSetter
    public void setEmail(boolean emailNotification) {
        this.m_emailNotification = emailNotification;
    }

    public boolean getEmail() {
        return this.m_emailNotification;
    }

    @DataBoundSetter
    public void setPersonalScan(boolean personalScan) {
        this.m_personalScan = personalScan;
    }

    public boolean getPersonalScan() {
        return this.m_personalScan;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        this.perform((Run<?, ?>)build, launcher, (TaskListener)listener);
        return true;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        this.perform(run, launcher, listener);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    protected Object readResolve() {
        if (this.m_scanner == null && this.m_type != null) {
            this.m_scanner = ScannerFactory.getScanner(this.m_type, this.m_target);
        }
        return this;
    }

    private Map<String, String> getScanProperties(Run<?, ?> build, TaskListener listener) throws AbortException {
        BuildVariableResolver resolver;
        BuildVariableResolver buildVariableResolver = resolver = build instanceof AbstractBuild ? new BuildVariableResolver((AbstractBuild)build, listener) : null;
        if (this.m_scanner == null) {
            throw new AbortException(Messages.error_mobile_analyzer());
        }
        Map<String, String> properties = this.m_scanner.getProperties(resolver);
        properties.put("type", this.m_scanner.getType());
        properties.put("AppId", this.m_application);
        properties.put("ScanName", (String)(resolver == null ? this.m_name : Util.replaceMacro((String)this.m_name, (VariableResolver)resolver) + "_" + SystemUtil.getTimeStamp()));
        properties.put("EnableMailNotification", Boolean.toString(this.m_emailNotification));
        properties.put("Personal", Boolean.toString(this.m_personalScan));
        properties.put("FullyAutomatic", Boolean.toString(!this.m_intervention));
        properties.put("APPSCAN_IRGEN_CLIENT", "Jenkins");
        properties.put("APPSCAN_CLIENT_VERSION", Jenkins.VERSION);
        properties.put("IRGEN_CLIENT_PLUGIN_VERSION", JenkinsUtil.getPluginVersion());
        properties.put("ClientType", ((JenkinsAuthenticationProvider)this.m_authProvider).isAppScan360() ? JenkinsUtil.getClientTypeUpdated() : JenkinsUtil.getClientType());
        properties.put("serverURL", this.m_authProvider.getServer());
        properties.put("acceptInvalidCerts", Boolean.toString(this.m_authProvider.getacceptInvalidCerts()));
        return properties;
    }

    private void shouldFailBuild(IResultsProvider provider, Run<?, ?> build, IProgress progress) throws AbortException, IOException {
        if (!this.m_failBuild && !this.m_failBuildNonCompliance) {
            return;
        }
        String failureMessage = Messages.error_threshold_exceeded();
        try {
            List<FailureCondition> failureConditions = this.m_failureConditions;
            progress.setStatus(new Message(0, Messages.fail_build_check()));
            if (this.m_failBuildNonCompliance) {
                failureConditions = new ArrayList<FailureCondition>();
                FailureCondition nonCompliantCondition = new FailureCondition("total", 0);
                failureConditions.add(nonCompliantCondition);
                failureMessage = Messages.error_noncompliant_issues();
            }
            if (new ResultsInspector(failureConditions, provider).shouldFail()) {
                build.setDescription(failureMessage);
                throw new AbortException(failureMessage);
            }
        }
        catch (NullPointerException e) {
            throw new AbortException(Messages.error_checking_results(provider.getStatus()));
        }
    }

    private void perform(Run<?, ?> build, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        this.m_authProvider = new JenkinsAuthenticationProvider(this.m_credentials, build.getParent().getParent());
        final ScanProgress progress = new ScanProgress(listener);
        final boolean suspend = this.m_wait;
        Map<String, String> properties = this.getScanProperties(build, listener);
        boolean isAppScan360 = ((JenkinsAuthenticationProvider)this.m_authProvider).isAppScan360();
        this.m_scanner.validateSettings((JenkinsAuthenticationProvider)this.m_authProvider, properties, progress, isAppScan360);
        if (properties.containsKey("openSourceOnly")) {
            progress.setStatus(new Message(1, Messages.warning_sca()));
            this.m_scanner = ScannerFactory.getScanner("Software Composition Analyzer", properties.get("target"));
            properties.put("type", "Software Composition Analyzer");
        }
        final IScan scan = ScanFactory.createScan(properties, progress, this.m_authProvider);
        IResultsProvider provider = (IResultsProvider)launcher.getChannel().call((Callable)new Callable<IResultsProvider, AbortException>(){
            private static final long serialVersionUID = 1L;

            public void checkRoles(RoleChecker arg0) {
            }

            public IResultsProvider call() throws AbortException {
                try {
                    AppScanBuildStep.this.setInstallDir();
                    scan.run();
                    IResultsProvider provider = scan.getResultsProvider(true);
                    provider.setReportFormat(scan.getReportFormat());
                    if (suspend) {
                        progress.setStatus(new Message(0, Messages.analysis_running()));
                        AppScanBuildStep.this.m_scanStatus = provider.getStatus();
                        int requestCounter = 0;
                        while (AppScanBuildStep.this.m_scanStatus != null && (AppScanBuildStep.this.m_scanStatus.equalsIgnoreCase("InQueue") || AppScanBuildStep.this.m_scanStatus.equalsIgnoreCase("Running") || AppScanBuildStep.this.m_scanStatus.equalsIgnoreCase("Unknown")) && requestCounter < 10) {
                            Thread.sleep(60000L);
                            requestCounter = AppScanBuildStep.this.m_scanStatus.equalsIgnoreCase("Unknown") ? ++requestCounter : 0;
                            AppScanBuildStep.this.m_scanStatus = provider.getStatus();
                        }
                    }
                    return provider;
                }
                catch (InvalidTargetException | ScannerException | InterruptedException e) {
                    throw new AbortException(Messages.error_running_scan(e.getLocalizedMessage()));
                }
            }
        });
        if (suspend && this.m_scanStatus == null) {
            this.m_scanStatus = provider.getStatus();
        }
        if ("Failed".equalsIgnoreCase(this.m_scanStatus)) {
            Object message = com.hcl.appscan.sdk.Messages.getMessage((String)"error.scan.failed", (Object[])new Object[]{" Scan Name: " + this.m_name});
            if (provider.getMessage() != null && provider.getMessage().trim().length() > 0) {
                message = (String)message + ", " + provider.getMessage();
            }
            build.setDescription((String)message);
            throw new AbortException(com.hcl.appscan.sdk.Messages.getMessage((String)"error.scan.failed", (Object[])new Object[]{"Scan Name: " + this.m_name}));
        }
        if ("Unknown".equalsIgnoreCase(this.m_scanStatus)) {
            progress.setStatus(new Message(2, Messages.error_server_unavailable() + " " + Messages.check_server(this.m_authProvider.getServer())));
            build.setDescription(Messages.error_server_unavailable());
            build.setResult(Result.UNSTABLE);
        } else {
            provider.setProgress((IProgress)new StdOutProgress());
            if (this.m_scanStatus != null && !this.m_scanStatus.isEmpty() && this.m_scanStatus.equalsIgnoreCase("Ready")) {
                progress.setStatus(new Message(0, Messages.scan_completion()));
            }
            progress.setStatus(new Message(0, this.m_type.equals("Software Composition Analyzer") ? Messages.report_location_sca(build.getRootDir().getAbsolutePath()) : Messages.scan_log_location(build.getRootDir().getAbsolutePath())));
            BuildVariableResolver resolver = build instanceof AbstractBuild ? new BuildVariableResolver((AbstractBuild)build, listener) : null;
            String asocAppUrl = this.m_authProvider.getServer() + "/main/myapps/" + this.m_application + "/scans/";
            String label = isAppScan360 ? Messages.label_appscan360_homepage() : Messages.label_asoc_homepage();
            build.addAction((Action)new ResultsRetriever(build, provider, resolver == null ? this.m_name : Util.replaceMacro((String)this.m_name, (VariableResolver)resolver), asocAppUrl, label));
            if (this.m_wait) {
                this.shouldFailBuild(provider, build, progress);
            }
            if (this.m_scanStatus != null && !this.m_scanStatus.isEmpty() && this.m_scanStatus.equalsIgnoreCase("PartialSuccess")) {
                throw new AbortException(Messages.error_scan_status_unstable());
            }
        }
    }

    private void setInstallDir() {
        if (SystemUtil.isWindows() && System.getProperty("user.home").toLowerCase().indexOf("system32") >= 0) {
            System.setProperty("SAClientInstall", JENKINS_INSTALL_DIR.getPath());
        }
    }

    @Symbol(value={"appscan"})
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        @Initializer(before=InitMilestone.PLUGINS_STARTED)
        public static void createAliases() {
            Items.XSTREAM2.addCompatibilityAlias("com.ibm.appscan.jenkins.plugin.builders.AppScanBuildStep", AppScanBuildStep.class);
            Items.XSTREAM2.addCompatibilityAlias("com.ibm.appscan.jenkins.plugin.scanners.StaticAnalyzer", StaticAnalyzer.class);
            Items.XSTREAM2.addCompatibilityAlias("com.ibm.appscan.jenkins.plugin.scanners.DynamicAnalyzer", DynamicAnalyzer.class);
            Items.XSTREAM2.addCompatibilityAlias("com.hcl.appscan.jenkins.plugin.scanners.SoftwareCompositionAnalyzer", SoftwareCompositionAnalyzer.class);
            Items.XSTREAM2.addCompatibilityAlias("com.hcl.appscan.plugin.core.results.CloudResultsProvider", CloudResultsProvider.class);
            Items.XSTREAM2.addCompatibilityAlias("com.hcl.appscan.plugin.core.scan.CloudScanServiceProvider", CloudScanServiceProvider.class);
        }

        public boolean isApplicable(Class<? extends AbstractProject> projectType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.label_build_step();
        }

        public ListBoxModel doFillCredentialsItems(@QueryParameter String credentials, @AncestorInPath ItemGroup<?> context) {
            ListBoxModel model = new ListBoxModel();
            List credentialsList = CredentialsProvider.lookupCredentials(ASoCCredentials.class, context, (Authentication)ACL.SYSTEM, Collections.emptyList());
            boolean hasSelected = false;
            for (ASoCCredentials creds : credentialsList) {
                Object displayName;
                if (creds.getId().equals(credentials)) {
                    hasSelected = true;
                }
                displayName = (displayName = creds.getDescription()) == null || ((String)displayName).equals("") ? creds.getUsername() + "/******" : displayName;
                model.add((Object)new ListBoxModel.Option((String)displayName, creds.getId(), creds.getId().equals(credentials)));
            }
            if (!hasSelected) {
                model.add((Object)new ListBoxModel.Option("", "", true));
            }
            return model;
        }

        public ListBoxModel doFillApplicationItems(@QueryParameter String credentials, @AncestorInPath ItemGroup<?> context) {
            JenkinsAuthenticationProvider authProvider = new JenkinsAuthenticationProvider(credentials, context);
            Map applications = new CloudApplicationProvider((IAuthenticationProvider)authProvider).getApplications();
            ListBoxModel model = new ListBoxModel();
            if (applications != null) {
                List<Map.Entry<String, String>> list = this.sortApplications(applications.entrySet());
                for (Map.Entry<String, String> entry : list) {
                    model.add(entry.getValue(), entry.getKey());
                }
            }
            return model;
        }

        private List<Map.Entry<String, String>> sortApplications(Set<Map.Entry<String, String>> set) {
            ArrayList<Map.Entry<String, String>> list = new ArrayList<Map.Entry<String, String>>(set);
            if (list.size() > 1) {
                Collections.sort(list, new Comparator<Map.Entry<String, String>>(){

                    @Override
                    public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                        return o1.getValue().toLowerCase().compareTo(o2.getValue().toLowerCase());
                    }
                });
            }
            return list;
        }

        public FormValidation doCheckCredentials(@QueryParameter String credentials, @AncestorInPath ItemGroup<?> context) {
            if (credentials.trim().equals("")) {
                return FormValidation.errorWithMarkup((String)Messages.error_no_creds("/credentials"));
            }
            JenkinsAuthenticationProvider authProvider = new JenkinsAuthenticationProvider(credentials, context);
            if (authProvider.isTokenExpired()) {
                return FormValidation.errorWithMarkup((String)Messages.error_token_expired("/credentials"));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckApplication(@QueryParameter String application, @QueryParameter String credentials, @AncestorInPath ItemGroup<?> context) {
            JenkinsAuthenticationProvider authProvider = new JenkinsAuthenticationProvider(credentials, context);
            Map applications = new CloudApplicationProvider((IAuthenticationProvider)authProvider).getApplications();
            if ((applications == null || applications.isEmpty()) && !credentials.equals("")) {
                return FormValidation.error((String)Messages.error_application_empty_ui());
            }
            return FormValidation.validateRequired((String)application);
        }

        public FormValidation doCheckIntervention(@QueryParameter Boolean intervention, @QueryParameter String credentials, @AncestorInPath ItemGroup<?> context) {
            JenkinsAuthenticationProvider checkAppScan360Connection = new JenkinsAuthenticationProvider(credentials, context);
            if (intervention.booleanValue() && checkAppScan360Connection.isAppScan360()) {
                return FormValidation.error((String)Messages.error_allow_intervention_ui());
            }
            return FormValidation.ok();
        }
    }
}

