/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.jenkins.plugin.auth;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.hcl.appscan.jenkins.plugin.auth.ASoCCredentials;
import com.hcl.appscan.jenkins.plugin.util.JenkinsUtil;
import com.hcl.appscan.sdk.auth.AuthenticationHandler;
import com.hcl.appscan.sdk.auth.IAuthenticationProvider;
import com.hcl.appscan.sdk.auth.LoginType;
import hudson.ProxyConfiguration;
import hudson.model.ItemGroup;
import hudson.util.Secret;
import java.io.IOException;
import java.io.Serializable;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import org.apache.wink.json4j.JSONException;

public class JenkinsAuthenticationProvider
implements IAuthenticationProvider,
Serializable {
    private static final long serialVersionUID = 1L;
    private ASoCCredentials m_credentials;

    public JenkinsAuthenticationProvider(String id, ItemGroup<?> context) {
        this.configureCredentials(id, context);
    }

    public boolean isTokenExpired() {
        boolean isExpired = false;
        AuthenticationHandler handler = new AuthenticationHandler((IAuthenticationProvider)this);
        if (!handler.isTokenExpired()) {
            return false;
        }
        try {
            String username = this.m_credentials.getUsername();
            String password = Secret.toString((Secret)this.m_credentials.getPassword());
            isExpired = this.isAppScan360() ? !handler.login(username, password, true, LoginType.ASoC_Federated, JenkinsUtil.getClientTypeUpdated()) : !handler.login(username, password, true, LoginType.ASoC_Federated, JenkinsUtil.getClientType());
            return isExpired;
        }
        catch (IOException | JSONException e) {
            return true;
        }
    }

    public Map<String, String> getAuthorizationHeader(boolean persist) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + this.getToken().trim());
        if (persist) {
            headers.put("Connection", "Keep-Alive");
        }
        return headers;
    }

    public String getServer() {
        return this.m_credentials.getServer();
    }

    public void saveConnection(String connection) {
        this.m_credentials.setToken(connection);
    }

    public Proxy getProxy() {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins == null) {
            return Proxy.NO_PROXY;
        }
        final ProxyConfiguration proxy = jenkins.proxy;
        if (proxy != null && proxy.name != null && proxy.port > 0) {
            if (proxy.getUserName() != null && proxy.getPassword() != null) {
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(proxy.getUserName(), proxy.getPassword().toCharArray());
                    }
                });
            }
            return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxy.name, proxy.port));
        }
        return Proxy.NO_PROXY;
    }

    private String getToken() {
        return Secret.toString((Secret)this.m_credentials.getToken());
    }

    public boolean isAppScan360() {
        String keyId = this.m_credentials.getUsername();
        return keyId.trim().startsWith("local");
    }

    public void configureCredentials(String id, ItemGroup<?> context) {
        List credentialsList = CredentialsProvider.lookupCredentials(ASoCCredentials.class, context, null, Collections.emptyList());
        for (ASoCCredentials creds : credentialsList) {
            if (!creds.getId().equals(id)) continue;
            this.m_credentials = creds;
            return;
        }
        this.m_credentials = new ASoCCredentials("", "", "", "", "", false);
    }

    public boolean getacceptInvalidCerts() {
        return this.m_credentials.getacceptInvalidCerts();
    }
}

