/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.jenkins.plugin.auth;

import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import com.hcl.appscan.jenkins.plugin.Messages;
import com.hcl.appscan.sdk.utils.SystemUtil;
import hudson.Extension;
import hudson.util.FormValidation;
import hudson.util.Secret;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ASoCCredentials
extends UsernamePasswordCredentialsImpl {
    private static final long serialVersionUID = 1L;
    private Secret m_token;
    public String m_url;
    public boolean m_acceptInvalidCerts;

    @DataBoundConstructor
    public ASoCCredentials(String id, String description, String username, String password, String url, boolean acceptInvalidCerts) {
        this(CredentialsScope.GLOBAL, id, description, username, password, acceptInvalidCerts);
        this.m_url = url;
        this.m_acceptInvalidCerts = acceptInvalidCerts;
    }

    public ASoCCredentials(CredentialsScope scope, String id, String description, String username, String password, boolean acceptInvalidCerts) {
        super(scope, description, description, username, password);
    }

    public CredentialsDescriptor getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public String getUrl() {
        return this.m_url;
    }

    public boolean getacceptInvalidCerts() {
        return this.m_acceptInvalidCerts;
    }

    public String getServer() {
        String url = this.m_url;
        if (url == null || url.equals("")) {
            url = SystemUtil.getServer((String)this.getUsername());
        }
        return url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
    }

    public Secret getToken() {
        return this.m_token;
    }

    public void setToken(String connection) {
        this.m_token = Secret.fromString((String)connection);
    }

    @Symbol(value={"asoc-credentials"})
    @Extension
    public static class DescriptorImpl
    extends CredentialsDescriptor {
        public String getDisplayName() {
            return Messages.label_asoc();
        }

        public String getApiKeyUrl() {
            return SystemUtil.getDefaultServer() + "/api/ideclientuilogin";
        }

        public FormValidation doCheckUsername(@QueryParameter String username) {
            if (username.trim().equals("")) {
                return FormValidation.errorWithMarkup((String)Messages.need_api_key(this.getApiKeyUrl()));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPassword(@QueryParameter String password) {
            return FormValidation.validateRequired((String)password);
        }

        public FormValidation doCheckAcceptInvalidCerts(@QueryParameter Boolean acceptInvalidCerts, @QueryParameter String username) {
            if (!username.trim().startsWith("local") && acceptInvalidCerts.booleanValue()) {
                return FormValidation.error((String)Messages.error_asoc_certificates_ui());
            }
            return FormValidation.ok();
        }
    }
}

