/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.jenkins.plugin.auth;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.hcl.appscan.jenkins.plugin.auth.ASECredentials;
import com.hcl.appscan.jenkins.plugin.util.ASESessionManager;
import com.hcl.appscan.sdk.auth.ASEAuthenticationHandler;
import com.hcl.appscan.sdk.auth.IASEAuthenticationProvider;
import hudson.model.ItemGroup;
import hudson.util.Secret;
import java.io.IOException;
import java.io.Serializable;
import java.net.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.wink.json4j.JSONException;

public class ASEJenkinsAuthenticationProvider
implements IASEAuthenticationProvider,
Serializable {
    private static final long serialVersionUID = 1L;
    private ASECredentials m_credentials;
    private static final transient Object m_object = new Object();
    private transient Boolean m_reloaded = true;

    public ASEJenkinsAuthenticationProvider(String id, ItemGroup<?> context) {
        List credentialsList = CredentialsProvider.lookupCredentials(ASECredentials.class, context, null, Collections.emptyList());
        for (ASECredentials creds : credentialsList) {
            if (!creds.getId().equals(id)) continue;
            this.m_credentials = creds;
            return;
        }
        this.m_credentials = new ASECredentials("", "", "", "", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTokenExpired() {
        boolean isExpired;
        block6: {
            isExpired = false;
            ASEAuthenticationHandler handler = new ASEAuthenticationHandler((IASEAuthenticationProvider)this);
            try {
                if (this.m_reloaded == null || this.m_reloaded.booleanValue()) {
                    this.m_credentials = ASESessionManager.getASECredentialObject(this.m_credentials);
                    this.m_reloaded = false;
                }
                if (!(isExpired = handler.isTokenExpired())) break block6;
                Object object = m_object;
                synchronized (object) {
                    isExpired = handler.isTokenExpired() && !handler.login(this.m_credentials.getUsername(), Secret.toString((Secret)this.m_credentials.getPassword()), true, this.m_credentials.getServer());
                }
            }
            catch (IOException | JSONException e) {
                isExpired = false;
            }
        }
        return isExpired;
    }

    public Map<String, String> getAuthorizationHeader(boolean persist) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("asc_xsrf_token", this.getToken().trim());
        List<String> cookies = this.getCookies();
        if (cookies != null) {
            headers.put("Cookie", cookies.get(0));
        }
        if (persist) {
            headers.put("Connection", "Keep-Alive");
        }
        return headers;
    }

    public String getServer() {
        return this.m_credentials.getServer();
    }

    public void saveConnection(String connection) {
        this.m_credentials.setToken(connection);
    }

    public void setCookies(List<String> cookies) {
        this.m_credentials.setCookies(cookies);
    }

    private String getToken() {
        return Secret.toString((Secret)this.m_credentials.getToken());
    }

    private List<String> getCookies() {
        return this.m_credentials.getCookies();
    }

    public Proxy getProxy() {
        return Proxy.NO_PROXY;
    }

    public boolean getacceptInvalidCerts() {
        return false;
    }
}

