/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.jenkins.plugin.actions;

import com.hcl.appscan.jenkins.plugin.Messages;
import com.hcl.appscan.jenkins.plugin.actions.AppScanAction;
import com.hcl.appscan.jenkins.plugin.actions.ResultsRetriever;
import com.hcl.appscan.jenkins.plugin.actions.ScanResults;
import hudson.model.Run;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class ScanResultsTrend
extends AppScanAction {
    private String m_type;
    private String m_name;

    @DataBoundConstructor
    public ScanResultsTrend(Run<?, ?> project, String type, String name) {
        super(project.getParent());
        this.m_type = type;
        this.m_name = name;
    }

    @Override
    public String getIconFileName() {
        if (this.getBuildCount() == 0 || this.getLatestResults() == null) {
            return null;
        }
        return super.getIconFileName();
    }

    @Override
    public String getUrlName() {
        ScanResults results = this.getLatestResults();
        if (results != null) {
            return results.getUrlName();
        }
        return null;
    }

    public String getDisplayName() {
        return Messages.label_latest_report(this.m_name);
    }

    public String getChartName() {
        return Messages.label_results_trend();
    }

    public int getBuildCount() {
        int count = 0;
        for (Run run : this.m_project.getBuilds()) {
            for (ResultsRetriever retriever : run.getActions(ResultsRetriever.class)) {
                retriever.checkResults(run);
            }
            for (ScanResults results : run.getActions(ScanResults.class)) {
                if (!results.getName().equals(this.m_name) || !results.getScanType().equals(this.m_type)) continue;
                ++count;
            }
        }
        return count;
    }

    public JSONObject getBuildFindingCounts() {
        JSONObject builds = new JSONObject();
        for (Run run : this.m_project.getBuilds()) {
            for (ScanResults results : run.getActions(ScanResults.class)) {
                String scanType = results.getScanType() + "-" + results.getName();
                try {
                    if (builds.containsKey((Object)scanType)) {
                        JSONObject scan = (JSONObject)builds.get(scanType);
                        scan.put(Integer.toString(run.number), results.getTotalFindings());
                        continue;
                    }
                    JSONObject build = new JSONObject();
                    build.put(Integer.toString(run.number), results.getTotalFindings());
                    builds.put(scanType, (Map)build);
                }
                catch (JSONException jSONException) {}
            }
        }
        return builds;
    }

    public void doDynamic(StaplerRequest request, StaplerResponse response) throws MalformedURLException, ServletException, IOException {
        ScanResults results = this.getLatestResults();
        if (results == null) {
            return;
        }
        File report = results.getReport();
        if (report.isFile()) {
            response.serveFile(request, report.toURI().toURL());
        }
    }

    private ScanResults getLatestResults() {
        for (Run run : this.m_project.getBuilds()) {
            for (ScanResults results : run.getActions(ScanResults.class)) {
                if (!results.getScanType().equalsIgnoreCase(this.m_type) || !results.getName().equalsIgnoreCase(this.m_name)) continue;
                return results;
            }
        }
        return null;
    }
}

