/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.jenkins.plugin.actions;

import com.hcl.appscan.jenkins.plugin.Messages;
import com.hcl.appscan.jenkins.plugin.actions.AppScanAction;
import com.hcl.appscan.jenkins.plugin.actions.ScanResultsTrend;
import com.hcl.appscan.sdk.results.IResultsProvider;
import com.hcl.appscan.sdk.utils.FileUtil;
import hudson.model.Action;
import hudson.model.Run;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.HashSet;
import javax.servlet.ServletException;
import jenkins.tasks.SimpleBuildStep;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class ScanResults
extends AppScanAction
implements SimpleBuildStep.LastBuildAction {
    private static final String REPORT_SUFFIX = "_report";
    private final Run<?, ?> m_build;
    private IResultsProvider m_provider;
    private String m_name;
    private String m_status;
    private String m_scanServerUrl;
    private String m_label;
    private int m_totalFindings;
    private int m_criticalCount;
    private int m_highCount;
    private int m_mediumCount;
    private int m_lowCount;
    private int m_infoCount;

    @DataBoundConstructor
    public ScanResults(Run<?, ?> build, IResultsProvider provider, String name, String status, int totalFindings, int criticalCount, int highCount, int mediumCount, int lowCount, int infoCount, String scanServerUrl, String label) {
        super(build.getParent());
        this.m_build = build;
        this.m_provider = provider;
        this.m_name = name;
        this.m_status = status;
        this.m_totalFindings = totalFindings;
        this.m_criticalCount = criticalCount;
        this.m_highCount = highCount;
        this.m_mediumCount = mediumCount;
        this.m_lowCount = lowCount;
        this.m_infoCount = infoCount;
        this.m_label = label;
        this.m_scanServerUrl = scanServerUrl;
        this.getReport();
    }

    public ScanResults(Run<?, ?> build, IResultsProvider provider, String name, String serverUrl, String label) {
        this(build, provider, name, provider.getStatus(), provider.getFindingsCount(), provider.getCriticalCount(), provider.getHighCount(), provider.getMediumCount(), provider.getLowCount(), provider.getInfoCount(), serverUrl, label);
    }

    @Override
    public String getUrlName() {
        return this.getReportName();
    }

    public String getDisplayName() {
        return Messages.label_results(this.m_name);
    }

    public Collection<? extends Action> getProjectActions() {
        HashSet<ScanResultsTrend> actions = new HashSet<ScanResultsTrend>();
        actions.add(new ScanResultsTrend(this.m_build, this.m_provider.getType(), this.m_name));
        return actions;
    }

    public Run<?, ?> getBuild() {
        return this.m_build;
    }

    public String getName() {
        return this.m_name;
    }

    public String getScanType() {
        return this.m_provider.getType();
    }

    public int getHighCount() {
        return this.m_highCount;
    }

    public int getMediumCount() {
        return this.m_mediumCount;
    }

    public int getLowCount() {
        return this.m_lowCount;
    }

    public int getCriticalCount() {
        return this.m_criticalCount;
    }

    public int getInfoCount() {
        return this.m_infoCount;
    }

    public int getTotalFindings() {
        return this.m_totalFindings;
    }

    public boolean getHasResults() {
        return !this.m_status.equalsIgnoreCase("Failed");
    }

    public boolean getFailed() {
        String status = this.m_status == null ? this.m_provider.getStatus() : this.m_status;
        return status.equalsIgnoreCase("Failed");
    }

    public String getScanServerUrl() {
        return this.m_scanServerUrl;
    }

    public String getLabel() {
        return this.m_label;
    }

    public boolean isBetterThanLast() {
        return this.getTotalFindings() < this.getLastFindingsCount();
    }

    public void doDynamic(StaplerRequest request, StaplerResponse response) throws MalformedURLException, ServletException, IOException {
        File report = this.getReport();
        if (report.isFile()) {
            response.serveFile(request, report.toURI().toURL());
        }
    }

    public File getReport() {
        File report = new File(this.m_build.getRootDir(), this.getReportName());
        if (!report.isFile()) {
            this.m_provider.getResultsFile(report, null);
        }
        return report;
    }

    private String getReportName() {
        String name = FileUtil.getValidFilename((String)this.getName()).replaceAll(" ", "");
        return name + "_report." + this.m_provider.getResultsFormat().toLowerCase();
    }

    private int getLastFindingsCount() {
        if (this.m_project.getLastSuccessfulBuild() != null && this.m_project.getLastSuccessfulBuild().getAction(ScanResults.class) != null) {
            return ((ScanResults)this.m_project.getLastSuccessfulBuild().getAction(ScanResults.class)).getTotalFindings();
        }
        return Integer.MAX_VALUE;
    }
}

