/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.jenkins.plugin.actions;

import com.hcl.appscan.jenkins.plugin.Messages;
import com.hcl.appscan.jenkins.plugin.actions.AppScanAction;
import com.hcl.appscan.jenkins.plugin.actions.ScanResultsFactory;
import com.hcl.appscan.jenkins.plugin.actions.ScanResultsTrend;
import com.hcl.appscan.jenkins.plugin.util.ExecutorUtil;
import com.hcl.appscan.sdk.results.CloudCombinedResultsProvider;
import com.hcl.appscan.sdk.results.IResultsProvider;
import com.hcl.appscan.sdk.results.NonCompliantIssuesResultProvider;
import com.hcl.appscan.sdk.utils.SystemUtil;
import hudson.model.Action;
import hudson.model.Run;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import jenkins.model.RunAction2;
import jenkins.tasks.SimpleBuildStep;
import org.kohsuke.stapler.DataBoundConstructor;

public class ResultsRetriever
extends AppScanAction
implements RunAction2,
SimpleBuildStep.LastBuildAction {
    private final Run<?, ?> m_build;
    private IResultsProvider m_provider;
    private String m_name;
    private String m_status;
    private String m_message;
    private String m_scanServerUrl;
    private String m_label;
    private transient Future<Boolean> futureTask = null;
    private Boolean m_resultsAvailable;

    @DataBoundConstructor
    public ResultsRetriever(Run<?, ?> build, IResultsProvider provider, String scanName, String scanServerUrl, String label) {
        super(build.getParent());
        this.m_build = build;
        this.m_provider = provider;
        this.m_name = scanName;
        this.m_resultsAvailable = false;
        this.m_scanServerUrl = scanServerUrl;
        this.m_label = label;
    }

    public String getDisplayName() {
        return Messages.label_running(this.m_name);
    }

    @Override
    public String getUrlName() {
        return null;
    }

    public void onAttached(Run<?, ?> r) {
    }

    public void onLoad(Run<?, ?> r) {
        this.checkResults(r);
    }

    public Collection<? extends Action> getProjectActions() {
        HashSet<ScanResultsTrend> actions = new HashSet<ScanResultsTrend>();
        actions.add(new ScanResultsTrend(this.m_build, this.m_provider.getType(), this.m_name));
        return actions;
    }

    public boolean getHasResults() {
        return this.checkResults(this.m_build);
    }

    public boolean getFailed() {
        return "Failed".equalsIgnoreCase(this.m_status);
    }

    public String getMessage() {
        return this.m_message;
    }

    public String getScanType() {
        if (this.m_provider == null) {
            return "";
        }
        return this.m_provider.getType();
    }

    public boolean checkResults(Run<?, ?> r) {
        boolean results = false;
        if (this.m_resultsAvailable != null && this.m_resultsAvailable.booleanValue()) {
            return true;
        }
        if (this.futureTask != null && this.futureTask.isDone()) {
            try {
                results = this.futureTask.get();
                this.m_resultsAvailable = results;
            }
            catch (Exception exception) {}
        } else if (this.futureTask != null) {
            return false;
        }
        if (!results) {
            final Run<?, ?> rTemp = r;
            Callable<Boolean> callableTask = new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    String status = null;
                    if (rTemp.getAllActions().contains(ResultsRetriever.this) && "Failed".equalsIgnoreCase(status = ResultsRetriever.this.m_provider.getStatus())) {
                        Object message = com.hcl.appscan.sdk.Messages.getMessage((String)"error.scan.failed", (Object[])new Object[]{" Scan Name: " + ResultsRetriever.this.m_name});
                        if (ResultsRetriever.this.m_provider.getMessage() != null && ResultsRetriever.this.m_provider.getMessage().trim().length() > 0) {
                            message = (String)message + ", " + ResultsRetriever.this.m_provider.getMessage();
                        }
                        ResultsRetriever.this.m_status = status;
                        ResultsRetriever.this.m_message = message;
                        return true;
                    }
                    if (rTemp.getAllActions().contains(ResultsRetriever.this) && ResultsRetriever.this.m_provider.hasResults()) {
                        rTemp.getActions().remove(ResultsRetriever.this);
                        ScanResultsFactory.createResult(rTemp, ResultsRetriever.this.m_build, ResultsRetriever.this.m_provider, ResultsRetriever.this.m_name, ResultsRetriever.this.m_scanServerUrl, ResultsRetriever.this.m_label);
                        ResultsRetriever.this.m_status = ResultsRetriever.this.m_provider.getStatus();
                        if (!ResultsRetriever.this.getScanType().equals("Software Composition Analyzer") && ResultsRetriever.this.m_status != null && !ResultsRetriever.this.m_status.isEmpty() && (ResultsRetriever.this.m_status.equalsIgnoreCase("Ready") || ResultsRetriever.this.m_status.equalsIgnoreCase("PartialSuccess"))) {
                            ResultsRetriever.this.downloadScanLogs();
                        }
                        try {
                            rTemp.save();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        ResultsRetriever.this.m_status = status;
                        return true;
                    }
                    if (ResultsRetriever.this.m_provider.getMessage() != null) {
                        ResultsRetriever.this.m_message = ResultsRetriever.this.m_provider.getMessage();
                    }
                    return false;
                }
            };
            this.futureTask = ExecutorUtil.submitTask(callableTask);
        }
        return results;
    }

    private void downloadScanLogs() {
        File file = new File(this.m_build.getRootDir(), "ScanLogs_" + this.m_name + "_" + SystemUtil.getTimeStamp() + ".zip");
        if (this.m_provider instanceof NonCompliantIssuesResultProvider) {
            ((NonCompliantIssuesResultProvider)this.m_provider).getScanLogs(file);
        } else if (this.m_provider instanceof CloudCombinedResultsProvider) {
            this.m_provider.getScanLogFile(file);
        }
    }
}

