/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ansicolor.action;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.console.ConsoleNote;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.plugins.ansicolor.action.ActionNote;
import hudson.plugins.ansicolor.action.ColorizedAction;
import hudson.plugins.ansicolor.action.LineIdentifier;
import hudson.util.VersionNumber;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;

public class ShortlogActionCreator {
    private static final Logger LOGGER = Logger.getLogger(ShortlogActionCreator.class.getName());
    private static final int CONSOLE_TAIL_DEFAULT = 150;
    private static final int BUFFER_SIZE = 16384;
    public static final VersionNumber LINES_WHOLE_SINCE_VERSION = new VersionNumber("2.260");
    static final String PROP_LINES_WHOLE = "jenkins.ansicolor.keepLinesWhole";
    private final LineIdentifier lineIdentifier;
    private final byte[] eol;

    public ShortlogActionCreator(LineIdentifier lineIdentifier, String eol) {
        this.lineIdentifier = lineIdentifier;
        this.eol = eol.getBytes(StandardCharsets.UTF_8);
    }

    public ColorizedAction createActionForShortlog(File logFile, Map<String, ColorizedAction> actions, int shortlogLimit, boolean keepLinesWhole, long reservedBytes) {
        ColorizedAction colorizedAction;
        ActionContext lastAction = this.findLastActionBefore(logFile, actions.keySet(), shortlogLimit, keepLinesWhole, reservedBytes);
        if (!lastAction.isEmpty() && ColorizedAction.Command.START.equals((Object)(colorizedAction = actions.get(lastAction.serializedAction)).getCommand())) {
            return new ColorizedAction(this.lineIdentifier.hash(ConsoleNote.removeNotes((String)lastAction.line), 1L), colorizedAction);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ActionContext findLastActionBefore(File logFile, Collection<String> serializedActions, int shortlogLimit, boolean keepLinesWhole, long reservedBytes) {
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(logFile));){
            int read;
            long shortlogStart = logFile.length() + reservedBytes - (long)shortlogLimit * 1024L;
            if (shortlogStart <= 0L) return new ActionContext();
            byte[] buf = new byte[16384];
            int totalRead = 0;
            String lastAction = "";
            String partialLine = "";
            while ((read = inputStream.read(buf)) != -1) {
                int startInBuff = shortlogStart > (long)totalRead ? (int)(shortlogStart - (long)totalRead) : 0;
                String action = this.findLastAction(serializedActions, buf, startInBuff);
                if (!action.isEmpty()) {
                    lastAction = action;
                }
                if ((long)(totalRead + read) >= shortlogStart) {
                    int eolPos = this.indexOfEol(buf, startInBuff);
                    int[] beginLength = this.calculateBeginLength(buf, startInBuff, eolPos, partialLine.isEmpty() && keepLinesWhole);
                    int begin = beginLength[0];
                    int length = beginLength[1];
                    if (length != -1 && !lastAction.isEmpty()) {
                        ActionContext actionContext = new ActionContext(lastAction, partialLine + new String(buf, begin, length, StandardCharsets.UTF_8));
                        return actionContext;
                    }
                    partialLine = new String(Arrays.copyOfRange(buf, begin, buf.length), StandardCharsets.UTF_8);
                }
                totalRead += read;
            }
            return new ActionContext();
        }
        catch (IOException e) {
            LOGGER.warning("Cannot search log for actions: " + e.getMessage());
        }
        return new ActionContext();
    }

    private String findLastAction(Collection<String> serializedActions, byte[] buf, int maxPos) {
        String lastAction = "";
        int preamblePos = 0;
        while (preamblePos < maxPos && (preamblePos = ConsoleNote.findPreamble((byte[])buf, (int)preamblePos, (int)(buf.length - preamblePos))) != -1) {
            int begin = preamblePos++;
            lastAction = serializedActions.stream().filter(sa -> buf.length - begin > sa.length() && sa.equals(new String(buf, begin, sa.length(), StandardCharsets.UTF_8))).findFirst().orElse(lastAction);
        }
        return lastAction;
    }

    private int indexOfEol(byte[] buf, int after) {
        for (int i = after + 1; i < buf.length; ++i) {
            if (!Arrays.equals(Arrays.copyOfRange(buf, i, i + this.eol.length), this.eol)) continue;
            return i;
        }
        return -1;
    }

    private int[] calculateBeginLength(byte[] buf, int startInBuff, int eolPos, boolean keepLinesWhole) {
        if (keepLinesWhole) {
            int begin = eolPos != -1 ? eolPos + this.eol.length : startInBuff;
            return new int[]{begin, eolPos != -1 ? this.indexOfEol(buf, eolPos) - begin + this.eol.length : -1};
        }
        return new int[]{startInBuff, eolPos != -1 ? eolPos - startInBuff + this.eol.length : -1};
    }

    private static class ActionContext {
        private final String serializedAction;
        private final String line;

        public ActionContext() {
            this(null, null);
        }

        public ActionContext(String serializedAction, String line) {
            this.serializedAction = serializedAction;
            this.line = line;
        }

        public boolean isEmpty() {
            return this.serializedAction == null && this.line == null;
        }
    }

    @Extension
    public static class Listener
    extends RunListener<Run<?, ?>> {
        public void onCompleted(Run<?, ?> run, @NonNull TaskListener listener) {
            File logFile;
            super.onCompleted(run, listener);
            List<ColorizedAction.Command> commands = Arrays.asList(ColorizedAction.Command.START, ColorizedAction.Command.STOP);
            Map<String, ColorizedAction> actions = run.getActions(ColorizedAction.class).stream().filter(a -> commands.contains((Object)a.getCommand())).collect(Collectors.toMap(a -> {
                try {
                    return new ActionNote((ColorizedAction)((Object)a)).encode();
                }
                catch (IOException e) {
                    LOGGER.warning("Will not be able to identify all ColorizedActions: " + e.getMessage());
                    return "";
                }
            }, Function.identity()));
            if (!actions.isEmpty() && (logFile = new File(run.getRootDir(), "log")).isFile()) {
                String nl = System.lineSeparator();
                ShortlogActionCreator shortlogActionCreator = new ShortlogActionCreator(new LineIdentifier(), nl);
                String consoleTail = System.getProperty("hudson.consoleTailKB");
                boolean keepLinesWhole = Optional.ofNullable(System.getProperty(ShortlogActionCreator.PROP_LINES_WHOLE)).map(Boolean::parseBoolean).orElseGet(() -> Optional.ofNullable(Jenkins.getVersion()).orElse(LINES_WHOLE_SINCE_VERSION).isNewerThan(LINES_WHOLE_SINCE_VERSION));
                listener.getLogger().flush();
                ColorizedAction action = shortlogActionCreator.createActionForShortlog(logFile, actions, consoleTail != null ? Integer.parseInt(consoleTail) : 150, keepLinesWhole, Optional.ofNullable(run.getResult()).map(r -> 10 + r.toString().length() + nl.getBytes(StandardCharsets.UTF_8).length).orElse(0).intValue());
                if (action != null) {
                    run.addAction((Action)action);
                }
            }
        }
    }
}

