/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ansicolor.action;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

public class LineIdentifier
implements Serializable {
    private static final String ALGORITHM = "SHA-256";
    private static final long serialVersionUID = 1L;
    private transient MessageDigest messageDigest;

    private MessageDigest getMessageDigest() {
        if (this.messageDigest == null) {
            try {
                this.messageDigest = MessageDigest.getInstance(ALGORITHM);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("Cannot get message digest", e);
            }
        }
        return this.messageDigest;
    }

    public String hash(String lineContent, long lineNo) {
        String key = String.join((CharSequence)"|", lineContent, String.valueOf(lineNo));
        return Base64.getEncoder().encodeToString(this.getMessageDigest().digest(key.getBytes(StandardCharsets.UTF_8)));
    }

    public boolean isEqual(String lineContent, long lineNo, String other) {
        return this.hash(lineContent, lineNo).equals(other);
    }
}

