/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ansicolor.action;

import hudson.MarkupText;
import hudson.model.InvisibleAction;
import hudson.model.Run;
import hudson.plugins.ansicolor.AnsiColorMap;
import hudson.plugins.ansicolor.action.LineIdentifier;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Logger;

public class ColorizedAction
extends InvisibleAction {
    private static final Logger LOGGER = Logger.getLogger(ColorizedAction.class.getName());
    private static final String TAG_PIPELINE_INTERNAL = "<span class=\"pipeline-new-node\"";
    static final ColorizedAction CONTINUE = new ColorizedAction("", Command.CONTINUE);
    static final ColorizedAction IGNORE = new ColorizedAction("", Command.IGNORE);
    private final String id;
    private final String colorMapName;
    private final Command command;

    public ColorizedAction(String colorMapName, Command command) {
        this.id = UUID.randomUUID().toString();
        this.colorMapName = colorMapName == null || colorMapName.isEmpty() ? AnsiColorMap.DefaultName : colorMapName;
        this.command = command;
    }

    public ColorizedAction(String id, ColorizedAction other) {
        this.id = id;
        this.colorMapName = other.colorMapName;
        this.command = other.command;
    }

    public String getId() {
        return this.id;
    }

    public String getColorMapName() {
        return this.colorMapName;
    }

    public Command getCommand() {
        return this.command;
    }

    public static ColorizedAction parseAction(MarkupText text, Run<?, ?> run) {
        Optional<ColorizedAction> currentAction;
        String line = text.toString(false);
        int actionIdOffset = line.indexOf("<div style=\"display:none\" data-ansicolor-action=");
        if (actionIdOffset != -1) {
            int from = actionIdOffset + "<div style=\"display:none\" data-ansicolor-action=".length() + 1;
            int to = line.indexOf("\"", from);
            String id = line.substring(from, to);
            return run.getActions(ColorizedAction.class).stream().filter(a -> id.equals(a.getId())).findAny().orElse(CONTINUE);
        }
        if (line.contains(TAG_PIPELINE_INTERNAL)) {
            return IGNORE;
        }
        boolean isBuilding = run.isBuilding();
        LOGGER.fine("Run is building: " + isBuilding);
        if (isBuilding && (currentAction = run.getActions(ColorizedAction.class).stream().filter(a -> Command.CURRENT.equals((Object)a.getCommand())).findFirst()).isPresent()) {
            return currentAction.get();
        }
        return CONTINUE;
    }

    public static ColorizedAction parseAction(String lineContent, long lineNo, Run<?, ?> run, LineIdentifier lineIdentifier) {
        return run.getActions(ColorizedAction.class).stream().filter(a -> lineIdentifier.isEqual(lineContent, lineNo, a.id)).findAny().orElse(CONTINUE);
    }

    public static enum Command {
        START,
        STOP,
        CONTINUE,
        IGNORE,
        CURRENT;

    }
}

