/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ansicolor;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.MarkupText;
import hudson.console.ConsoleAnnotator;
import hudson.console.ConsoleAnnotatorFactory;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.plugins.ansicolor.AnsiAttributeElement;
import hudson.plugins.ansicolor.AnsiColorBuildWrapper;
import hudson.plugins.ansicolor.AnsiColorMap;
import hudson.plugins.ansicolor.AnsiHtmlOutputStream;
import hudson.plugins.ansicolor.action.ColorizedAction;
import hudson.plugins.ansicolor.action.LineIdentifier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.lang.StringEscapeUtils;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.graph.FlowNode;

final class ColorConsoleAnnotator
extends ConsoleAnnotator<Object> {
    private static final Logger LOGGER = Logger.getLogger(ColorConsoleAnnotator.class.getName());
    private static final long serialVersionUID = 1L;
    private static final Factory FACTORY = new Factory();
    private final String defaultColorMapName;
    private final LineIdentifier lineIdentifier;
    @CheckForNull
    private String colorMapName;
    @NonNull
    private List<AnsiAttributeElement> openTags = Collections.emptyList();
    private long lineNo;

    private ColorConsoleAnnotator(String defaultColorMapName, LineIdentifier lineIdentifier, long startLineNo) {
        this.defaultColorMapName = defaultColorMapName;
        this.lineIdentifier = lineIdentifier;
        this.lineNo = startLineNo;
    }

    public ConsoleAnnotator<Object> annotate(@NonNull Object context, final @NonNull MarkupText text) {
        ++this.lineNo;
        Run<?, ?> run = ColorConsoleAnnotator.runOf(context);
        if (run == null) {
            return this;
        }
        ColorizedAction colorizedAction = this.lineNo == 1L ? ColorizedAction.parseAction(text.getText(), this.lineNo, run, this.lineIdentifier) : ColorizedAction.parseAction(text, run);
        switch (colorizedAction.getCommand()) {
            case START: 
            case CURRENT: {
                this.colorMapName = colorizedAction.getColorMapName();
                break;
            }
            case STOP: {
                return FACTORY.newInstance(context, this.lineNo);
            }
            case IGNORE: {
                return this;
            }
            default: {
                if (this.colorMapName != null) break;
                this.colorMapName = this.defaultColorMapName;
            }
        }
        if (this.colorMapName == null) {
            return this;
        }
        final String s = text.getText();
        List<AnsiAttributeElement> nextOpenTags = this.openTags;
        AnsiColorMap colorMap = ((AnsiColorBuildWrapper.DescriptorImpl)Jenkins.get().getDescriptorByType(AnsiColorBuildWrapper.DescriptorImpl.class)).getColorMap(this.colorMapName);
        if (s.indexOf(27) != -1 || !this.openTags.isEmpty() || colorMap.getDefaultBackground() != null || colorMap.getDefaultForeground() != null) {
            final CountingOutputStream outgoing = new CountingOutputStream(OutputStream.nullOutputStream());
            class EmitterImpl
            implements AnsiAttributeElement.Emitter {
                CountingOutputStream incoming;
                int adjustment;
                int lastPoint = -1;

                EmitterImpl() {
                }

                @Override
                public void emitHtml(@NonNull String html) {
                    int inCount = this.getIncomingCount();
                    LOGGER.log(Level.FINEST, "emitting {0} @{1}/{2}", new Object[]{html, inCount, s.length()});
                    text.addMarkup(inCount, html);
                    this.hideIfNeeded(inCount, "");
                }

                private int getIncomingCount() {
                    int inCount = this.incoming.getCount();
                    return inCount == 1 ? 0 : inCount;
                }

                private void hideIfNeeded(int inCount, String msg) {
                    if (inCount != this.lastPoint) {
                        this.lastPoint = inCount;
                        int outCount = outgoing.getCount() + this.adjustment;
                        int hide = inCount - outCount;
                        if (hide != 0) {
                            LOGGER.log(Level.FINEST, "hiding {0} @{1}{2}", new Object[]{hide, outCount, msg});
                            text.addMarkup(outCount, outCount + hide, "<!--", "-->");
                            this.adjustment += hide;
                        }
                    }
                }

                @Override
                public void emitInvisibleSequence() {
                    this.hideIfNeeded(this.getIncomingCount(), " (ANSI sequence with no corresponding HTML tags)");
                }
            }
            EmitterImpl emitter = new EmitterImpl();
            try (AnsiHtmlOutputStream ansiOs = new AnsiHtmlOutputStream((OutputStream)outgoing, colorMap, emitter, this.openTags);
                 CountingOutputStream incoming = new CountingOutputStream((OutputStream)ansiOs);){
                emitter.incoming = incoming;
                for (int i = 0; i < s.length(); ++i) {
                    int c = s.charAt(i);
                    if (c >= 128) {
                        c = 63;
                    }
                    incoming.write(c);
                }
                nextOpenTags = ansiOs.getOpenTags();
                if (colorMap.getDefaultBackground() != null || colorMap.getDefaultForeground() != null) {
                    nextOpenTags.remove(0);
                }
            }
            catch (IOException x) {
                LOGGER.log(Level.WARNING, null, x);
            }
            LOGGER.finer(() -> "\"" + StringEscapeUtils.escapeJava((String)s) + "\" \u2192 \"" + StringEscapeUtils.escapeJava((String)text.toString(true)) + "\"");
        }
        this.openTags = nextOpenTags;
        return this;
    }

    @CheckForNull
    private static Run<?, ?> runOf(Object context) {
        FlowNode node;
        FlowExecutionOwner owner;
        LOGGER.log(Level.FINE, "context={0}", context);
        if (context instanceof Run) {
            return (Run)context;
        }
        if (Jenkins.get().getPlugin("workflow-api") != null && context instanceof FlowNode && (owner = (node = (FlowNode)context).getExecution().getOwner()) != null) {
            Queue.Executable exec = null;
            try {
                exec = owner.getExecutable();
            }
            catch (IOException x) {
                LOGGER.log(Level.WARNING, null, x);
            }
            if (exec instanceof Run) {
                return (Run)exec;
            }
        }
        return null;
    }

    @Extension
    public static final class Factory
    extends ConsoleAnnotatorFactory<Object> {
        public ConsoleAnnotator<Object> newInstance(Object context) {
            return this.newInstance(context, 0L);
        }

        private ConsoleAnnotator<Object> newInstance(Object context, long startLineNo) {
            return new ColorConsoleAnnotator(((AnsiColorBuildWrapper.DescriptorImpl)Jenkins.get().getDescriptorByType(AnsiColorBuildWrapper.DescriptorImpl.class)).getGlobalColorMapName(), new LineIdentifier(), startLineNo);
        }
    }
}

