/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ansicolor;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.console.ConsoleNote;
import hudson.plugins.ansicolor.AnsiAttributeElement;
import hudson.plugins.ansicolor.AnsiColorMap;
import hudson.plugins.ansicolor.AnsiOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;

public class AnsiHtmlOutputStream
extends AnsiOutputStream {
    private final AnsiColorMap colorMap;
    private final AnsiAttributeElement.Emitter emitter;
    private State state = State.INIT;
    private int amblePos = 0;
    private String currentForegroundColor = null;
    private String currentBackgroundColor = null;
    private boolean swapColors = false;
    private final ArrayList<AnsiAttributeElement> openTags;
    private final OutputStream logOutput;
    protected static final int ATTRIBUTE_STRIKEOUT = 9;
    protected static final int ATTRIBUTE_ITALIC_OFF = 23;
    protected static final int ATTRIBUTE_STRIKEOUT_OFF = 29;
    protected static final int ATTRIBUTE_FRAMED = 51;
    protected static final int ATTRIBUTE_ENCIRCLED = 52;
    protected static final int ATTRIBUTE_OVERLINE = 53;
    protected static final int ATTRIBUTE_FRAMED_OFF = 54;
    protected static final int ATTRIBUTE_OVERLINE_OFF = 55;

    AnsiHtmlOutputStream(OutputStream os, AnsiColorMap colorMap, AnsiAttributeElement.Emitter emitter, @NonNull List<AnsiAttributeElement> tagsToOpen) {
        super(os);
        this.logOutput = os;
        this.colorMap = colorMap;
        this.emitter = emitter;
        this.openTags = new ArrayList<AnsiAttributeElement>(tagsToOpen);
    }

    public AnsiHtmlOutputStream(OutputStream os, AnsiColorMap colorMap, AnsiAttributeElement.Emitter emitter) {
        this(os, colorMap, emitter, Collections.emptyList());
    }

    private void logdebug(String format, Object ... args) throws IOException {
        String msg = String.format(format, args);
        this.emitter.emitHtml("<span style=\"border: 1px solid; color: #009000; background-color: #003000; font-size: 70%; font-weight: normal; font-style: normal\">");
        this.out.write(msg.getBytes(StandardCharsets.UTF_8));
        this.emitter.emitHtml("</span>");
    }

    private void startConcealing() {
        this.out = OutputStream.nullOutputStream();
    }

    private void stopConcealing() {
        this.out = this.logOutput;
    }

    List<AnsiAttributeElement> getOpenTags() {
        return new ArrayList<AnsiAttributeElement>(this.openTags);
    }

    private void openTag(AnsiAttributeElement tag) {
        this.openTags.add(tag);
        tag.emitOpen(this.emitter);
    }

    private void closeOpenTags(AnsiAttributeElement.AnsiAttrType until) {
        if (until == AnsiAttributeElement.AnsiAttrType.DEFAULT && (this.openTags.isEmpty() || this.openTags.get((int)0).ansiAttrType == AnsiAttributeElement.AnsiAttrType.DEFAULT)) {
            this.emitter.emitInvisibleSequence();
        }
        while (!this.openTags.isEmpty()) {
            int index = this.openTags.size() - 1;
            if (until != null && this.openTags.get((int)index).ansiAttrType == until) break;
            this.openTags.remove(index).emitClose(this.emitter);
        }
    }

    private void closeTagOfType(AnsiAttributeElement.AnsiAttrType ansiAttrType) {
        AnsiAttributeElement tag;
        int sameTypePos;
        if (ansiAttrType == AnsiAttributeElement.AnsiAttrType.FGBG) {
            this.closeTagsOfTypeFGBG();
            return;
        }
        for (sameTypePos = this.openTags.size(); sameTypePos > 0 && this.openTags.get((int)(sameTypePos - 1)).ansiAttrType != ansiAttrType; --sameTypePos) {
        }
        if (sameTypePos == 0) {
            this.emitter.emitInvisibleSequence();
            return;
        }
        Stack<AnsiAttributeElement> reopen = new Stack<AnsiAttributeElement>();
        for (int unwindAt = this.openTags.size(); unwindAt > sameTypePos; --unwindAt) {
            tag = this.openTags.remove(unwindAt - 1);
            tag.emitClose(this.emitter);
            reopen.push(tag);
        }
        AnsiAttributeElement offendingTag = this.openTags.remove(sameTypePos - 1);
        offendingTag.emitClose(this.emitter);
        while (!reopen.isEmpty()) {
            tag = (AnsiAttributeElement)reopen.pop();
            tag.emitOpen(this.emitter);
            this.openTags.add(tag);
        }
    }

    private void closeTagsOfTypeFGBG() {
        AnsiAttributeElement.AnsiAttrType attrtype;
        int firstMatch;
        for (firstMatch = 0; firstMatch < this.openTags.size() && (attrtype = this.openTags.get((int)firstMatch).ansiAttrType) != AnsiAttributeElement.AnsiAttrType.FG && attrtype != AnsiAttributeElement.AnsiAttrType.BG && attrtype != AnsiAttributeElement.AnsiAttrType.FGBG; ++firstMatch) {
        }
        if (firstMatch >= this.openTags.size()) {
            return;
        }
        Stack<AnsiAttributeElement> reopen = new Stack<AnsiAttributeElement>();
        int unwindAt = this.openTags.size();
        while (unwindAt > firstMatch) {
            AnsiAttributeElement tag = this.openTags.remove(--unwindAt);
            tag.emitClose(this.emitter);
            AnsiAttributeElement.AnsiAttrType attrtype2 = tag.ansiAttrType;
            if (attrtype2 == AnsiAttributeElement.AnsiAttrType.FG || attrtype2 == AnsiAttributeElement.AnsiAttrType.BG || attrtype2 == AnsiAttributeElement.AnsiAttrType.FGBG) continue;
            reopen.push(tag);
        }
        while (!reopen.isEmpty()) {
            AnsiAttributeElement tag = (AnsiAttributeElement)reopen.pop();
            tag.emitOpen(this.emitter);
            this.openTags.add(tag);
        }
    }

    @Override
    public void write(int data) throws IOException {
        if (this.state == State.INIT) {
            ArrayList<AnsiAttributeElement> tagsToOpen = new ArrayList<AnsiAttributeElement>(this.openTags);
            this.openTags.clear();
            Integer defaultFg = this.colorMap.getDefaultForeground();
            Integer defaultBg = this.colorMap.getDefaultBackground();
            if (defaultFg != null || defaultBg != null) {
                this.openTag(new AnsiAttributeElement(AnsiAttributeElement.AnsiAttrType.DEFAULT, "div", "style=\"" + (String)(defaultBg != null ? "background-color: " + this.colorMap.getNormal(defaultBg) + ";" : "") + (String)(defaultFg != null ? "color: " + this.colorMap.getNormal(defaultFg) + ";" : "") + "\""));
            }
            for (AnsiAttributeElement tag : tagsToOpen) {
                this.openTag(tag);
            }
            this.state = State.DATA;
        }
        switch (this.state.ordinal()) {
            case 1: {
                if (data == ConsoleNote.PREAMBLE[0]) {
                    this.state = State.PREAMBLE;
                    this.amblePos = 0;
                    this.collectAmbleCharacter(data, ConsoleNote.PREAMBLE);
                    break;
                }
                super.write(data);
                break;
            }
            case 3: {
                if (data == ConsoleNote.POSTAMBLE[0]) {
                    this.state = State.POSTAMBLE;
                    this.amblePos = 0;
                    this.collectAmbleCharacter(data, ConsoleNote.POSTAMBLE);
                    break;
                }
                this.out.write(data);
                break;
            }
            case 2: {
                this.collectAmbleCharacter(data, ConsoleNote.PREAMBLE);
                break;
            }
            case 4: {
                this.collectAmbleCharacter(data, ConsoleNote.POSTAMBLE);
                break;
            }
            default: {
                throw new IllegalStateException("State " + String.valueOf((Object)this.state) + " should not be reached");
            }
        }
    }

    private void collectAmbleCharacter(int data, byte[] amble) throws IOException {
        if (data != amble[this.amblePos]) {
            for (int i = 0; i < this.amblePos; ++i) {
                super.write(amble[i]);
            }
            this.state = this.state == State.POSTAMBLE ? State.NOTE : State.DATA;
            this.amblePos = 0;
            this.write(data);
        } else if (this.amblePos == amble.length - 1) {
            this.out.write(amble);
            this.state = this.state == State.POSTAMBLE ? State.DATA : State.NOTE;
            this.amblePos = 0;
        } else {
            ++this.amblePos;
        }
    }

    @Override
    public void close() throws IOException {
        this.stopConcealing();
        this.closeOpenTags(null);
        super.close();
    }

    private String getDefaultForegroundColor() {
        String color = null;
        Integer defaultFgIndex = this.colorMap.getDefaultForeground();
        if (defaultFgIndex != null) {
            color = this.colorMap.getNormal(defaultFgIndex);
        }
        if (color == null) {
            color = "var(--text-color)";
        }
        return color;
    }

    private String getDefaultBackgroundColor() {
        String color = null;
        Integer defaultBgIndex = this.colorMap.getDefaultBackground();
        if (defaultBgIndex != null) {
            color = this.colorMap.getNormal(defaultBgIndex);
        }
        if (color == null) {
            color = "var(--background)";
        }
        return color;
    }

    private void setForegroundColor(String color) {
        String attrName;
        AnsiAttributeElement.AnsiAttrType attrType = !this.swapColors ? AnsiAttributeElement.AnsiAttrType.FG : AnsiAttributeElement.AnsiAttrType.BG;
        String string = attrName = !this.swapColors ? "color" : "background-color";
        if (color == null && this.swapColors) {
            color = this.getDefaultForegroundColor();
        }
        this.closeTagOfType(attrType);
        if (color != null) {
            this.openTag(new AnsiAttributeElement(attrType, "span", "style=\"" + attrName + ": " + color + ";\""));
        }
        this.currentForegroundColor = color;
    }

    public void setBackgroundColor(String color) {
        String attrName;
        AnsiAttributeElement.AnsiAttrType attrType = !this.swapColors ? AnsiAttributeElement.AnsiAttrType.BG : AnsiAttributeElement.AnsiAttrType.FG;
        String string = attrName = !this.swapColors ? "background-color" : "color";
        if (color == null && this.swapColors) {
            color = this.getDefaultBackgroundColor();
        }
        this.closeTagOfType(attrType);
        if (color != null) {
            this.openTag(new AnsiAttributeElement(attrType, "span", "style=\"" + attrName + ": " + color + ";\""));
        }
        this.currentBackgroundColor = color;
    }

    @Override
    protected void processSetAttribute(int attribute) {
        if (attribute >= 90 && attribute <= 97) {
            this.processSetForegroundColor(attribute - 90, true);
        } else if (attribute < 10 || attribute > 19) {
            if (attribute >= 100 && attribute <= 107) {
                this.processSetBackgroundColor(attribute - 100, true);
            } else {
                switch (attribute) {
                    case 8: {
                        this.startConcealing();
                        break;
                    }
                    case 28: {
                        this.stopConcealing();
                        break;
                    }
                    case 1: {
                        this.closeTagOfType(AnsiAttributeElement.AnsiAttrType.BOLD);
                        this.openTag(AnsiAttributeElement.bold());
                        break;
                    }
                    case 2: {
                        AnsiAttributeElement faint = AnsiAttributeElement.faint();
                        this.closeTagOfType(faint.ansiAttrType);
                        this.openTag(faint);
                        break;
                    }
                    case 22: {
                        this.closeTagOfType(AnsiAttributeElement.AnsiAttrType.BOLD);
                        this.closeTagOfType(AnsiAttributeElement.AnsiAttrType.FAINT);
                        break;
                    }
                    case 3: {
                        this.closeTagOfType(AnsiAttributeElement.AnsiAttrType.ITALIC);
                        this.openTag(AnsiAttributeElement.italic());
                        break;
                    }
                    case 23: {
                        this.closeTagOfType(AnsiAttributeElement.AnsiAttrType.ITALIC);
                        break;
                    }
                    case 4: {
                        this.closeTagOfType(AnsiAttributeElement.AnsiAttrType.UNDERLINE);
                        this.openTag(AnsiAttributeElement.underline());
                        break;
                    }
                    case 21: {
                        this.closeTagOfType(AnsiAttributeElement.AnsiAttrType.UNDERLINE);
                        this.openTag(AnsiAttributeElement.underlineDouble());
                        break;
                    }
                    case 24: {
                        this.closeTagOfType(AnsiAttributeElement.AnsiAttrType.UNDERLINE);
                        break;
                    }
                    case 7: 
                    case 27: {
                        boolean swapNow;
                        boolean bl = swapNow = attribute == 7;
                        if (swapNow == this.swapColors) break;
                        this.swapColors = swapNow;
                        String bg = this.currentBackgroundColor;
                        String fg = this.currentForegroundColor;
                        if (this.swapColors) {
                            if (bg == null) {
                                bg = this.getDefaultBackgroundColor();
                            }
                            if (fg == null) {
                                fg = this.getDefaultForegroundColor();
                            }
                            String tmp = fg;
                            fg = bg;
                            bg = tmp;
                        }
                        this.closeTagOfType(AnsiAttributeElement.AnsiAttrType.FGBG);
                        if (fg != null && bg != null) {
                            this.openTag(new AnsiAttributeElement(AnsiAttributeElement.AnsiAttrType.FGBG, "span", "style=\"background-color: " + bg + "; color: " + fg + ";\""));
                            break;
                        }
                        if (bg != null) {
                            this.openTag(new AnsiAttributeElement(AnsiAttributeElement.AnsiAttrType.BG, "span", "style=\"background-color: " + bg + ";\""));
                        }
                        if (fg == null) break;
                        this.openTag(new AnsiAttributeElement(AnsiAttributeElement.AnsiAttrType.FG, "span", "style=\"color: " + fg + ";\""));
                        break;
                    }
                    case 9: {
                        this.closeTagOfType(AnsiAttributeElement.AnsiAttrType.STRIKEOUT);
                        this.openTag(AnsiAttributeElement.strikeout());
                        break;
                    }
                    case 29: {
                        this.closeTagOfType(AnsiAttributeElement.AnsiAttrType.STRIKEOUT);
                        break;
                    }
                    case 51: {
                        this.closeTagOfType(AnsiAttributeElement.AnsiAttrType.FRAMED);
                        this.openTag(AnsiAttributeElement.framed());
                        break;
                    }
                    case 54: {
                        this.closeTagOfType(AnsiAttributeElement.AnsiAttrType.FRAMED);
                        break;
                    }
                    case 53: {
                        this.closeTagOfType(AnsiAttributeElement.AnsiAttrType.OVERLINE);
                        this.openTag(AnsiAttributeElement.overline());
                        break;
                    }
                    case 55: {
                        this.closeTagOfType(AnsiAttributeElement.AnsiAttrType.OVERLINE);
                        break;
                    }
                }
            }
        }
    }

    private String getRgbColor(int r, int g, int b) {
        if (r < 0 || r > 255 || g < 0 || g > 255 || b < 0 || b > 255) {
            throw new IllegalArgumentException();
        }
        return "#" + String.format("%02X", r) + String.format("%02X", g) + String.format("%02X", b);
    }

    private String getPaletteColor(int paletteIndex) {
        if (paletteIndex < 0 || paletteIndex > 255) {
            throw new IllegalArgumentException();
        }
        if (paletteIndex < 16) {
            if (paletteIndex < 8) {
                return this.colorMap.getNormal(paletteIndex);
            }
            return this.colorMap.getBright(paletteIndex - 8);
        }
        if (paletteIndex < 232) {
            int c = paletteIndex - 16;
            int b = c % 6;
            int g = (c /= 6) % 6;
            int r = (c /= 6) % 6;
            if (r != 0) {
                r = 55 + r * 40;
            }
            if (g != 0) {
                g = 55 + g * 40;
            }
            if (b != 0) {
                b = 55 + b * 40;
            }
            return this.getRgbColor(r, g, b);
        }
        int g = paletteIndex - 232;
        g *= 10;
        return this.getRgbColor(g += 8, g, g);
    }

    @Override
    protected void processAttributeRest() {
        this.currentForegroundColor = null;
        this.currentBackgroundColor = null;
        this.swapColors = false;
        this.stopConcealing();
        this.closeOpenTags(AnsiAttributeElement.AnsiAttrType.DEFAULT);
    }

    @Override
    protected void processSetForegroundColor(int color) {
        this.setForegroundColor(this.colorMap.getNormal(color));
    }

    @Override
    protected void processSetForegroundColor(int color, boolean bright) {
        this.setForegroundColor(this.colorMap.getBright(color));
    }

    @Override
    protected void processSetForegroundColorExt(int paletteIndex) {
        this.setForegroundColor(this.getPaletteColor(paletteIndex));
    }

    @Override
    protected void processSetForegroundColorExt(int r, int g, int b) {
        this.setForegroundColor(this.getRgbColor(r, g, b));
    }

    @Override
    protected void processSetBackgroundColor(int color) {
        this.setBackgroundColor(this.colorMap.getNormal(color));
    }

    @Override
    protected void processSetBackgroundColor(int color, boolean bright) {
        this.setBackgroundColor(this.colorMap.getBright(color));
    }

    @Override
    protected void processSetBackgroundColorExt(int paletteIndex) {
        this.setBackgroundColor(this.getPaletteColor(paletteIndex));
    }

    @Override
    protected void processSetBackgroundColorExt(int r, int g, int b) {
        this.setBackgroundColor(this.getRgbColor(r, g, b));
    }

    @Override
    protected void processDefaultTextColor() {
        this.setForegroundColor(null);
    }

    @Override
    protected void processDefaultBackgroundColor() {
        this.setBackgroundColor(null);
    }

    @Override
    protected void processEraseLine(int eraseOption) {
        this.emitter.emitInvisibleSequence();
    }

    @Override
    protected void processCursorDown(int count) {
        this.emitter.emitInvisibleSequence();
    }

    @Override
    protected void processCursorUp(int count) {
        this.emitter.emitInvisibleSequence();
    }

    @Override
    protected void processCursorLeft(int count) {
        this.emitter.emitInvisibleSequence();
    }

    @Override
    protected void processCursorUpLine(int count) {
        this.emitter.emitInvisibleSequence();
    }

    @Override
    protected void processRestoreCursorPosition() {
        this.emitter.emitInvisibleSequence();
    }

    @Override
    protected void processSaveCursorPosition() {
        this.emitter.emitInvisibleSequence();
    }

    @Override
    protected void processScrollDown(int optionInt) {
        this.emitter.emitInvisibleSequence();
    }

    @Override
    protected void processScrollUp(int optionInt) {
        this.emitter.emitInvisibleSequence();
    }

    @Override
    protected void processEraseScreen(int eraseOption) {
        this.emitter.emitInvisibleSequence();
    }

    @Override
    protected void processCursorTo(int row, int col) {
        this.emitter.emitInvisibleSequence();
    }

    @Override
    protected void processCursorToColumn(int x) {
        this.emitter.emitInvisibleSequence();
    }

    @Override
    protected void processCursorDownLine(int count) {
        this.emitter.emitInvisibleSequence();
    }

    @Override
    protected void processCursorRight(int count) {
        this.emitter.emitInvisibleSequence();
    }

    @Override
    protected void processUnknownExtension(ArrayList<Object> options, int command) {
        this.emitter.emitInvisibleSequence();
    }

    @Override
    protected void processChangeIconName(String label) {
        this.emitter.emitInvisibleSequence();
    }

    @Override
    protected void processChangeWindowTitle(String label) {
        this.emitter.emitInvisibleSequence();
    }

    @Override
    protected void processUnknownOperatingSystemCommand(int command, String param) {
        this.emitter.emitInvisibleSequence();
    }

    @Override
    protected void processCharsetSelect(int set, char seq) {
        this.emitter.emitInvisibleSequence();
    }

    private static enum State {
        INIT,
        DATA,
        PREAMBLE,
        NOTE,
        POSTAMBLE;

    }
}

