/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ansicolor;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.console.ConsoleNote;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.ansicolor.AnsiColorBuildWrapper;
import hudson.plugins.ansicolor.AnsiColorMap;
import hudson.plugins.ansicolor.Messages;
import hudson.plugins.ansicolor.action.ActionNote;
import hudson.plugins.ansicolor.action.ColorizedAction;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.log.TaskListenerDecorator;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.DynamicContext;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class AnsiColorStep
extends Step {
    private final String colorMapName;

    @DataBoundConstructor
    public AnsiColorStep(String colorMapName) {
        this.colorMapName = Optional.ofNullable(colorMapName).orElseGet(() -> Optional.ofNullable(((AnsiColorBuildWrapper.DescriptorImpl)Jenkins.get().getDescriptorByType(AnsiColorBuildWrapper.DescriptorImpl.class)).getGlobalColorMapName()).orElse(AnsiColorMap.DefaultName));
    }

    public String getColorMapName() {
        return this.colorMapName;
    }

    private static AnsiColorBuildWrapper.DescriptorImpl getWrapperDescriptor() {
        return (AnsiColorBuildWrapper.DescriptorImpl)Jenkins.get().getDescriptorByType(AnsiColorBuildWrapper.DescriptorImpl.class);
    }

    public StepExecution start(StepContext context) throws Exception {
        return new ExecutionImpl(context, this.colorMapName);
    }

    private static class ExecutionImpl
    extends AbstractStepExecutionImpl {
        private static final long serialVersionUID = 1L;
        private final String colorMapName;

        ExecutionImpl(StepContext context, String colorMapName) {
            super(context);
            this.colorMapName = colorMapName;
        }

        public boolean start() throws Exception {
            StepContext context = this.getContext();
            EnvironmentExpander currentEnvironment = (EnvironmentExpander)context.get(EnvironmentExpander.class);
            EnvironmentExpander terminalEnvironment = EnvironmentExpander.constant(Collections.singletonMap("TERM", this.colorMapName));
            context.newBodyInvoker().withContext((Object)EnvironmentExpander.merge((EnvironmentExpander)currentEnvironment, (EnvironmentExpander)terminalEnvironment)).withCallback((BodyExecutionCallback)new AnsiColorExecution(this.colorMapName)).start();
            return false;
        }
    }

    private static class AnsiColorExecution
    extends BodyExecutionCallback {
        private static final Logger LOGGER = Logger.getLogger(AnsiColorExecution.class.getName());
        private static final Map<Class<?>, String[]> EXTENSIONS_NL = new HashMap();
        private final String colorMapName;
        private Boolean needsPrintln;

        public AnsiColorExecution(String colorMapName) {
            this.colorMapName = colorMapName;
        }

        public void onStart(StepContext context) {
            this.issueAction(context, new ColorizedAction(this.colorMapName, ColorizedAction.Command.START));
            super.onStart(context);
        }

        public void onSuccess(StepContext context, Object result) {
            this.issueAction(context, new ColorizedAction(this.colorMapName, ColorizedAction.Command.STOP));
            context.onSuccess(result);
        }

        public void onFailure(StepContext context, Throwable t) {
            this.issueAction(context, new ColorizedAction(this.colorMapName, ColorizedAction.Command.STOP));
            context.onFailure(t);
        }

        private void issueAction(StepContext context, ColorizedAction action) {
            try {
                TaskListener taskListener = (TaskListener)context.get(TaskListener.class);
                Run run = (Run)context.get(Run.class);
                if (taskListener != null && run != null) {
                    run.addAction((Action)action);
                    taskListener.annotate((ConsoleNote)new ActionNote(action));
                    this.ensureRendering(taskListener);
                    ColorizedAction currentAction = new ColorizedAction(action.getColorMapName(), ColorizedAction.Command.CURRENT);
                    if (action.getCommand().equals((Object)ColorizedAction.Command.START)) {
                        run.addAction((Action)currentAction);
                    } else {
                        run.removeAction((Action)currentAction);
                    }
                }
            }
            catch (IOException | InterruptedException e) {
                LOGGER.log(Level.WARNING, "Could not annotate. Ansicolor plugin will not work correctly.", e);
            }
        }

        private boolean needsPrintln() {
            if (this.needsPrintln == null) {
                this.needsPrintln = EXTENSIONS_NL.entrySet().stream().anyMatch(e -> ExtensionList.lookup((Class)((Class)e.getKey())).stream().map(ext -> ext.getClass().getName()).anyMatch(n -> Arrays.stream((String[])e.getValue()).anyMatch(n::contains)));
            }
            return this.needsPrintln;
        }

        private void ensureRendering(TaskListener taskListener) {
            if (this.needsPrintln()) {
                taskListener.getLogger().println();
            }
        }

        static {
            EXTENSIONS_NL.put(DynamicContext.Typed.class, new String[]{"kubernetes.pipeline.SecretsMasker"});
            EXTENSIONS_NL.put(TaskListenerDecorator.Factory.class, new String[]{"timestamper.pipeline.GlobalDecorator", "logstash.pipeline.GlobalDecorator"});
            EXTENSIONS_NL.put(StepDescriptor.class, new String[]{"plugins.pipeline.maven"});
        }
    }

    @Extension(optional=true)
    public static class StepDescriptorImpl
    extends StepDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.DisplayName();
        }

        public String getFunctionName() {
            return "ansiColor";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public ListBoxModel doFillColorMapNameItems() {
            return AnsiColorStep.getWrapperDescriptor().doFillColorMapNameItems();
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(Run.class);
        }
    }
}

