/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ansicolor;

import java.io.Serializable;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import org.kohsuke.stapler.DataBoundConstructor;

public final class AnsiColorMap
implements Serializable {
    private static final long serialVersionUID = 2950700158497010341L;
    private String name;
    private transient String[] fgMap;
    private transient String[] bgMap;
    private Map<Color, String> normalMap = new EnumMap<Color, String>(Color.class);
    private Map<Color, String> brightMap = new EnumMap<Color, String>(Color.class);
    private final Integer defaultForeground;
    private final Integer defaultBackground;
    public static final AnsiColorMap XTerm = new AnsiColorMap("xterm", "#000000", "#CD0000", "#00CD00", "#CDCD00", "#1E90FF", "#CD00CD", "#00CDCD", "#E5E5E5", "#4C4C4C", "#FF0000", "#00FF00", "#FFFF00", "#4682B4", "#FF00FF", "#00FFFF", "#FFFFFF", null, null);
    public static final AnsiColorMap VGA = new AnsiColorMap("vga", "#000000", "#AA0000", "#00AA00", "#AA5500", "#0000AA", "#AA00AA", "#00AAAA", "#AAAAAA", "#555555", "#FF5555", "#55FF55", "#FFFF55", "#5555FF", "#FF55FF", "#55FFFF", "#FFFFFF", Color.WHITE.ordinal(), Color.BLACK.ordinal());
    public static final AnsiColorMap CSS = new AnsiColorMap("css", "black", "red", "green", "yellow", "blue", "magenta", "cyan", "white", "black", "red", "green", "yellow", "blue", "magenta", "cyan", "white", null, null);
    public static final AnsiColorMap GnomeTerminal = new AnsiColorMap("gnome-terminal", "#2E3436", "#CC0000", "#4E9A06", "#C4A000", "#3465A4", "#75507B", "#06989A", "#D3D7CF", "#2E3436", "#CC0000", "#4E9A06", "#C4A000", "#3465A4", "#75507B", "#06989A", "#D3D7CF", Color.WHITE.ordinal(), Color.BLACK.ordinal());
    public static final AnsiColorMap Default = XTerm;
    public static final String DefaultName = Default.getName();
    private static final AnsiColorMap[] DefaultColorMaps = new AnsiColorMap[]{XTerm, VGA, CSS, GnomeTerminal};

    public static AnsiColorMap[] defaultColorMaps() {
        return (AnsiColorMap[])DefaultColorMaps.clone();
    }

    protected Object readResolve() {
        if (this.fgMap != null) {
            this.normalMap = new EnumMap<Color, String>(Color.class);
            this.normalMap.put(Color.BLACK, this.fgMap[0]);
            this.normalMap.put(Color.RED, this.fgMap[1]);
            this.normalMap.put(Color.GREEN, this.fgMap[2]);
            this.normalMap.put(Color.YELLOW, this.fgMap[3]);
            this.normalMap.put(Color.BLUE, this.fgMap[4]);
            this.normalMap.put(Color.MAGENTA, this.fgMap[5]);
            this.normalMap.put(Color.CYAN, this.fgMap[6]);
            this.normalMap.put(Color.WHITE, this.fgMap[7]);
            this.fgMap = null;
        }
        if (this.bgMap != null) {
            this.brightMap = new EnumMap<Color, String>(Color.class);
            this.brightMap.put(Color.BLACK, this.bgMap[0]);
            this.brightMap.put(Color.RED, this.bgMap[1]);
            this.brightMap.put(Color.GREEN, this.bgMap[2]);
            this.brightMap.put(Color.YELLOW, this.bgMap[3]);
            this.brightMap.put(Color.BLUE, this.bgMap[4]);
            this.brightMap.put(Color.MAGENTA, this.bgMap[5]);
            this.brightMap.put(Color.CYAN, this.bgMap[6]);
            this.brightMap.put(Color.WHITE, this.bgMap[7]);
            this.bgMap = null;
        }
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.normalMap, this.brightMap, this.defaultForeground, this.defaultBackground);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AnsiColorMap)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        AnsiColorMap ansiColorMap = (AnsiColorMap)obj;
        return Objects.equals(this.name, ansiColorMap.name) && Objects.equals(this.normalMap, ansiColorMap.normalMap) && Objects.equals(this.brightMap, ansiColorMap.brightMap) && Objects.equals(this.defaultForeground, ansiColorMap.defaultForeground) && Objects.equals(this.defaultBackground, ansiColorMap.defaultBackground);
    }

    @DataBoundConstructor
    public AnsiColorMap(String name, String black, String red, String green, String yellow, String blue, String magenta, String cyan, String white, String blackB, String redB, String greenB, String yellowB, String blueB, String magentaB, String cyanB, String whiteB, Integer defaultForeground, Integer defaultBackground) {
        this.name = name;
        this.normalMap.put(Color.BLACK, black);
        this.normalMap.put(Color.RED, red);
        this.normalMap.put(Color.GREEN, green);
        this.normalMap.put(Color.YELLOW, yellow);
        this.normalMap.put(Color.BLUE, blue);
        this.normalMap.put(Color.MAGENTA, magenta);
        this.normalMap.put(Color.CYAN, cyan);
        this.normalMap.put(Color.WHITE, white);
        this.brightMap.put(Color.BLACK, blackB);
        this.brightMap.put(Color.RED, redB);
        this.brightMap.put(Color.GREEN, greenB);
        this.brightMap.put(Color.YELLOW, yellowB);
        this.brightMap.put(Color.BLUE, blueB);
        this.brightMap.put(Color.MAGENTA, magentaB);
        this.brightMap.put(Color.CYAN, cyanB);
        this.brightMap.put(Color.WHITE, whiteB);
        this.defaultForeground = defaultForeground;
        this.defaultBackground = defaultBackground;
    }

    public String getName() {
        return this.name;
    }

    public String getBlack() {
        return this.normalMap.get((Object)Color.BLACK);
    }

    public String getRed() {
        return this.normalMap.get((Object)Color.RED);
    }

    public String getGreen() {
        return this.normalMap.get((Object)Color.GREEN);
    }

    public String getYellow() {
        return this.normalMap.get((Object)Color.YELLOW);
    }

    public String getBlue() {
        return this.normalMap.get((Object)Color.BLUE);
    }

    public String getMagenta() {
        return this.normalMap.get((Object)Color.MAGENTA);
    }

    public String getCyan() {
        return this.normalMap.get((Object)Color.CYAN);
    }

    public String getWhite() {
        return this.normalMap.get((Object)Color.WHITE);
    }

    public String getBlackB() {
        return this.brightMap.get((Object)Color.BLACK);
    }

    public String getRedB() {
        return this.brightMap.get((Object)Color.RED);
    }

    public String getGreenB() {
        return this.brightMap.get((Object)Color.GREEN);
    }

    public String getYellowB() {
        return this.brightMap.get((Object)Color.YELLOW);
    }

    public String getBlueB() {
        return this.brightMap.get((Object)Color.BLUE);
    }

    public String getMagentaB() {
        return this.brightMap.get((Object)Color.MAGENTA);
    }

    public String getCyanB() {
        return this.brightMap.get((Object)Color.CYAN);
    }

    public String getWhiteB() {
        return this.brightMap.get((Object)Color.WHITE);
    }

    public String getNormal(int index) {
        return this.normalMap.get((Object)Color.values()[index]);
    }

    public String getBright(int index) {
        return this.brightMap.get((Object)Color.values()[index]);
    }

    public Integer getDefaultForeground() {
        return this.defaultForeground;
    }

    public Integer getDefaultBackground() {
        return this.defaultBackground;
    }

    public static enum Color {
        BLACK,
        RED,
        GREEN,
        YELLOW,
        BLUE,
        MAGENTA,
        CYAN,
        WHITE;


        public String toString() {
            return this.name().substring(0, 1) + this.name().substring(1).toLowerCase();
        }
    }
}

