/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ansicolor;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.console.ConsoleLogFilter;
import hudson.model.AbstractBuild;
import hudson.plugins.ansicolor.AnsiAttributeElement;
import hudson.plugins.ansicolor.AnsiColorMap;
import hudson.plugins.ansicolor.AnsiHtmlOutputStream;
import hudson.plugins.ansicolor.SimpleHtmlNote;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.util.JenkinsJVM;

@Deprecated
public final class AnsiColorConsoleLogFilter
extends ConsoleLogFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(AnsiColorConsoleLogFilter.class.getName());
    private AnsiColorMap colorMap;
    private final Map<String, byte[]> notes;

    public AnsiColorConsoleLogFilter(AnsiColorMap colorMap) {
        this.colorMap = colorMap;
        this.notes = new HashMap<String, byte[]>();
        for (AnsiColorMap.Color color : AnsiColorMap.Color.values()) {
            this.pregenerateNote(new AnsiAttributeElement(AnsiAttributeElement.AnsiAttrType.FG, "span", "style=\"color: " + colorMap.getNormal(color.ordinal()) + ";\""));
            this.pregenerateNote(new AnsiAttributeElement(AnsiAttributeElement.AnsiAttrType.FG, "span", "style=\"color: " + colorMap.getBright(color.ordinal()) + ";\""));
        }
        this.pregenerateNote(AnsiAttributeElement.bold());
        this.pregenerateNote(AnsiAttributeElement.italic());
        this.pregenerateNote(AnsiAttributeElement.underline());
        this.pregenerateNote(AnsiAttributeElement.underlineDouble());
        this.pregenerateNote(AnsiAttributeElement.strikeout());
        this.pregenerateNote(AnsiAttributeElement.framed());
        this.pregenerateNote(AnsiAttributeElement.overline());
        LOGGER.log(Level.FINE, "Notes pregenerated for {0}", this.notes.keySet());
    }

    private void pregenerateNote(AnsiAttributeElement element) {
        element.emitOpen(html -> this.pregenerateNote(html));
        element.emitClose(html -> this.pregenerateNote(html));
    }

    private void pregenerateNote(String html) {
        if (!this.notes.containsKey(html)) {
            JenkinsJVM.checkJenkinsJVM();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                new SimpleHtmlNote(html).encodeTo(baos);
            }
            catch (IOException x) {
                throw new RuntimeException(x);
            }
            this.notes.put(html, baos.toByteArray());
        }
    }

    private Object readResolve() {
        return this.notes == null ? new AnsiColorConsoleLogFilter(this.colorMap) : this;
    }

    public OutputStream decorateLogger(AbstractBuild build, final OutputStream logger) throws IOException, InterruptedException {
        if (logger == null) {
            return null;
        }
        return new AnsiHtmlOutputStream(logger, this.colorMap, new AnsiAttributeElement.Emitter(){

            @Override
            public void emitHtml(@NonNull String html) {
                try {
                    byte[] pregenerated = AnsiColorConsoleLogFilter.this.notes.get(html);
                    if (pregenerated != null) {
                        logger.write(pregenerated);
                    } else {
                        new SimpleHtmlNote(html).encodeTo(logger);
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to add HTML markup '" + html + "'", e);
                }
            }
        });
    }
}

