/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ansicolor;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.console.ConsoleNote;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.ansicolor.AnsiColorMap;
import hudson.plugins.ansicolor.Messages;
import hudson.plugins.ansicolor.action.ActionNote;
import hudson.plugins.ansicolor.action.ColorizedAction;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import jenkins.tasks.SimpleBuildWrapper;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

public final class AnsiColorBuildWrapper
extends SimpleBuildWrapper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String colorMapName;

    @DataBoundConstructor
    public AnsiColorBuildWrapper(String colorMapName) {
        this.colorMapName = colorMapName;
    }

    public String getColorMapName() {
        return this.colorMapName == null ? AnsiColorMap.DefaultName : this.colorMapName;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment) throws IOException, InterruptedException {
        ColorizedAction action = new ColorizedAction(this.colorMapName, ColorizedAction.Command.START);
        build.replaceAction((Action)action);
        listener.annotate((ConsoleNote)new ActionNote(action));
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        private static final Map<String, Function<AnsiColorMap, String>> VALIDATED_FIELDS = new HashMap<String, Function<AnsiColorMap, String>>();
        private AnsiColorMap[] colorMaps = new AnsiColorMap[0];
        private String globalColorMapName;

        public DescriptorImpl() {
            super(AnsiColorBuildWrapper.class);
            this.load();
        }

        private AnsiColorMap[] withDefaults(AnsiColorMap[] colorMaps) {
            LinkedHashMap<String, AnsiColorMap> maps = new LinkedHashMap<String, AnsiColorMap>();
            this.addAll(AnsiColorMap.defaultColorMaps(), maps);
            this.addAll(colorMaps, maps);
            return maps.values().toArray(new AnsiColorMap[1]);
        }

        private void addAll(AnsiColorMap[] maps, Map<String, AnsiColorMap> to) {
            for (AnsiColorMap map : maps) {
                to.put(map.getName(), map);
            }
        }

        public boolean configure(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            try {
                List colorMaps = req.bindJSONToList(AnsiColorMap.class, req.getSubmittedForm().get("colorMap"));
                for (AnsiColorMap colorMap : colorMaps) {
                    this.validateFieldName(colorMap.getName());
                    this.validateFields(colorMap);
                }
                String globalColorMapName = req.getSubmittedForm().getString("globalColorMapName").trim();
                FormValidation validation = this.doCheckGlobalColorMapName(globalColorMapName);
                if (validation.kind != FormValidation.Kind.OK) {
                    throw new Descriptor.FormException(validation.getMessage(), "globalColorMapName");
                }
                if (!globalColorMapName.isEmpty() && colorMaps.stream().noneMatch(cm -> cm.getName().equals(globalColorMapName))) {
                    throw new Descriptor.FormException("Global color map name must match one of the color maps", "globalColorMapName");
                }
                this.setColorMaps(colorMaps.toArray(new AnsiColorMap[0]));
                this.setGlobalColorMapName(globalColorMapName.isEmpty() ? null : globalColorMapName);
                this.save();
                return true;
            }
            catch (ServletException e) {
                throw new Descriptor.FormException((Throwable)e, "");
            }
        }

        private void validateFieldName(String fieldValue) throws Descriptor.FormException {
            FormValidation validation = this.doCheckName(fieldValue);
            if (validation.kind != FormValidation.Kind.OK) {
                throw new Descriptor.FormException(validation.getMessage(), "name");
            }
        }

        private void validateFieldColorLiteral(String fieldName, String fieldValue) throws Descriptor.FormException {
            FormValidation globalColorMapNameValidation = this.validateColorLiteral(fieldValue);
            if (globalColorMapNameValidation.kind != FormValidation.Kind.OK) {
                throw new Descriptor.FormException(globalColorMapNameValidation.getMessage(), fieldName);
            }
        }

        private void validateFields(AnsiColorMap ansiColorMap) throws Descriptor.FormException {
            for (Map.Entry<String, Function<AnsiColorMap, String>> e : VALIDATED_FIELDS.entrySet()) {
                this.validateFieldColorLiteral(e.getKey(), e.getValue().apply(ansiColorMap));
            }
        }

        public FormValidation doCheckGlobalColorMapName(@QueryParameter String value) {
            return value.isEmpty() ? FormValidation.ok() : this.validateColorMapName(value);
        }

        public FormValidation doCheckName(@QueryParameter String value) {
            return this.validateColorMapName(value);
        }

        private FormValidation validateColorMapName(String name) {
            int nameLength = name.trim().length();
            return nameLength < 1 || nameLength > 256 ? FormValidation.error((String)"Color map name length must be between 1 and 256 chars.") : FormValidation.ok();
        }

        public FormValidation doCheckBlack(@QueryParameter String value) {
            return this.validateColorLiteral(value);
        }

        public FormValidation doCheckBlackB(@QueryParameter String value) {
            return this.validateColorLiteral(value);
        }

        public FormValidation doCheckRed(@QueryParameter String value) {
            return this.validateColorLiteral(value);
        }

        public FormValidation doCheckRedB(@QueryParameter String value) {
            return this.validateColorLiteral(value);
        }

        public FormValidation doCheckGreen(@QueryParameter String value) {
            return this.validateColorLiteral(value);
        }

        public FormValidation doCheckGreenB(@QueryParameter String value) {
            return this.validateColorLiteral(value);
        }

        public FormValidation doCheckYellow(@QueryParameter String value) {
            return this.validateColorLiteral(value);
        }

        public FormValidation doCheckYellowB(@QueryParameter String value) {
            return this.validateColorLiteral(value);
        }

        public FormValidation doCheckBlue(@QueryParameter String value) {
            return this.validateColorLiteral(value);
        }

        public FormValidation doCheckBlueB(@QueryParameter String value) {
            return this.validateColorLiteral(value);
        }

        public FormValidation doCheckMagenta(@QueryParameter String value) {
            return this.validateColorLiteral(value);
        }

        public FormValidation doCheckMagentaB(@QueryParameter String value) {
            return this.validateColorLiteral(value);
        }

        public FormValidation doCheckCyan(@QueryParameter String value) {
            return this.validateColorLiteral(value);
        }

        public FormValidation doCheckCyanB(@QueryParameter String value) {
            return this.validateColorLiteral(value);
        }

        public FormValidation doCheckWhite(@QueryParameter String value) {
            return this.validateColorLiteral(value);
        }

        public FormValidation doCheckWhiteB(@QueryParameter String value) {
            return this.validateColorLiteral(value);
        }

        private FormValidation validateColorLiteral(String name) {
            int nameLength = name.trim().length();
            return nameLength < 1 || nameLength > 64 ? FormValidation.error((String)"Color literal length must be between 1 and 64 chars.") : FormValidation.ok();
        }

        public String getGlobalColorMapName() {
            return this.globalColorMapName;
        }

        public void setGlobalColorMapName(String colorMapName) {
            this.globalColorMapName = colorMapName;
        }

        public AnsiColorMap[] getColorMaps() {
            return this.withDefaults(this.colorMaps);
        }

        public void setColorMaps(AnsiColorMap[] maps) {
            this.colorMaps = (AnsiColorMap[])maps.clone();
        }

        public AnsiColorMap getColorMap(String name) {
            for (AnsiColorMap colorMap : this.getColorMaps()) {
                if (!colorMap.getName().equals(name)) continue;
                return colorMap;
            }
            return AnsiColorMap.Default;
        }

        public ListBoxModel doFillColorMapNameItems() {
            ListBoxModel m = new ListBoxModel();
            for (AnsiColorMap colorMap : this.getColorMaps()) {
                String name = colorMap.getName().trim();
                if (name.length() <= 0) continue;
                m.add(name);
            }
            return m;
        }

        public ListBoxModel doFillDefaultForegroundItems() {
            ListBoxModel m = new ListBoxModel();
            m.add("Jenkins Default", "");
            for (AnsiColorMap.Color color : AnsiColorMap.Color.values()) {
                m.add(color.toString(), String.valueOf(color.ordinal()));
            }
            return m;
        }

        public ListBoxModel doFillDefaultBackgroundItems() {
            return this.doFillDefaultForegroundItems();
        }

        public String getDisplayName() {
            return Messages.DisplayName();
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        static {
            VALIDATED_FIELDS.put("black", AnsiColorMap::getBlack);
            VALIDATED_FIELDS.put("blackB", AnsiColorMap::getBlackB);
            VALIDATED_FIELDS.put("red", AnsiColorMap::getRed);
            VALIDATED_FIELDS.put("redB", AnsiColorMap::getRedB);
            VALIDATED_FIELDS.put("green", AnsiColorMap::getGreen);
            VALIDATED_FIELDS.put("greenB", AnsiColorMap::getGreenB);
            VALIDATED_FIELDS.put("yellow", AnsiColorMap::getYellow);
            VALIDATED_FIELDS.put("yellowB", AnsiColorMap::getYellowB);
            VALIDATED_FIELDS.put("blue", AnsiColorMap::getBlue);
            VALIDATED_FIELDS.put("blueB", AnsiColorMap::getBlueB);
            VALIDATED_FIELDS.put("magenta", AnsiColorMap::getMagenta);
            VALIDATED_FIELDS.put("magentaB", AnsiColorMap::getMagentaB);
            VALIDATED_FIELDS.put("cyan", AnsiColorMap::getCyan);
            VALIDATED_FIELDS.put("cyanB", AnsiColorMap::getCyanB);
            VALIDATED_FIELDS.put("white", AnsiColorMap::getWhite);
            VALIDATED_FIELDS.put("whiteB", AnsiColorMap::getWhiteB);
        }
    }
}

