/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ansicolor;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.Serializable;

class AnsiAttributeElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    AnsiAttrType ansiAttrType;
    String name;
    String attributes;

    public AnsiAttributeElement(AnsiAttrType ansiAttrType, String name, String attributes) {
        this.ansiAttrType = ansiAttrType;
        this.name = name;
        this.attributes = attributes;
    }

    public void emitOpen(Emitter emitter) {
        String openingTagHtml = "<" + this.name + (String)(this.attributes.trim().equals("") ? "" : " " + this.attributes) + ">";
        emitter.emitHtml(openingTagHtml);
    }

    public void emitClose(Emitter emitter) {
        String closingTagHtml = "</" + this.name + ">";
        emitter.emitHtml(closingTagHtml);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnsiAttributeElement tag = (AnsiAttributeElement)o;
        return this.attributes.equals(tag.attributes) && this.name.equals(tag.name) && this.ansiAttrType == tag.ansiAttrType;
    }

    public int hashCode() {
        int result = this.ansiAttrType.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.attributes.hashCode();
        return result;
    }

    public String toString() {
        return "AnsiAttributeElement{ansiAttrType=" + String.valueOf((Object)this.ansiAttrType) + ",name=" + this.name + ",attributes=" + this.attributes + "}";
    }

    public static AnsiAttributeElement bold() {
        return new AnsiAttributeElement(AnsiAttrType.BOLD, "b", "");
    }

    public static AnsiAttributeElement faint() {
        return new AnsiAttributeElement(AnsiAttrType.FAINT, "span", "style=\"font-weight: lighter;\"");
    }

    public static AnsiAttributeElement italic() {
        return new AnsiAttributeElement(AnsiAttrType.ITALIC, "i", "");
    }

    public static AnsiAttributeElement underline() {
        return new AnsiAttributeElement(AnsiAttrType.UNDERLINE, "u", "");
    }

    public static AnsiAttributeElement underlineDouble() {
        return new AnsiAttributeElement(AnsiAttrType.UNDERLINE, "span", "style=\"border-bottom: 3px double;\"");
    }

    public static AnsiAttributeElement strikeout() {
        return new AnsiAttributeElement(AnsiAttrType.STRIKEOUT, "span", "style=\"text-decoration: line-through;\"");
    }

    public static AnsiAttributeElement framed() {
        return new AnsiAttributeElement(AnsiAttrType.FRAMED, "span", "style=\"border: 1px solid;\"");
    }

    public static AnsiAttributeElement overline() {
        return new AnsiAttributeElement(AnsiAttrType.OVERLINE, "span", "style=\"text-decoration: overline;\"");
    }

    public static enum AnsiAttrType {
        DEFAULT,
        BOLD,
        FAINT,
        ITALIC,
        UNDERLINE,
        STRIKEOUT,
        FRAMED,
        OVERLINE,
        FG,
        BG,
        FGBG;

    }

    public static interface Emitter {
        public void emitHtml(@NonNull String var1);

        default public void emitInvisibleSequence() {
        }
    }
}

