/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.androidsigning;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.util.ArgumentListBuilder;
import hudson.util.VersionNumber;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.androidsigning.GetPathSeparator;

class ZipalignTool {
    static final String ENV_ANDROID_HOME = "ANDROID_HOME";
    static final String ENV_ZIPALIGN_PATH = "ANDROID_ZIPALIGN";
    static final String ENV_PATH = "PATH";
    private final EnvVars buildEnv;
    private final FilePath workspace;
    private final PrintStream logger;
    private final String overrideAndroidHome;
    private final String overrideZipalignPath;
    private FilePath zipalign;

    private static FilePath findFromEnv(EnvVars env, FilePath workspace, PrintStream logger) throws AbortException {
        String zipalignPath = (String)env.get((Object)ENV_ZIPALIGN_PATH);
        if (!StringUtils.isEmpty((String)zipalignPath)) {
            zipalignPath = env.expand(zipalignPath);
            logger.printf("[SignApksBuilder] found zipalign path in env %s=%s%n", ENV_ZIPALIGN_PATH, zipalignPath);
            FilePath zipalign = new FilePath(workspace.getChannel(), zipalignPath);
            return ZipalignTool.zipalignOrZipalignExe(zipalign, logger);
        }
        String androidHome = (String)env.get((Object)ENV_ANDROID_HOME);
        if (!StringUtils.isEmpty((String)androidHome)) {
            androidHome = env.expand(androidHome);
            logger.printf("[SignApksBuilder] searching environment variable %s=%s for zipalign...%n", ENV_ANDROID_HOME, androidHome);
            return ZipalignTool.findInAndroidHome(androidHome, workspace, logger);
        }
        String envPath = (String)env.get((Object)ENV_PATH);
        if (!StringUtils.isEmpty((String)envPath)) {
            envPath = env.expand(envPath);
            logger.printf("[SignApksBuilder] searching environment %s=%s for zipalign...%n", ENV_PATH, envPath);
            return ZipalignTool.findInPathEnvVar(envPath, workspace, logger);
        }
        throw new AbortException("failed to find zipalign: no environment variable ANDROID_ZIPALIGN or ANDROID_HOME or PATH");
    }

    private static FilePath findInAndroidHome(String androidHome, FilePath workspace, PrintStream logger) throws AbortException {
        List versionDirs;
        FilePath buildTools = workspace.child(androidHome).child("build-tools");
        try {
            versionDirs = buildTools.listDirectories();
        }
        catch (Exception e) {
            e.printStackTrace(logger);
            throw new AbortException(String.format("failed to find zipalign: error listing build-tools versions in %s: %s", buildTools.getRemote(), e.getLocalizedMessage()));
        }
        if (versionDirs == null || versionDirs.isEmpty()) {
            throw new AbortException("failed to find zipalign: no build-tools directory in Android home path " + androidHome);
        }
        TreeMap<VersionNumber, FilePath> versions = new TreeMap<VersionNumber, FilePath>();
        for (FilePath versionDir : versionDirs) {
            String versionName = versionDir.getName();
            VersionNumber version = new VersionNumber(versionName);
            versions.put(version, versionDir);
        }
        if (versions.isEmpty()) {
            throw new AbortException("failed to find zipalign: no build-tools versions in Android home path " + String.valueOf(buildTools));
        }
        VersionNumber latest = (VersionNumber)versions.lastKey();
        buildTools = (FilePath)versions.get(latest);
        FilePath zipalign = ZipalignTool.zipalignOrZipalignExe(buildTools, logger);
        if (zipalign != null) {
            logger.printf("[SignApksBuilder] found zipalign in Android SDK's latest build tools: %s%n", zipalign.getRemote());
            return zipalign;
        }
        throw new AbortException("failed to find zipalign: no zipalign found in latest Android build tools: " + String.valueOf(buildTools));
    }

    private static FilePath findInPathEnvVar(String envPath, FilePath workspace, PrintStream logger) throws AbortException {
        String[] dirs;
        String separator = null;
        try {
            separator = ZipalignTool.pathSeparatorForWorkspace(workspace);
        }
        catch (Exception e) {
            logger.println("[SignApksBuilder] error determining path separator:");
            e.printStackTrace(logger);
            return null;
        }
        for (String dir : dirs = envPath.split(separator)) {
            logger.printf("[SignApksBuilder] checking %s dir %s for zipalign...%n", ENV_PATH, dir);
            FilePath dirPath = workspace.child(dir);
            FilePath zipalign = ZipalignTool.zipalignOrZipalignExe(dirPath, logger);
            if (zipalign != null) {
                return zipalign;
            }
            try {
                dirPath = ZipalignTool.androidHomeAncestorOfPath(dirPath, logger);
            }
            catch (Exception e) {
                logger.println("error searching PATH environment variable: " + e.getMessage());
                e.printStackTrace(logger);
            }
            if (dirPath == null) continue;
            logger.printf("[SignApksBuilder] found potential Android home in %s dir %s%n", ENV_PATH, dir);
            try {
                return ZipalignTool.findInAndroidHome(dirPath.getRemote(), workspace, logger);
            }
            catch (AbortException e) {
                logger.printf("error searching Android home found in PATH: " + e.getMessage(), new Object[0]);
            }
        }
        return null;
    }

    private static String pathSeparatorForWorkspace(FilePath workspace) throws IOException, InterruptedException {
        return (String)workspace.act((FilePath.FileCallable)new GetPathSeparator());
    }

    private static FilePath androidHomeAncestorOfPath(FilePath path, PrintStream logger) throws Exception {
        if ("bin".equals(path.getName())) {
            FilePath sdkmanager = path.child("sdkmanager");
            if (ZipalignTool.commandOrWinCommandAtPath(sdkmanager, logger) != null && (path = path.getParent()) != null && "tools".equals(path.getName())) {
                return path.getParent();
            }
        } else if ("tools".equals(path.getName())) {
            FilePath androidTool = path.child("android");
            if (ZipalignTool.commandOrWinCommandAtPath(androidTool, logger) != null) {
                return path.getParent();
            }
        } else {
            FilePath androidTool = path.child("tools").child("android");
            if (ZipalignTool.commandOrWinCommandAtPath(androidTool, logger) != null) {
                return path;
            }
        }
        return null;
    }

    private static FilePath zipalignOrZipalignExe(FilePath zipalignOrDir, PrintStream logger) {
        FilePath parent = zipalignOrDir.getParent();
        try {
            if (zipalignOrDir.isDirectory()) {
                parent = zipalignOrDir;
                zipalignOrDir = zipalignOrDir.child("zipalign");
            }
        }
        catch (Exception e) {
            logger.println("[SignApksBuilder] error checking for zipalign at path " + String.valueOf(zipalignOrDir));
            e.printStackTrace(logger);
        }
        zipalignOrDir = ZipalignTool.commandOrWinCommandAtPath(zipalignOrDir, logger);
        if (zipalignOrDir != null) {
            return zipalignOrDir;
        }
        logger.println("[SignApksBuilder] no zipalign or zipalign.exe found in path " + String.valueOf(parent));
        return null;
    }

    private static FilePath commandOrWinCommandAtPath(FilePath path, PrintStream logger) {
        try {
            if (path.isDirectory()) {
                return null;
            }
            if (path.exists()) {
                return path;
            }
            FilePath parent = path.getParent();
            if (parent == null) {
                return null;
            }
            String name = path.getName();
            String winCommand = name + ".exe";
            if ((path = parent.child(winCommand)).exists()) {
                return path;
            }
            winCommand = name + ".bat";
            path = parent.child(winCommand);
            if (path.exists()) {
                return path;
            }
        }
        catch (Exception e) {
            logger.println("[SignApksBuilder] error checking path " + String.valueOf(path));
            e.printStackTrace(logger);
        }
        return null;
    }

    ZipalignTool(@NonNull EnvVars buildEnv, @NonNull FilePath workspace, @NonNull PrintStream logger, @Nullable String overrideAndroidHome, @Nullable String overrideZipalignPath) {
        this.buildEnv = buildEnv;
        this.workspace = workspace;
        this.logger = logger;
        this.overrideAndroidHome = overrideAndroidHome;
        this.overrideZipalignPath = overrideZipalignPath;
    }

    ArgumentListBuilder commandFor(String unsignedApk, String outputApk) throws AbortException {
        if (this.zipalign == null) {
            if (!StringUtils.isEmpty((String)this.overrideZipalignPath)) {
                this.logger.printf("[SignApksBuilder] zipalign path explicitly set to %s%n", this.overrideZipalignPath);
                this.zipalign = ZipalignTool.zipalignOrZipalignExe(this.workspace.child(this.buildEnv.expand(this.overrideZipalignPath)), this.logger);
            } else if (!StringUtils.isEmpty((String)this.overrideAndroidHome)) {
                this.logger.printf("[SignApksBuilder] zipalign %s explicitly set to %s%n", ENV_ANDROID_HOME, this.overrideAndroidHome);
                String expandedAndroidHome = this.buildEnv.expand(this.overrideAndroidHome);
                this.zipalign = ZipalignTool.findInAndroidHome(expandedAndroidHome, this.workspace, this.logger);
            } else {
                this.zipalign = ZipalignTool.findFromEnv(this.buildEnv, this.workspace, this.logger);
            }
            if (this.zipalign == null) {
                throw new AbortException("failed to find zipalign path in parameters or environment");
            }
        }
        return new ArgumentListBuilder().add(this.zipalign.getRemote()).add("-P").add("16").add("-f").add("4").add(unsignedApk).add(outputApk);
    }
}

