/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.androidsigning;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.FilePath;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.androidsigning.Messages;
import org.jenkinsci.plugins.androidsigning.SignApksBuilder;
import org.kohsuke.stapler.DataBoundConstructor;

public abstract class SignedApkMappingStrategy
extends AbstractDescribableImpl<SignedApkMappingStrategy>
implements ExtensionPoint {
    public abstract FilePath destinationForUnsignedApk(FilePath var1, FilePath var2);

    public static ExtensionList<SignedApkMappingStrategy> all() {
        return Jenkins.getActiveInstance().getExtensionList(SignedApkMappingStrategy.class);
    }

    public static String unqualifiedNameOfUnsignedApk(FilePath unsignedApk) {
        Pattern stripUnsignedPattern = Pattern.compile("(-?unsigned)?$", 2);
        Matcher stripUnsigned = stripUnsignedPattern.matcher(unsignedApk.getBaseName());
        return stripUnsigned.replaceFirst("");
    }

    public static class UnsignedApkSiblingMapping
    extends SignedApkMappingStrategy {
        @DataBoundConstructor
        public UnsignedApkSiblingMapping() {
        }

        @Override
        public FilePath destinationForUnsignedApk(FilePath unsignedApk, FilePath workspace) {
            FilePath file;
            Object strippedName = UnsignedApkSiblingMapping.unqualifiedNameOfUnsignedApk(unsignedApk);
            if (!unsignedApk.getBaseName().endsWith("-unsigned")) {
                strippedName = (String)strippedName + "-signed";
            }
            if ((file = unsignedApk.getParent()) == null) {
                return null;
            }
            return file.child((String)strippedName + ".apk");
        }

        @Extension
        @Symbol(value={"unsignedApkSibling"})
        public static class DescriptorImpl
        extends Descriptor<SignedApkMappingStrategy> {
            @Nonnull
            public String getDisplayName() {
                return Messages.signedApkMapping_unsignedSibling_displayName();
            }
        }
    }

    public static class UnsignedApkBuilderDirMapping
    extends SignedApkMappingStrategy {
        @DataBoundConstructor
        public UnsignedApkBuilderDirMapping() {
        }

        @Override
        public FilePath destinationForUnsignedApk(FilePath unsignedApk, FilePath workspace) {
            String strippedName = UnsignedApkBuilderDirMapping.unqualifiedNameOfUnsignedApk(unsignedApk);
            return workspace.child(SignApksBuilder.BUILDER_DIR).child(unsignedApk.getName()).child(strippedName + "-signed.apk");
        }

        @Extension
        @Symbol(value={"unsignedApkNameDir"})
        public static class DescriptorImpl
        extends Descriptor<SignedApkMappingStrategy> {
            @Nonnull
            public String getDisplayName() {
                return Messages.signedApkMapping_builderDir_displayName();
            }
        }
    }
}

