/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationslib.com.google.gson.internal.bind;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import se.bjurr.violations.violationslib.com.google.gson.Gson;
import se.bjurr.violations.violationslib.com.google.gson.TypeAdapter;
import se.bjurr.violations.violationslib.com.google.gson.TypeAdapterFactory;
import se.bjurr.violations.violationslib.com.google.gson.internal.ConstructorConstructor;
import se.bjurr.violations.violationslib.com.google.gson.internal.GsonTypes;
import se.bjurr.violations.violationslib.com.google.gson.internal.ObjectConstructor;
import se.bjurr.violations.violationslib.com.google.gson.internal.bind.TypeAdapterRuntimeTypeWrapper;
import se.bjurr.violations.violationslib.com.google.gson.reflect.TypeToken;
import se.bjurr.violations.violationslib.com.google.gson.stream.JsonReader;
import se.bjurr.violations.violationslib.com.google.gson.stream.JsonToken;
import se.bjurr.violations.violationslib.com.google.gson.stream.JsonWriter;

public final class CollectionTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor constructorConstructor;

    public CollectionTypeAdapterFactory(ConstructorConstructor constructorConstructor) {
        this.constructorConstructor = constructorConstructor;
    }

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        Type type = typeToken.getType();
        Class<T> rawType = typeToken.getRawType();
        if (!Collection.class.isAssignableFrom(rawType)) {
            return null;
        }
        Type elementType = GsonTypes.getCollectionElementType(type, rawType);
        TypeAdapter<?> elementTypeAdapter = gson.getAdapter(TypeToken.get(elementType));
        TypeAdapterRuntimeTypeWrapper wrappedTypeAdapter = new TypeAdapterRuntimeTypeWrapper(gson, elementTypeAdapter, elementType);
        boolean allowUnsafe = false;
        ObjectConstructor<T> constructor = this.constructorConstructor.get(typeToken, allowUnsafe);
        Adapter result = new Adapter(wrappedTypeAdapter, constructor);
        return result;
    }

    private static final class Adapter<E>
    extends TypeAdapter<Collection<E>> {
        private final TypeAdapter<E> elementTypeAdapter;
        private final ObjectConstructor<? extends Collection<E>> constructor;

        Adapter(TypeAdapter<E> elementTypeAdapter, ObjectConstructor<? extends Collection<E>> constructor) {
            this.elementTypeAdapter = elementTypeAdapter;
            this.constructor = constructor;
        }

        @Override
        public Collection<E> read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            Collection<E> collection = this.constructor.construct();
            in.beginArray();
            while (in.hasNext()) {
                E instance = this.elementTypeAdapter.read(in);
                collection.add(instance);
            }
            in.endArray();
            return collection;
        }

        @Override
        public void write(JsonWriter out, Collection<E> collection) throws IOException {
            if (collection == null) {
                out.nullValue();
                return;
            }
            out.beginArray();
            for (E element : collection) {
                this.elementTypeAdapter.write(out, element);
            }
            out.endArray();
        }
    }
}

