/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.Utils;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class GoLintParser
implements ViolationsParser {
    @Override
    public Set<Violation> parseReportOutput(String reportContent, ViolationsLogger violationsLogger) throws Exception {
        TreeSet<Violation> violations = new TreeSet<Violation>();
        List<List<String>> partsPerLine = ViolationParserUtils.getLines(reportContent, "^([^:]+?):(\\d*):?(\\d*?):?([^:]*?)?:? (.*)$");
        for (List<String> parts : partsPerLine) {
            String fileName = parts.get(1);
            Integer lineNumber = 0;
            if (!parts.get(2).isEmpty()) {
                lineNumber = Integer.parseInt(parts.get(2));
            }
            Integer columnNumber = 0;
            if (!parts.get(3).isEmpty()) {
                columnNumber = Integer.parseInt(parts.get(3));
            }
            String severity = parts.get(4);
            String message = parts.get(5);
            violations.add(Violation.violationBuilder().setParser(Parser.GOLINT).setStartLine(lineNumber).setColumn(columnNumber).setFile(fileName).setSeverity(this.toSeverity(severity)).setMessage(message).build());
        }
        return violations;
    }

    public SEVERITY toSeverity(String severity) {
        if (Utils.isNullOrEmpty(severity)) {
            return SEVERITY.INFO;
        }
        if (severity.equalsIgnoreCase("error")) {
            return SEVERITY.ERROR;
        }
        if (severity.equalsIgnoreCase("warning")) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }
}

