/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.Utils;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class Flake8Parser
implements ViolationsParser {
    @Override
    public Set<Violation> parseReportOutput(String string, ViolationsLogger violationsLogger) throws Exception {
        TreeSet<Violation> violations = new TreeSet<Violation>();
        List<List<String>> partsPerLine = ViolationParserUtils.getLines(string, "([^:]+):(\\d+):( \\[([A-Z]{1,8})([0-9]{0,6})\\] (.+)|(\\d+): ([A-Z]{1,8})([0-9]{0,6}) (.+))");
        for (List<String> parts : partsPerLine) {
            String message;
            String rule;
            String severity;
            Integer line;
            String filename = parts.get(1);
            try {
                line = Integer.parseInt(parts.get(2));
            }
            catch (Exception e) {
                continue;
            }
            Integer column = null;
            if (!Utils.isNullOrEmpty(parts.get(7))) {
                column = Integer.parseInt(parts.get(7));
                severity = parts.get(8);
                rule = parts.get(9);
                message = parts.get(10);
            } else {
                severity = parts.get(4);
                rule = parts.get(5);
                message = parts.get(6);
            }
            if (Utils.isNullOrEmpty(message)) continue;
            violations.add(Violation.violationBuilder().setParser(Parser.FLAKE8).setStartLine(line).setColumn(column).setFile(filename).setRule(severity + rule).setSeverity(this.toSeverity(severity.substring(0, 1))).setMessage(message).build());
        }
        return violations;
    }

    public SEVERITY toSeverity(String severity) {
        if (severity.equalsIgnoreCase("E") || severity.equalsIgnoreCase("F")) {
            return SEVERITY.ERROR;
        }
        if (severity.equalsIgnoreCase("W")) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }
}

