/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.util;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import edu.umd.cs.findbugs.charsets.UTF8;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import javax.annotation.Nonnull;
import javax.annotation.WillClose;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.WillNotClose;

public class Util {
    static Collection<Runnable> runAtShutdown;
    static final Pattern tag;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;

    public static Thread startDameonThread(Thread t) {
        t.setDaemon(true);
        t.start();
        return t;
    }

    public static Thread runInDameonThread(Runnable r, String name) {
        Thread t = new Thread(r, name);
        return Util.startDameonThread(t);
    }

    public static Thread runInDameonThread(Runnable r) {
        Thread t = new Thread(r);
        return Util.startDameonThread(t);
    }

    public static String repeat(String s, int number) {
        StringBuilder b = new StringBuilder(s.length() * number);
        for (int i = 0; i < number; ++i) {
            b.append(s);
        }
        return b.toString();
    }

    public static synchronized void runLogAtShutdown(Runnable r) {
        if (ShutdownLogging.LOGGING) {
            if (runAtShutdown == null) {
                runAtShutdown = new LinkedList<Runnable>();
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        for (Runnable r : runAtShutdown) {
                            try {
                                r.run();
                            }
                            catch (RuntimeException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                });
            }
            runAtShutdown.add(r);
        }
    }

    public static <T> Set<T> emptyOrNonnullSingleton(T t) {
        if (t == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(t);
    }

    public static <K, V> Map<K, V> immutableMap(Map<K, V> map) {
        if (map.size() == 0) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(map);
    }

    public static Reader getReader(@WillCloseWhenClosed InputStream in) {
        return UTF8.reader(in);
    }

    public static Reader getFileReader(String filename) throws IOException {
        return Util.getReader(Files.newInputStream(Path.of(filename, new String[0]), new OpenOption[0]));
    }

    public static Reader getFileReader(File filename) throws IOException {
        return Util.getReader(Files.newInputStream(filename.toPath(), new OpenOption[0]));
    }

    public static Writer getWriter(@WillCloseWhenClosed OutputStream out) {
        return UTF8.writer(out);
    }

    public static Writer getFileWriter(String filename) throws IOException {
        return Util.getWriter(Files.newOutputStream(Path.of(filename, new String[0]), new OpenOption[0]));
    }

    public static void closeSilently(@WillClose InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Deprecated
    public static void closeSilently(@WillClose Reader in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Deprecated
    public static void closeSilently(@WillClose OutputStream out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Deprecated
    public static void closeSilently(@WillClose Closeable out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Deprecated
    public static void closeSilently(@WillClose ZipFile zip) {
        try {
            if (zip != null) {
                zip.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @SuppressFBWarnings(value={"OS_OPEN_STREAM"})
    public static String getXMLType(@WillNotClose InputStream in) throws IOException {
        if (!in.markSupported()) {
            throw new IllegalArgumentException("Input stream does not support mark");
        }
        in.mark(5000);
        try {
            String s;
            BufferedReader r = new BufferedReader(Util.getReader(in), 2000);
            while ((s = r.readLine()) != null) {
                Matcher m = tag.matcher(s);
                if (!m.find()) continue;
                String string = m.group(1);
                return string;
            }
            throw new IOException("Didn't find xml tag");
        }
        finally {
            in.reset();
        }
    }

    private static String getFileExtension(String name) {
        int lastDot = name.lastIndexOf(46);
        if (lastDot == -1) {
            return "";
        }
        return name.substring(lastDot + 1);
    }

    public static String getFileExtension(File f) {
        return Util.getFileExtension(f.getName().toLowerCase());
    }

    public static String getFileExtensionIgnoringGz(File f) {
        String name = f.getName().toLowerCase();
        if (name.endsWith(".gz")) {
            name = name.substring(0, name.length() - 3);
        }
        return Util.getFileExtension(name);
    }

    public static <E> E first(Iterable<E> i) {
        Iterator<E> iterator = i.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("iterator has no elements");
        }
        return iterator.next();
    }

    public static <K, V> HashMap<K, V> makeSmallHashMap(Map<K, V> m) {
        HashMap<K, V> result = new HashMap<K, V>((int)((float)m.size() / 0.75f + 2.0f));
        result.putAll(m);
        return result;
    }

    public static <K> HashSet<K> makeSmallHashSet(Collection<K> m) {
        HashSet<K> result = new HashSet<K>((int)((float)m.size() / 0.75f + 2.0f));
        result.addAll(m);
        return result;
    }

    public static <K> ArrayList<K> makeSmallArrayList(List<K> m) {
        ArrayList<K> result = new ArrayList<K>(m.size() + 2);
        result.addAll(m);
        return result;
    }

    public static <K> Set<K> addTo(Set<K> s, K k) {
        if (s.isEmpty()) {
            return Collections.singleton(k);
        }
        if (s.contains(k)) {
            return s;
        }
        if (s instanceof HashSet) {
            s.add(k);
            return s;
        }
        HashSet<K> result = Util.makeSmallHashSet(s);
        result.add(k);
        return result;
    }

    public static <K> List<K> addTo(List<K> s, K k) {
        if (s.isEmpty()) {
            return Collections.singletonList(k);
        }
        if (!(s instanceof ArrayList)) {
            s = Util.makeSmallArrayList(s);
        }
        s.add(k);
        return s;
    }

    @Nonnull
    public static MessageDigest getMD5Digest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("Unable to get MD5 digest", e);
        }
    }

    public static boolean isPowerOfTwo(int i) {
        return i > 0 && (i | i - 1) + 1 == 2 * i;
    }

    static {
        tag = Pattern.compile("^\\s*<(\\w+)");
    }

    static class ShutdownLogging {
        public static final boolean LOGGING = SystemProperties.getBoolean("findbugs.shutdownLogging");

        ShutdownLogging() {
        }
    }
}

