/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import java.util.Map;
import java.util.Set;

public class DontUseFloatsAsLoopCounters
extends OpcodeStackDetector
implements StatelessDetector {
    private final BugReporter bugReporter;
    private static final Map<Integer, Integer> FLOAT_LOADERS = Map.of(23, 2, 34, 1, 35, 1, 36, 1, 37, 1, 24, 2, 38, 1, 39, 1, 40, 1, 41, 1);
    private static final Map<Integer, Integer> FLOAT_CONSTANT_PUSHERS = Map.of(12, 1, 13, 1, 15, 1, 18, 2, 19, 3, 20, 3);
    private static final Set<Integer> FLOAT_COMPARERS = Set.of(Integer.valueOf(150), Integer.valueOf(149), Integer.valueOf(152), Integer.valueOf(151));
    private static final Set<Integer> FLOAT_STORERS = Set.of(Integer.valueOf(56), Integer.valueOf(67), Integer.valueOf(68), Integer.valueOf(69), Integer.valueOf(70), Integer.valueOf(57), Integer.valueOf(71), Integer.valueOf(72), Integer.valueOf(73), Integer.valueOf(74));
    private static final Set<Integer> FLOAT_ADDITIVE_OPS = Set.of(Integer.valueOf(98), Integer.valueOf(102), Integer.valueOf(99), Integer.valueOf(103));

    public DontUseFloatsAsLoopCounters(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void sawOpcode(int seen) {
        if ((seen == 167 || seen == 200) && this.getBranchTarget() < this.getPC() && this.checkLoopEnd() && this.checkLoopStart(this.getBranchTarget())) {
            this.bugReporter.reportBug(new BugInstance(this, "FL_FLOATS_AS_LOOP_COUNTERS", 2).addClassAndMethod(this).addSourceLine(this, this.getBranchTarget()));
        }
    }

    private boolean checkLoopEnd() {
        return FLOAT_STORERS.contains(this.getPrevOpcode(1)) && FLOAT_ADDITIVE_OPS.contains(this.getPrevOpcode(2));
    }

    private boolean checkLoopStart(int startPC) {
        if (!FLOAT_LOADERS.containsKey(this.getCodeByte(startPC))) {
            return false;
        }
        int nextPC = startPC + FLOAT_LOADERS.get(this.getCodeByte(startPC));
        if (!FLOAT_CONSTANT_PUSHERS.containsKey(this.getCodeByte(nextPC))) {
            return false;
        }
        nextPC += FLOAT_CONSTANT_PUSHERS.get(this.getCodeByte(nextPC)).intValue();
        if (!FLOAT_COMPARERS.contains(this.getCodeByte(nextPC++))) {
            return false;
        }
        return DontUseFloatsAsLoopCounters.isBranch(this.getCodeByte(nextPC));
    }
}

