/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.util.ClassName;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class ConstructorThrow
extends OpcodeStackDetector {
    private final BugAccumulator bugAccumulator;
    private final Map<String, Map<String, Set<String>>> exHandlesToMethodCallsByMethodsMap = new HashMap<String, Map<String, Set<String>>>();
    private final Map<String, Set<JavaClass>> thrownExsByMethodMap = new HashMap<String, Set<JavaClass>>();
    private boolean isFinalClass = false;
    private boolean isFinalFinalizer = false;
    private boolean isFirstPass = true;
    private boolean hadObjectConstructor = false;

    public ConstructorThrow(BugReporter bugReporter) {
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public void visit(JavaClass obj) {
        this.resetState();
        if (obj.isFinal()) {
            this.isFinalClass = true;
            return;
        }
        this.isFinalFinalizer = ConstructorThrow.hasFinalFinalizer(obj);
        try {
            for (JavaClass javaClass : obj.getSuperClasses()) {
                this.isFinalFinalizer |= ConstructorThrow.hasFinalFinalizer(javaClass);
            }
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
        }
        for (JavaClass javaClass : obj.getMethods()) {
            this.doVisitMethod((Method)javaClass);
        }
        this.isFirstPass = false;
    }

    private static boolean hasFinalFinalizer(JavaClass jc) {
        return Arrays.stream(jc.getMethods()).anyMatch(m -> "finalize".equals(m.getName()) && "()V".equals(m.getSignature()) && m.isFinal());
    }

    @Override
    public void visit(Method obj) {
        this.hadObjectConstructor = false;
        super.visit(obj);
    }

    @Override
    public void visitAfter(JavaClass obj) {
        super.visit(obj);
        this.bugAccumulator.reportAccumulatedBugs();
    }

    @Override
    public void sawOpcode(int seen) {
        if (this.isFinalClass || this.isFinalFinalizer) {
            return;
        }
        if (this.isFirstPass) {
            this.collectExceptionsByMethods(seen);
        } else if ("<init>".equals(this.getMethodName())) {
            this.reportConstructorThrow(seen);
        }
    }

    private void reportConstructorThrow(int seen) {
        if (seen == 191) {
            OpcodeStack.Item item = this.stack.getStackItem(0);
            if (item != null) {
                try {
                    JavaClass thrownExClass = item.getJavaClass();
                    if (thrownExClass == null || "java.lang.Throwable".equals(thrownExClass.getClassName())) {
                        return;
                    }
                    Set<String> caughtExes = this.getSurroundingCaughtExes(this.getConstantPool());
                    if (ConstructorThrow.isThrownExNotCaught(thrownExClass, caughtExes)) {
                        this.accumulateBug();
                    }
                }
                catch (ClassNotFoundException e) {
                    AnalysisContext.reportMissingClass(e);
                }
            }
        } else if (this.isMethodCall()) {
            if ("<init>".equals(this.getNameConstantOperand())) {
                this.hadObjectConstructor = true;
            }
            String calledMethodFQN = this.getCalledMethodFQN();
            Set<JavaClass> unhandledExes = this.getUnhandledExThrowsInMethod(calledMethodFQN, new HashSet<String>());
            if (this.hadObjectConstructor && !unhandledExes.isEmpty()) {
                Set<String> caughtExes = this.getSurroundingCaughtExes(this.getConstantPool());
                boolean hasNotCaughtExFromBody = unhandledExes.stream().anyMatch(ex -> ConstructorThrow.isThrownExNotCaught(ex, caughtExes));
                if (hasNotCaughtExFromBody) {
                    this.accumulateBug();
                }
            }
        }
    }

    private Set<JavaClass> getUnhandledExThrowsInMethod(String method, Set<String> visitedMethods) {
        HashSet<JavaClass> unhandledExesInMethod = new HashSet<JavaClass>();
        if (visitedMethods.contains(method)) {
            return unhandledExesInMethod;
        }
        visitedMethods.add(method);
        if (this.thrownExsByMethodMap.containsKey(method)) {
            unhandledExesInMethod.addAll((Collection<JavaClass>)this.thrownExsByMethodMap.get(method));
        }
        if (this.exHandlesToMethodCallsByMethodsMap.containsKey(method)) {
            Map<String, Set<String>> exHandlesByMethodCalls = this.exHandlesToMethodCallsByMethodsMap.get(method);
            for (Map.Entry<String, Set<String>> entry : exHandlesByMethodCalls.entrySet()) {
                String calledMethod = entry.getKey();
                Set<JavaClass> unhandledExes = this.getUnhandledExThrowsInMethod(calledMethod, visitedMethods);
                Set<String> exHandles = entry.getValue();
                Set remainingUnhandledExes = unhandledExes.stream().filter(ex -> !this.isHandled((JavaClass)ex, exHandles)).collect(Collectors.toSet());
                unhandledExesInMethod.addAll(remainingUnhandledExes);
            }
        }
        return unhandledExesInMethod;
    }

    private boolean isHandled(JavaClass thrownEx, Set<String> exHandles) {
        return exHandles.stream().allMatch(handle -> ConstructorThrow.isHandled(thrownEx, handle));
    }

    private static boolean isHandled(JavaClass thrownEx, @DottedClassName @NonNull String caughtEx) {
        try {
            return thrownEx.getClassName().equals(caughtEx) || Arrays.stream(thrownEx.getSuperClasses()).anyMatch(e -> e.getClassName().equals(caughtEx));
        }
        catch (ClassNotFoundException e2) {
            AnalysisContext.reportMissingClass(e2);
            return false;
        }
    }

    private Set<String> getSurroundingCaughtExes(ConstantPool cp) {
        return this.getSurroundingCaughtExceptionTypes(this.getPC(), Integer.MAX_VALUE).stream().filter(i -> i != 0).map(caughtExType -> cp.constantToString(cp.getConstant(caughtExType.intValue()))).collect(Collectors.toSet());
    }

    private static boolean isThrownExNotCaught(JavaClass thrownEx, Set<String> caughtExes) {
        return caughtExes.stream().noneMatch(caughtEx -> ConstructorThrow.isHandled(thrownEx, caughtEx));
    }

    private static String toDotted(String signature) {
        if (signature.startsWith("L") && signature.endsWith(";")) {
            return ClassName.toDottedClassName(signature.substring(1, signature.length() - 1));
        }
        return ClassName.toDottedClassName(signature);
    }

    private void collectExceptionsByMethods(int seen) {
        String containingMethod = this.getFullyQualifiedMethodName();
        if (seen == 191) {
            OpcodeStack.Item item = this.stack.getStackItem(0);
            if (item != null) {
                try {
                    JavaClass thrownExClass = item.getJavaClass();
                    if (thrownExClass == null || "java.lang.Throwable".equals(thrownExClass.getClassName())) {
                        return;
                    }
                    Set<String> caughtExes = this.getSurroundingCaughtExes(this.getConstantPool());
                    if (ConstructorThrow.isThrownExNotCaught(thrownExClass, caughtExes)) {
                        this.addToThrownExsByMethodMap(containingMethod, thrownExClass);
                    }
                }
                catch (ClassNotFoundException e) {
                    AnalysisContext.reportMissingClass(e);
                }
            }
        } else if (this.isMethodCall()) {
            String calledMethodName = this.getNameConstantOperand();
            String calledMethodFullName = this.getCalledMethodFQN();
            if (!"<init>".equals(calledMethodName) && !containingMethod.equals(calledMethodFullName)) {
                String[] thrownCheckedExes;
                Set<String> caughtExes = this.getSurroundingCaughtExes(this.getConstantPool());
                if (caughtExes.isEmpty()) {
                    this.addToExHandlesToMethodCallsByMethodsMap(containingMethod, calledMethodFullName, Collections.singletonList(""));
                } else {
                    this.addToExHandlesToMethodCallsByMethodsMap(containingMethod, calledMethodFullName, caughtExes);
                }
                XMethod calledXMethod = this.getXMethodOperand();
                if (calledXMethod != null && (thrownCheckedExes = calledXMethod.getThrownExceptions()) != null) {
                    for (String thrownCheckedEx : thrownCheckedExes) {
                        try {
                            JavaClass exClass = AnalysisContext.currentAnalysisContext().lookupClass(thrownCheckedEx);
                            this.addToThrownExsByMethodMap(calledMethodFullName, exClass);
                        }
                        catch (ClassNotFoundException e) {
                            AnalysisContext.reportMissingClass(e);
                        }
                    }
                }
            }
        }
    }

    private void addToExHandlesToMethodCallsByMethodsMap(String containerMethod, String calledMethod, Collection<String> caughtExes) {
        this.exHandlesToMethodCallsByMethodsMap.computeIfAbsent(containerMethod, k -> new HashMap()).computeIfAbsent(calledMethod, k -> new HashSet()).addAll(caughtExes);
    }

    private void addToThrownExsByMethodMap(String containingMethod, JavaClass thrownExClass) {
        this.thrownExsByMethodMap.computeIfAbsent(containingMethod, k -> new HashSet()).add(thrownExClass);
    }

    private String getCalledMethodFQN() {
        return String.format("%s.%s : %s", this.getDottedClassConstantOperand(), this.getNameConstantOperand(), ConstructorThrow.toDotted(this.getSigConstantOperand()));
    }

    private void resetState() {
        this.isFinalClass = false;
        this.isFinalFinalizer = false;
        this.isFirstPass = true;
        this.exHandlesToMethodCallsByMethodsMap.clear();
        this.thrownExsByMethodMap.clear();
    }

    private void accumulateBug() {
        BugInstance bug = new BugInstance(this, "CT_CONSTRUCTOR_THROW", 2).addClassAndMethod(this).addSourceLine(this, this.getPC());
        this.bugAccumulator.accumulateBug(bug, this);
    }
}

