/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.engine.bcel;

import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.LiveLocalStoreAnalysis;
import edu.umd.cs.findbugs.ba.LiveLocalStoreDataflow;
import edu.umd.cs.findbugs.ba.ReverseDepthFirstSearch;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.engine.bcel.AnalysisFactory;
import org.apache.bcel.generic.MethodGen;

public class LiveLocalStoreDataflowFactory
extends AnalysisFactory<LiveLocalStoreDataflow> {
    public LiveLocalStoreDataflowFactory() {
        super("live local stores analysis", LiveLocalStoreDataflow.class);
    }

    @Override
    public LiveLocalStoreDataflow analyze(IAnalysisCache analysisCache, MethodDescriptor descriptor) throws CheckedAnalysisException {
        MethodGen methodGen = this.getMethodGen(analysisCache, descriptor);
        if (methodGen == null) {
            return null;
        }
        CFG cfg = this.getCFG(analysisCache, descriptor);
        ReverseDepthFirstSearch rdfs = this.getReverseDepthFirstSearch(analysisCache, descriptor);
        LiveLocalStoreAnalysis analysis = new LiveLocalStoreAnalysis(methodGen, rdfs, this.getDepthFirstSearch(analysisCache, descriptor));
        LiveLocalStoreDataflow dataflow = new LiveLocalStoreDataflow(cfg, analysis);
        dataflow.execute();
        if (ClassContext.DUMP_DATAFLOW_ANALYSIS) {
            ClassContext.dumpLiveLocalStoreDataflow(descriptor, cfg, dataflow);
        }
        return dataflow;
    }
}

