/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.analysis;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.FieldOrMethodDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.ICodeBaseEntry;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.analysis.AnnotatedObject;
import edu.umd.cs.findbugs.classfile.analysis.AnnotationValue;
import edu.umd.cs.findbugs.classfile.analysis.ClassNameAndSuperclassInfo;
import edu.umd.cs.findbugs.classfile.analysis.FieldInfo;
import edu.umd.cs.findbugs.classfile.analysis.MethodInfo;
import edu.umd.cs.findbugs.classfile.engine.SelfMethodCalls;
import edu.umd.cs.findbugs.util.MultiMap;
import edu.umd.cs.findbugs.util.TopologicalSort;
import edu.umd.cs.findbugs.util.Util;
import java.lang.annotation.ElementType;
import java.lang.invoke.CallSite;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;

public class ClassInfo
extends ClassNameAndSuperclassInfo
implements XClass {
    private static final boolean DEBUG = SystemProperties.getBoolean("ci.debug");
    private final FieldInfo[] xFields;
    private final MethodInfo[] xMethods;
    private final MethodInfo[] methodsInCallOrder;
    private final ClassDescriptor immediateEnclosingClass;
    Map<ClassDescriptor, AnnotationValue> classAnnotations;
    private final String classSourceSignature;
    private final String source;
    private final boolean usesConcurrency;
    private final boolean hasStubs;
    @CheckForNull
    AnnotatedObject containingScope;
    private boolean containingScopeCached;
    private final Map<String, Map<String, MethodInfo>> polymorphicMethods;

    private MethodInfo[] computeMethodsInCallOrder() {
        HashMap<CallSite, MethodInfo> map = new HashMap<CallSite, MethodInfo>();
        for (MethodInfo m : this.xMethods) {
            map.put((CallSite)((Object)(m.getName() + m.getSignature() + m.isStatic())), m);
        }
        final MultiMap multiMap = SelfMethodCalls.getSelfCalls(this.getClassDescriptor(), map);
        TopologicalSort.OutEdges2<MethodInfo> edges1 = new TopologicalSort.OutEdges2<MethodInfo>(){

            @Override
            public Collection<MethodInfo> getOutEdges(MethodInfo method) {
                return multiMap.get(method);
            }

            @Override
            public int score(MethodInfo e) {
                return e.getMethodCallCount();
            }
        };
        List<MethodInfo> result = TopologicalSort.sortByCallGraph(Arrays.asList(this.xMethods), edges1);
        assert (this.xMethods.length == result.size());
        return result.toArray(new MethodInfo[0]);
    }

    private ClassInfo(ClassDescriptor classDescriptor, String classSourceSignature, ClassDescriptor superclassDescriptor, ClassDescriptor[] interfaceDescriptorList, ICodeBaseEntry codeBaseEntry, int accessFlags, String source, int majorVersion, int minorVersion, Collection<ClassDescriptor> referencedClassDescriptorList, Set<ClassDescriptor> calledClassDescriptors, Map<ClassDescriptor, AnnotationValue> classAnnotations, FieldInfo[] fieldDescriptorList, MethodInfo[] methodInfoList, ClassDescriptor immediateEnclosingClass, boolean usesConcurrency, boolean hasStubs, Map<String, Map<String, MethodInfo>> polymorphicMethods) {
        super(classDescriptor, superclassDescriptor, interfaceDescriptorList, codeBaseEntry, accessFlags, referencedClassDescriptorList, calledClassDescriptors, majorVersion, minorVersion);
        this.source = source;
        this.classSourceSignature = classSourceSignature;
        if (fieldDescriptorList.length == 0) {
            fieldDescriptorList = FieldInfo.EMPTY_ARRAY;
        }
        this.xFields = fieldDescriptorList;
        this.xMethods = methodInfoList;
        this.immediateEnclosingClass = immediateEnclosingClass;
        this.classAnnotations = Util.immutableMap(classAnnotations);
        this.usesConcurrency = usesConcurrency;
        this.hasStubs = hasStubs;
        this.methodsInCallOrder = this.computeMethodsInCallOrder();
        this.polymorphicMethods = polymorphicMethods;
    }

    @Override
    public List<? extends XField> getXFields() {
        return Arrays.asList(this.xFields);
    }

    @Override
    public List<? extends XMethod> getXMethods() {
        return Arrays.asList(this.xMethods);
    }

    public List<? extends XMethod> getXMethodsInCallOrder() {
        return Arrays.asList(this.methodsInCallOrder);
    }

    @Override
    public XMethod findMethod(String methodName, String methodSig, boolean isStatic) {
        int hash = FieldOrMethodDescriptor.getNameSigHashCode(methodName, methodSig);
        for (MethodInfo mInfo : this.xMethods) {
            if (!mInfo.getName().equals(methodName) || mInfo.isStatic() != isStatic) continue;
            if (mInfo.getNameSigHashCode() == hash && mInfo.getSignature().equals(methodSig)) {
                return mInfo;
            }
            if (!mInfo.hasPolymorphicSignature()) continue;
            Map methods = this.polymorphicMethods.computeIfAbsent(methodName, n -> new HashMap());
            return methods.computeIfAbsent(methodSig, s -> mInfo.withSignature((String)s));
        }
        return null;
    }

    @Override
    public XMethod findMethod(MethodDescriptor descriptor) {
        if (!descriptor.getClassDescriptor().equals(this)) {
            throw new IllegalArgumentException();
        }
        return this.findMatchingMethod(descriptor);
    }

    @Override
    public XMethod findMatchingMethod(MethodDescriptor descriptor) {
        return this.findMethod(descriptor.getName(), descriptor.getSignature(), descriptor.isStatic());
    }

    @Override
    public XField findField(String name, String signature, boolean isStatic) {
        int hash = FieldOrMethodDescriptor.getNameSigHashCode(name, signature);
        for (FieldInfo fInfo : this.xFields) {
            if (fInfo.getNameSigHashCode() != hash || !fInfo.getName().equals(name) || !fInfo.getSignature().equals(signature) || fInfo.isStatic() != isStatic) continue;
            return fInfo;
        }
        try {
            ClassDescriptor[] interfaces;
            if (this.getSuperclassDescriptor() == null) {
                return null;
            }
            XClass superClass = Global.getAnalysisCache().getClassAnalysis(XClass.class, this.getSuperclassDescriptor());
            XField result = superClass.findField(name, signature, isStatic);
            if (result != null) {
                return result;
            }
            if (!isStatic) {
                return null;
            }
            for (ClassDescriptor implementedInterface : interfaces = this.getInterfaceDescriptorList()) {
                superClass = Global.getAnalysisCache().getClassAnalysis(XClass.class, implementedInterface);
                result = superClass.findField(name, signature, isStatic);
                if (result == null) continue;
                return result;
            }
            return null;
        }
        catch (CheckedAnalysisException e) {
            return null;
        }
    }

    @Override
    public ClassDescriptor getImmediateEnclosingClass() {
        return this.immediateEnclosingClass;
    }

    @Override
    public String getPackageName() {
        String dottedClassName = this.getClassDescriptor().toDottedClassName();
        int lastDot = dottedClassName.lastIndexOf(46);
        if (lastDot < 0) {
            return "";
        }
        return dottedClassName.substring(0, lastDot);
    }

    public String getSlashedPackageName() {
        String slashedClassName = this.getClassDescriptor().getClassName();
        int lastSlash = slashedClassName.lastIndexOf(47);
        if (lastSlash < 0) {
            return "";
        }
        return slashedClassName.substring(0, lastSlash);
    }

    @Override
    public Collection<ClassDescriptor> getAnnotationDescriptors() {
        return this.classAnnotations.keySet();
    }

    @Override
    public Collection<AnnotationValue> getAnnotations() {
        return this.classAnnotations.values();
    }

    @Override
    public AnnotationValue getAnnotation(ClassDescriptor desc) {
        return this.classAnnotations.get(desc);
    }

    public void addAnnotation(AnnotationValue annotationValue) {
        HashMap<ClassDescriptor, AnnotationValue> updatedMap = new HashMap<ClassDescriptor, AnnotationValue>(this.classAnnotations);
        updatedMap.put(annotationValue.getAnnotationClass(), annotationValue);
        this.classAnnotations = Util.immutableMap(updatedMap);
    }

    @Override
    public ElementType getElementType() {
        if (this.getClassName().endsWith("package-info")) {
            return ElementType.PACKAGE;
        }
        if (this.isAnnotation()) {
            return ElementType.ANNOTATION_TYPE;
        }
        return ElementType.TYPE;
    }

    @Override
    @CheckForNull
    public String getSource() {
        return this.source;
    }

    @Override
    @CheckForNull
    public AnnotatedObject getContainingScope() {
        if (!this.containingScopeCached) {
            this.containingScope = this.getContainingScope0();
            this.containingScopeCached = true;
        }
        return this.containingScope;
    }

    @CheckForNull
    public AnnotatedObject getContainingScope0() {
        try {
            if (this.immediateEnclosingClass != null) {
                return Global.getAnalysisCache().getClassAnalysis(XClass.class, this.getImmediateEnclosingClass());
            }
            if (this.getClassName().endsWith("package-info")) {
                return null;
            }
            ClassDescriptor p = DescriptorFactory.createClassDescriptor(this.getSlashedPackageName() + "/package-info");
            return Global.getAnalysisCache().getClassAnalysis(XClass.class, p);
        }
        catch (CheckedAnalysisException e) {
            return null;
        }
    }

    @Override
    public String getSourceSignature() {
        return this.classSourceSignature;
    }

    @Override
    public boolean usesConcurrency() {
        return this.usesConcurrency;
    }

    @Override
    public boolean hasStubs() {
        return this.hasStubs;
    }

    public static class Builder
    extends ClassNameAndSuperclassInfo.Builder {
        private List<FieldInfo> fieldInfoList = new LinkedList<FieldInfo>();
        private List<MethodInfo> methodInfoList = new LinkedList<MethodInfo>();
        private final Map<MethodInfo, String> bridgedSignatures = new IdentityHashMap<MethodInfo, String>();
        private ClassDescriptor immediateEnclosingClass;
        final Map<ClassDescriptor, AnnotationValue> classAnnotations = new HashMap<ClassDescriptor, AnnotationValue>(3);
        private String classSourceSignature;
        private String source;
        boolean usesConcurrency;
        boolean hasStubs;

        @Override
        public ClassInfo build() {
            AnalysisContext context = AnalysisContext.currentAnalysisContext();
            FieldInfo[] fields = this.fieldInfoList.isEmpty() ? FieldInfo.EMPTY_ARRAY : this.fieldInfoList.toArray(new FieldInfo[0]);
            for (MethodInfo methodInfo : this.methodInfoList) {
                if (!methodInfo.isBridge() || this.bridgedSignatures.containsKey(methodInfo)) continue;
                if (DEBUG) {
                    System.out.println("Have bridge method:" + String.valueOf(methodInfo));
                }
                Object[] mArguments = new SignatureParser(methodInfo.getSignature()).getArguments();
                for (MethodInfo to : this.methodInfoList) {
                    if (methodInfo == to || to.isBridge() || !methodInfo.getName().equals(to.getName()) || !Arrays.equals(mArguments, new SignatureParser(to.getSignature()).getArguments())) continue;
                    if (DEBUG) {
                        System.out.println("  to method:" + String.valueOf(to));
                    }
                    this.bridgedSignatures.put(methodInfo, to.getSignature());
                }
            }
            for (Map.Entry entry : this.bridgedSignatures.entrySet()) {
                MethodInfo method = (MethodInfo)entry.getKey();
                String signature = (String)entry.getValue();
                for (MethodInfo m : this.methodInfoList) {
                    if (!m.getName().equals(method.getName()) || !m.getSignature().equals(signature)) continue;
                    if (DEBUG) {
                        System.out.println("Found bridge method:");
                        System.out.println("  " + String.valueOf(method));
                        if (!method.getAnnotations().isEmpty()) {
                            System.out.println("    " + String.valueOf(method.getAnnotations()));
                        }
                        System.out.println("  " + String.valueOf(m));
                        if (!m.getAnnotations().isEmpty()) {
                            System.out.println("    " + String.valueOf(m.getAnnotations()));
                        }
                    }
                    context.setBridgeMethod(method, m);
                }
            }
            MethodInfo[] methods = this.methodInfoList.isEmpty() ? MethodInfo.EMPTY_ARRAY : this.methodInfoList.toArray(new MethodInfo[0]);
            return new ClassInfo(this.classDescriptor, this.classSourceSignature, this.superclassDescriptor, this.interfaceDescriptorList, this.codeBaseEntry, this.accessFlags, this.source, this.majorVersion, this.minorVersion, this.referencedClassDescriptorList, this.calledClassDescriptors, this.classAnnotations, fields, methods, this.immediateEnclosingClass, this.usesConcurrency, this.hasStubs, new HashMap<String, Map<String, MethodInfo>>());
        }

        public void setSource(String source) {
            this.source = source;
        }

        public ClassDescriptor getClassDescriptor() {
            return this.classDescriptor;
        }

        public void setSourceSignature(String classSourceSignature) {
            this.classSourceSignature = classSourceSignature;
        }

        public void addAnnotation(String name, AnnotationValue value) {
            ClassDescriptor annotationClass = DescriptorFactory.createClassDescriptorFromSignature(name);
            this.classAnnotations.put(annotationClass, value);
        }

        public void setFieldDescriptorList(FieldInfo[] fieldDescriptorList) {
            this.fieldInfoList = Arrays.asList(fieldDescriptorList);
        }

        public void addFieldDescriptor(FieldInfo field) {
            this.fieldInfoList.add(field);
        }

        public void setMethodDescriptorList(MethodInfo[] methodDescriptorList) {
            this.methodInfoList = Arrays.asList(methodDescriptorList);
        }

        public void addMethodDescriptor(MethodInfo method) {
            this.methodInfoList.add(method);
        }

        public void addBridgeMethodDescriptor(MethodInfo from, String bridgedSignature) {
            if (bridgedSignature != null) {
                this.bridgedSignatures.put(from, bridgedSignature);
            }
            this.addMethodDescriptor(from);
        }

        public void setImmediateEnclosingClass(ClassDescriptor immediateEnclosingClass) {
            this.immediateEnclosingClass = immediateEnclosingClass;
        }

        public void setUsesConcurrency() {
            this.usesConcurrency = true;
        }

        public void setHasStubs() {
            this.hasStubs = true;
        }
    }
}

