/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.jsr305;

import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.jsr305.SourceSinkType;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import java.util.Objects;
import javax.annotation.meta.When;

public class SourceSinkInfo
implements Comparable<SourceSinkInfo> {
    private static final int PRIME = 31;
    private final SourceSinkType type;
    private final Location location;
    private final ValueNumber vn;
    private final When when;
    private int parameter;
    private int local;
    private Object constantValue;
    private boolean interproc;

    public SourceSinkInfo(SourceSinkType type, Location location, ValueNumber vn, When when) {
        this.type = type;
        this.location = location;
        this.vn = vn;
        this.when = when;
    }

    public SourceSinkType getType() {
        return this.type;
    }

    public Location getLocation() {
        return this.location;
    }

    public ValueNumber getValueNumber() {
        return this.vn;
    }

    public When getWhen() {
        return this.when;
    }

    public void setParameter(int parameter) {
        this.parameter = parameter;
    }

    public void setParameterAndLocal(int parameter, int local) {
        this.parameter = parameter;
        this.local = local;
    }

    public int getParameter() {
        return this.parameter;
    }

    public int getLocal() {
        return this.local;
    }

    public void setInterproc(boolean interproc) {
        this.interproc = interproc;
    }

    public boolean getInterproc() {
        return this.interproc;
    }

    @Override
    public int compareTo(SourceSinkInfo o) {
        return this.location.compareTo(o.location);
    }

    public Object getConstantValue() {
        return this.constantValue;
    }

    public void setConstantValue(Object constantValue) {
        this.constantValue = constantValue;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.constantValue == null ? 0 : this.constantValue.hashCode());
        result = 31 * result + (this.interproc ? 1231 : 1237);
        result = 31 * result + this.local;
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + this.parameter;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.vn == null ? 0 : this.vn.hashCode());
        result = 31 * result + (this.when == null ? 0 : this.when.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SourceSinkInfo other = (SourceSinkInfo)obj;
        return Objects.equals(this.constantValue, other.constantValue) && this.interproc == other.interproc && this.local == other.local && Objects.equals(this.location, other.location) && this.parameter == other.parameter && this.type == other.type && Objects.equals(this.vn, other.vn) && this.when == other.when;
    }

    public String toString() {
        return this.type.toString() + "@" + this.location.toCompactString() + "[vn=" + this.vn.getNumber() + ",when=" + String.valueOf(this.when) + "]";
    }
}

