/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.Frame;
import edu.umd.cs.findbugs.ba.ResourceValue;

public class ResourceValueFrame
extends Frame<ResourceValue> {
    private State status = State.NONEXISTENT;
    private static final String[] statusList = new String[]{"(escaped)", "(open)", "(open_exception)", "(closed_without_opened)", "(closed)", "(created)", "(nonexistent)", "(not_open_exception)"};

    public ResourceValueFrame(int numSlots) {
        super(numSlots);
    }

    public State getStatus() {
        return this.status;
    }

    public void setStatus(State status) {
        this.status = status;
    }

    @Override
    public boolean sameAs(Frame<ResourceValue> other_) {
        if (!super.sameAs(other_)) {
            return false;
        }
        ResourceValueFrame other = (ResourceValueFrame)other_;
        return this.status == other.status;
    }

    @Override
    public void copyFrom(Frame<ResourceValue> other_) {
        super.copyFrom(other_);
        ResourceValueFrame other = (ResourceValueFrame)other_;
        this.status = other.status;
    }

    @Override
    public String toString() {
        return super.toString() + statusList[this.status.getType()];
    }

    public static enum State {
        ESCAPED(0),
        OPEN(1),
        OPEN_ON_EXCEPTION_PATH(2),
        CLOSED_WITHOUT_OPENED(3),
        CLOSED(4),
        CREATED(5),
        NONEXISTENT(6),
        NOT_OPEN_ON_EXCEPTION_PATH(7);

        private final int type;

        private State(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }
    }
}

