/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.AnnotationDatabase;
import edu.umd.cs.findbugs.ba.DefaultNullnessAnnotations;
import edu.umd.cs.findbugs.ba.INullnessAnnotationDatabase;
import edu.umd.cs.findbugs.ba.NullnessAnnotation;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.XMethodParameter;
import edu.umd.cs.findbugs.ba.npe.TypeQualifierNullnessAnnotationDatabase;
import edu.umd.cs.findbugs.bytecode.MemberUtils;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.log.Profiler;
import javax.annotation.CheckForNull;

@Deprecated
public class NullnessAnnotationDatabase
extends AnnotationDatabase<NullnessAnnotation>
implements INullnessAnnotationDatabase {
    public NullnessAnnotationDatabase() {
        this.setAddClassOnly(true);
        this.loadAuxiliaryAnnotations();
        this.setAddClassOnly(false);
    }

    @Override
    public void loadAuxiliaryAnnotations() {
        DefaultNullnessAnnotations.addDefaultNullnessAnnotations(this);
    }

    @Override
    public boolean parameterMustBeNonNull(XMethod m, int param) {
        if (param == 0) {
            if ("equals".equals(m.getName()) && "(Ljava/lang/Object;)Z".equals(m.getSignature()) && !m.isStatic()) {
                return false;
            }
            if (MemberUtils.isMainMethod(m)) {
                return true;
            }
            if (TypeQualifierNullnessAnnotationDatabase.assertsFirstParameterIsNonnull(m)) {
                return true;
            }
            if ("compareTo".equals(m.getName()) && m.getSignature().endsWith(";)Z") && !m.isStatic()) {
                return true;
            }
        }
        if (!this.anyAnnotations(NullnessAnnotation.NONNULL)) {
            return false;
        }
        XMethodParameter xmp = new XMethodParameter(m, param);
        NullnessAnnotation resolvedAnnotation = this.getResolvedAnnotation(xmp, true);
        return resolvedAnnotation == NullnessAnnotation.NONNULL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CheckForNull
    public NullnessAnnotation getResolvedAnnotation(Object o, boolean getMinimal) {
        Profiler profiler = Global.getAnalysisCache().getProfiler();
        profiler.start(this.getClass());
        try {
            XField f;
            if (o instanceof XMethodParameter) {
                XMethodParameter mp = (XMethodParameter)o;
                XMethod m = mp.getMethod();
                int parameterNumber = mp.getParameterNumber();
                if (parameterNumber == 0) {
                    if ("equals".equals(m.getName()) && "(Ljava/lang/Object;)Z".equals(m.getSignature()) && !m.isStatic()) {
                        NullnessAnnotation nullnessAnnotation = NullnessAnnotation.CHECK_FOR_NULL;
                        return nullnessAnnotation;
                    }
                    if (MemberUtils.isMainMethod(m)) {
                        NullnessAnnotation nullnessAnnotation = NullnessAnnotation.NONNULL;
                        return nullnessAnnotation;
                    }
                    if (TypeQualifierNullnessAnnotationDatabase.assertsFirstParameterIsNonnull(m)) {
                        NullnessAnnotation nullnessAnnotation = NullnessAnnotation.NONNULL;
                        return nullnessAnnotation;
                    }
                    if ("compareTo".equals(m.getName()) && m.getSignature().endsWith(";)Z") && !m.isStatic()) {
                        NullnessAnnotation nullnessAnnotation = NullnessAnnotation.NONNULL;
                        return nullnessAnnotation;
                    }
                }
            } else if (o instanceof XMethod) {
                XMethod m = (XMethod)o;
                String name = m.getName();
                String signature = m.getSignature();
                if (!m.isStatic() && ("clone".equals(name) && "()Ljava/lang/Object;".equals(signature) || "toString".equals(name) && "()Ljava/lang/String;".equals(signature) || m.isPrivate() && "readResolve".equals(name) && "()Ljava/lang/Object;".equals(signature))) {
                    NullnessAnnotation result = (NullnessAnnotation)super.getDirectAnnotation(m);
                    if (result != null) {
                        NullnessAnnotation nullnessAnnotation = result;
                        return nullnessAnnotation;
                    }
                    NullnessAnnotation nullnessAnnotation = NullnessAnnotation.NONNULL;
                    return nullnessAnnotation;
                }
            } else if (o instanceof XField && (f = (XField)o).getName().startsWith("this$")) {
                NullnessAnnotation nullnessAnnotation = NullnessAnnotation.NONNULL;
                return nullnessAnnotation;
            }
            NullnessAnnotation nullnessAnnotation = (NullnessAnnotation)super.getResolvedAnnotation(o, getMinimal);
            return nullnessAnnotation;
        }
        finally {
            profiler.end(this.getClass());
        }
    }

    @Override
    public void addDefaultMethodAnnotation(String name, NullnessAnnotation annotation) {
        super.addDefaultMethodAnnotation(name, annotation);
    }

    @Override
    public void addDefaultAnnotation(AnnotationDatabase.Target target, String c, NullnessAnnotation n) {
        super.addDefaultAnnotation(target, c, n);
    }

    @Override
    public void addFieldAnnotation(String name, String name2, String sig, boolean isStatic, NullnessAnnotation annotation) {
        super.addFieldAnnotation(name, name2, sig, isStatic, annotation);
    }

    @Override
    public void addMethodAnnotation(String name, String name2, String sig, boolean isStatic, NullnessAnnotation annotation) {
        super.addMethodAnnotation(name, name2, sig, isStatic, annotation);
    }

    @Override
    public void addMethodParameterAnnotation(String name, String name2, String sig, boolean isStatic, int param, NullnessAnnotation annotation) {
        super.addMethodParameterAnnotation(name, name2, sig, isStatic, param, annotation);
    }
}

