/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.AbstractBugReporter;
import edu.umd.cs.findbugs.AnalysisError;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.TextUIBugReporter;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class XDocsBugReporter
extends TextUIBugReporter {
    private final SortedBugCollection bugCollection;
    private final Project project;
    private final Document document;
    private final Element root;
    private static final String ROOT_ELEMENT_NAME = "BugCollection";
    private static final String ERRORS_ELEMENT_NAME = "Errors";
    private static final String ANALYSIS_ERROR_ELEMENT_NAME = "AnalysisError";
    private static final String MISSING_CLASS_ELEMENT_NAME = "MissingClass";
    private static final String ELEMENT_NAME = "BugInstance";
    private static final String FILE_ELEMENT_NAME = "file";

    public XDocsBugReporter(Project project) {
        this.project = project;
        this.bugCollection = new SortedBugCollection(project);
        this.document = DocumentHelper.createDocument();
        this.root = this.document.addElement(ROOT_ELEMENT_NAME);
    }

    @Override
    public void observeClass(ClassDescriptor classDescriptor) {
    }

    @Override
    public void logError(String message) {
        this.bugCollection.addError(message);
        super.logError(message);
    }

    @Override
    public void reportMissingClass(ClassNotFoundException ex) {
        String missing = AbstractBugReporter.getMissingClassName(ex);
        if (!XDocsBugReporter.isValidMissingClassMessage(missing)) {
            return;
        }
        this.bugCollection.addMissingClass(missing);
        super.reportMissingClass(ex);
    }

    @Override
    public void reportMissingClass(ClassDescriptor classDescriptor) {
        String missing = classDescriptor.getDottedClassName();
        if (!XDocsBugReporter.isValidMissingClassMessage(missing)) {
            return;
        }
        this.bugCollection.addMissingClass(missing);
        super.reportMissingClass(classDescriptor);
    }

    @Override
    public void doReportBug(BugInstance bugInstance) {
        if (this.bugCollection.add(bugInstance)) {
            this.printBug(bugInstance);
            this.notifyObservers(bugInstance);
        }
    }

    @Override
    protected void printBug(BugInstance bugInstance) {
        try {
            this.toElement(bugInstance);
        }
        catch (Exception e) {
            this.logError("Couldn't add Element", e);
        }
    }

    @Override
    public void finish() {
        try {
            this.writeXML(this.outputStream, this.project);
        }
        catch (Exception e) {
            this.logError("Couldn't write XML output", e);
        }
        this.outputStream.flush();
    }

    private void writeXML(Writer out, Project project) throws IOException {
        Document doc = this.endDocument(project);
        try (XMLWriter writer = new XMLWriter(out, OutputFormat.createPrettyPrint());){
            writer.write(doc);
        }
    }

    private Document endDocument(Project project) {
        Element errorsElement = this.root.addElement(ERRORS_ELEMENT_NAME);
        for (AnalysisError analysisError : this.bugCollection.getErrors()) {
            errorsElement.addElement(ANALYSIS_ERROR_ELEMENT_NAME).setText(analysisError.getMessage());
        }
        Iterator<String> i = this.bugCollection.missingClassIterator();
        while (i.hasNext()) {
            errorsElement.addElement(MISSING_CLASS_ELEMENT_NAME).setText(i.next());
        }
        return this.document;
    }

    private static String xmlEscape(String theString) {
        StringBuilder buf = new StringBuilder();
        int len = theString.length();
        block7: for (int i = 0; i < len; ++i) {
            char theChar = theString.charAt(i);
            switch (theChar) {
                case '>': {
                    buf.append("&gt;");
                    continue block7;
                }
                case '<': {
                    buf.append("&lt;");
                    continue block7;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block7;
                }
                case '&': {
                    buf.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    buf.append("&apos;");
                    continue block7;
                }
                default: {
                    buf.append(theChar);
                }
            }
        }
        return buf.toString();
    }

    public void toElement(BugInstance bugInstance) {
        String className = bugInstance.getPrimaryClass().getClassName();
        Element element = (Element)this.root.selectSingleNode("file[@classname='" + className + "']");
        if (element == null) {
            element = this.root.addElement(FILE_ELEMENT_NAME);
            element.addAttribute("classname", className);
        }
        element = element.addElement(ELEMENT_NAME);
        element.addAttribute("type", bugInstance.getType());
        switch (bugInstance.getPriority()) {
            case 4: {
                element.addAttribute("priority", "Experimental");
                break;
            }
            case 3: {
                element.addAttribute("priority", "Low");
                break;
            }
            case 2: {
                element.addAttribute("priority", "Normal");
                break;
            }
            case 1: {
                element.addAttribute("priority", "High");
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        element.addAttribute("message", XDocsBugReporter.xmlEscape(bugInstance.getMessage()));
        SourceLineAnnotation line = bugInstance.getPrimarySourceLineAnnotation();
        element.addAttribute("line", Integer.toString(line.getStartLine()));
    }

    @Override
    @Nonnull
    public BugCollection getBugCollection() {
        return this.bugCollection;
    }
}

