/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser.violations;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingCanceledException;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.Set;
import java.util.logging.Level;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;

public abstract class AbstractViolationAdapter
extends IssueParser {
    private static final long serialVersionUID = 7203311857999721045L;

    @Override
    public Report parseReport(ReaderFactory readerFactory) throws ParsingCanceledException, ParsingException {
        try {
            ViolationsParser parser = this.createParser();
            Set violations = parser.parseReportOutput(readerFactory.readString(), (ViolationsLogger)new NullViolationsLogger());
            return this.convertToReport(violations);
        }
        catch (Exception exception) {
            throw new ParsingException(exception);
        }
    }

    abstract ViolationsParser createParser();

    Report convertToReport(Set<Violation> violations) {
        try (IssueBuilder builder = new IssueBuilder();){
            Report report = new Report();
            for (Violation violation : violations) {
                if (!this.isValid(violation)) continue;
                report.add(this.convertToIssue(violation, builder));
            }
            this.postProcess(report, violations);
            Report report2 = report;
            return report2;
        }
    }

    void postProcess(Report report, Set<Violation> violations) {
    }

    boolean isValid(Violation violation) {
        return true;
    }

    Issue convertToIssue(Violation violation, IssueBuilder builder) {
        this.updateIssueBuilder(violation, builder);
        this.extractAdditionalProperties(builder, violation);
        return builder.buildAndClean();
    }

    void updateIssueBuilder(Violation violation, IssueBuilder builder) {
        builder.setSeverity(this.convertSeverity(violation.getSeverity(), violation)).setFileName(violation.getFile()).setMessage(violation.getMessage()).setLineStart(this.toValidInt(violation.getStartLine())).setLineEnd(this.toValidInt(violation.getEndLine())).setColumnStart(this.toValidInt(violation.getColumn())).setColumnEnd(this.toValidInt(violation.getEndColumn())).setType(violation.getRule()).setCategory(violation.getCategory());
    }

    private int toValidInt(@CheckForNull Integer integer) {
        if (integer == null) {
            return 0;
        }
        return Math.max(integer, 0);
    }

    void extractAdditionalProperties(IssueBuilder builder, Violation violation) {
    }

    Severity convertSeverity(SEVERITY severity, Violation violation) {
        if (severity == se.bjurr.violations.lib.model.SEVERITY.ERROR) {
            return Severity.WARNING_HIGH;
        }
        if (severity == se.bjurr.violations.lib.model.SEVERITY.WARN) {
            return Severity.WARNING_NORMAL;
        }
        return Severity.WARNING_LOW;
    }

    private static class NullViolationsLogger
    implements ViolationsLogger {
        private NullViolationsLogger() {
        }

        public void log(Level level, String s) {
        }

        public void log(Level level, String s, Throwable throwable) {
        }
    }
}

