/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.RevApiInfoExtension;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.parser.JsonIssueParser;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.UnescapedText;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class RevApiParser
extends JsonIssueParser {
    private static final long serialVersionUID = -2452699725595063377L;
    private static final String UNDEFINED = "-";
    private static final String FQN = "classQualifiedName";
    private static final String PACKAGE = "package";
    private static final String CODE = "code";
    private static final String ELEMENT_KIND = "elementKind";
    private static final char DOT = '.';
    private static final char SLASH = '/';
    private static final String JAVA_EXTENSION = ".java";
    private static final String CLASS_SIMPLE_NAME = "classSimpleName";

    @Override
    protected void parseJsonArray(Report report, JSONArray jsonReport, IssueBuilder issueBuilder) {
        for (Object issue : jsonReport) {
            if (issue instanceof JSONObject) {
                JSONObject object = (JSONObject)issue;
                report.add(this.convertToIssue(object, issueBuilder));
                continue;
            }
            report.logError("RevApi element is not a valid JSON object: %s", issue);
        }
    }

    private Issue convertToIssue(JSONObject jsonIssue, IssueBuilder builder) {
        builder.setSeverity(this.evaluateSeverity(jsonIssue.getJSONArray("classification")));
        builder.setMessage(jsonIssue.getString("description"));
        Map<String, String> attachments = this.getAttachments(jsonIssue);
        builder.setDescription(this.getDescription(jsonIssue, attachments));
        builder.setFileName(this.getFileName(attachments));
        builder.setPackageName(attachments.get(PACKAGE));
        builder.setCategory(StringUtils.capitalize((String)attachments.get(ELEMENT_KIND)));
        builder.setType(attachments.get(CODE));
        builder.setAdditionalProperties(this.convertToGroup(jsonIssue));
        return builder.build();
    }

    private String getFileName(Map<String, String> attachments) {
        return attachments.get(PACKAGE).replace('.', '/') + "/" + attachments.get(CLASS_SIMPLE_NAME) + JAVA_EXTENSION;
    }

    private RevApiInfoExtension convertToGroup(JSONObject jsonIssue) {
        return new RevApiInfoExtension(jsonIssue.getString(CODE), RevApiParser.extractChange(jsonIssue, "old"), RevApiParser.extractChange(jsonIssue, "new"), RevApiParser.extractSeverities(jsonIssue));
    }

    private static Map<String, String> extractSeverities(JSONObject jsonIssue) {
        HashMap<String, String> allSeverities = new HashMap<String, String>();
        for (Object severity : jsonIssue.getJSONArray("classification")) {
            if (!(severity instanceof JSONObject)) continue;
            JSONObject object = (JSONObject)severity;
            allSeverities.put(object.getString("compatibility"), object.getString("severity"));
        }
        return allSeverities;
    }

    private static String extractChange(JSONObject jsonIssue, String key) {
        String value = jsonIssue.get(key).toString();
        return "null".equals(value) ? UNDEFINED : value;
    }

    private Severity evaluateSeverity(JSONArray classification) {
        HashSet<Severity> allSeverities = new HashSet<Severity>();
        for (Object severity : classification) {
            if (!(severity instanceof JSONObject)) continue;
            JSONObject object = (JSONObject)severity;
            allSeverities.add(this.toSeverity(object.getString("severity")));
        }
        if (allSeverities.contains(Severity.WARNING_HIGH)) {
            return Severity.WARNING_HIGH;
        }
        if (allSeverities.contains(Severity.WARNING_NORMAL)) {
            return Severity.WARNING_NORMAL;
        }
        return Severity.WARNING_LOW;
    }

    private Severity toSeverity(String level) {
        return switch (level) {
            case "BREAKING" -> Severity.WARNING_HIGH;
            case "POTENTIALLY_BREAKING" -> Severity.WARNING_NORMAL;
            default -> Severity.WARNING_LOW;
        };
    }

    private String getDescription(JSONObject jsonIssue, Map<String, String> attachments) {
        ContainerTag html = TagCreator.table((DomContent[])new DomContent[]{TagCreator.tr((DomContent[])new DomContent[]{TagCreator.td((String)"Class:"), TagCreator.td((String)attachments.getOrDefault(FQN, UNDEFINED))}), TagCreator.tr((DomContent[])new DomContent[]{TagCreator.td((String)"Code:"), TagCreator.td((String)attachments.getOrDefault(CODE, UNDEFINED))}), TagCreator.tr((DomContent[])new DomContent[]{TagCreator.td((String)"Name:"), TagCreator.td((String)attachments.getOrDefault("name", UNDEFINED))}), TagCreator.tr((DomContent[])new DomContent[]{TagCreator.td((String)"New Element:"), TagCreator.td((String)attachments.getOrDefault("new", UNDEFINED))}), TagCreator.tr((DomContent[])new DomContent[]{TagCreator.td((String)"Old Element:"), TagCreator.td((String)attachments.getOrDefault("old", UNDEFINED))}), TagCreator.tr((DomContent[])new DomContent[]{TagCreator.td((String)"Justification:"), TagCreator.td((String)attachments.getOrDefault("justification", UNDEFINED))}), TagCreator.tr((DomContent[])new DomContent[]{TagCreator.td((String)"Classification:"), TagCreator.td((DomContent[])new DomContent[]{this.createClassification(jsonIssue)})})});
        return html.renderFormatted();
    }

    private Map<String, String> getAttachments(JSONObject jsonIssue) {
        HashMap<String, String> attachments = new HashMap<String, String>();
        for (Object attachment : jsonIssue.getJSONArray("attachments")) {
            if (!(attachment instanceof JSONObject)) continue;
            JSONObject object = (JSONObject)attachment;
            String key = object.getString("name");
            if (!object.has("name")) continue;
            attachments.put(key, object.getString("value"));
        }
        this.addValue(CODE, jsonIssue, attachments);
        this.addValue("old", jsonIssue, attachments);
        this.addValue("new", jsonIssue, attachments);
        this.addValue("name", jsonIssue, attachments);
        this.addValue("description", jsonIssue, attachments);
        this.addValue("criticality", jsonIssue, attachments);
        this.addValue("justification", jsonIssue, attachments);
        return attachments;
    }

    private void addValue(String key, JSONObject jsonIssue, Map<String, String> attachments) {
        String code;
        if (jsonIssue.has(key) && jsonIssue.get(key) instanceof String && (code = jsonIssue.getString(key)) != null && !code.isEmpty()) {
            attachments.put(key, code);
        }
    }

    private DomContent createClassification(JSONObject jsonIssue) {
        ArrayList<UnescapedText> elements = new ArrayList<UnescapedText>();
        for (Object severity : jsonIssue.getJSONArray("classification")) {
            if (!(severity instanceof JSONObject)) continue;
            JSONObject object = (JSONObject)severity;
            elements.add(TagCreator.join((Object[])new Object[]{TagCreator.dt((String)object.getString("compatibility")), TagCreator.dd((String)object.getString("severity"))}));
        }
        if (elements.isEmpty()) {
            return TagCreator.text((String)UNDEFINED);
        }
        return TagCreator.dl((DomContent[])elements.toArray(new DomContent[0]));
    }
}

