/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.parser.Gcc4CompilerParser;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;

public class DoxygenParser
extends LookaheadParser {
    private static final long serialVersionUID = 8760302999081711502L;
    private static final String DOXYGEN_WARNING_PATTERN = "^(?:.*\\[[^]]*\\])?\\s*(?:(?:(.+?):(\\d+):|(.+?)\\((\\d+)\\):)?(?:(\\d+):)?)? ?([wW]arning|[Ee]rror): (.*)$";

    public DoxygenParser() {
        super(DOXYGEN_WARNING_PATTERN);
    }

    @Override
    protected boolean isLineInteresting(String line) {
        return (line.contains("arning") || line.contains("rror")) && !line.contains("[javac]");
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        StringBuilder message = new StringBuilder(matcher.group(7));
        if (matcher.group(1) != null || matcher.group(2) != null) {
            builder.setFileName(matcher.group(1));
            builder.setLineStart(matcher.group(2));
        } else {
            builder.setFileName(matcher.group(3));
            builder.setLineStart(matcher.group(4));
        }
        while (lookahead.hasNext() && Gcc4CompilerParser.isMessageContinuation(lookahead)) {
            message.append('\n');
            message.append(lookahead.next());
        }
        return builder.setColumnStart(matcher.group(5)).setMessage(message.toString()).setSeverity(Severity.guessFromString(matcher.group(6))).buildOptional();
    }
}

