/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.util.IntegerParser;
import edu.hm.hafner.util.LineRange;
import edu.hm.hafner.util.LineRangeList;
import edu.hm.hafner.util.PathUtil;
import edu.hm.hafner.util.TreeString;
import edu.hm.hafner.util.TreeStringBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;

public class IssueBuilder
implements AutoCloseable {
    private static final String EMPTY = "";
    private static final String UNDEFINED = "-";
    private static final TreeString UNDEFINED_TREE_STRING = TreeString.valueOf((String)"-");
    private static final TreeString EMPTY_TREE_STRING = TreeString.valueOf((String)"");
    private static final PathUtil PATH_UTIL = new PathUtil();
    private final TreeStringBuilder fileNameBuilder = new TreeStringBuilder();
    private final TreeStringBuilder packageNameBuilder = new TreeStringBuilder();
    private final TreeStringBuilder messageBuilder = new TreeStringBuilder();
    private int lineStart;
    private int lineEnd;
    private int columnStart;
    private int columnEnd;
    @CheckForNull
    private LineRangeList lineRanges;
    @CheckForNull
    private String pathName;
    private TreeString fileName = UNDEFINED_TREE_STRING;
    private TreeString packageName = UNDEFINED_TREE_STRING;
    @CheckForNull
    private String directory;
    @CheckForNull
    private String category;
    @CheckForNull
    private String type;
    @CheckForNull
    private Severity severity;
    private TreeString message = EMPTY_TREE_STRING;
    private String description = "";
    @CheckForNull
    private String moduleName;
    @CheckForNull
    private String origin;
    @CheckForNull
    private String originName;
    @CheckForNull
    private String reference;
    @CheckForNull
    private String fingerprint;
    @CheckForNull
    private Serializable additionalProperties;
    private UUID id = UUID.randomUUID();

    @CanIgnoreReturnValue
    public IssueBuilder setId(UUID id) {
        this.id = id;
        return this;
    }

    @CanIgnoreReturnValue
    public IssueBuilder setAdditionalProperties(@CheckForNull Serializable additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @CanIgnoreReturnValue
    public IssueBuilder setFingerprint(@CheckForNull String fingerprint) {
        this.fingerprint = fingerprint;
        return this;
    }

    @CanIgnoreReturnValue
    public IssueBuilder setFileName(@CheckForNull String fileName) {
        this.fileName = this.internFileName(fileName);
        return this;
    }

    TreeString internFileName(@CheckForNull String unsafeFileName) {
        if (unsafeFileName == null || StringUtils.isEmpty((CharSequence)unsafeFileName)) {
            return UNDEFINED_TREE_STRING;
        }
        if (this.directory != null && PATH_UTIL.isAbsolute(IssueBuilder.normalizeFileName(unsafeFileName))) {
            return this.fileNameBuilder.intern(IssueBuilder.normalizeFileName(unsafeFileName));
        }
        return this.fileNameBuilder.intern(IssueBuilder.normalizeFileName(PATH_UTIL.createAbsolutePath(this.directory, unsafeFileName)));
    }

    @CanIgnoreReturnValue
    public IssueBuilder setDirectory(@CheckForNull String directory) {
        this.directory = directory;
        return this;
    }

    @CanIgnoreReturnValue
    public IssueBuilder setPathName(@CheckForNull String pathName) {
        this.pathName = pathName;
        return this;
    }

    @CanIgnoreReturnValue
    public IssueBuilder setLineStart(int lineStart) {
        this.lineStart = lineStart;
        return this;
    }

    @CanIgnoreReturnValue
    public IssueBuilder setLineStart(@CheckForNull String lineStart) {
        this.lineStart = IntegerParser.parseInt(lineStart);
        return this;
    }

    @CanIgnoreReturnValue
    public IssueBuilder setLineEnd(int lineEnd) {
        this.lineEnd = lineEnd;
        return this;
    }

    @CanIgnoreReturnValue
    public IssueBuilder setLineEnd(@CheckForNull String lineEnd) {
        this.lineEnd = IntegerParser.parseInt(lineEnd);
        return this;
    }

    @CanIgnoreReturnValue
    public IssueBuilder setColumnStart(int columnStart) {
        this.columnStart = columnStart;
        return this;
    }

    @CanIgnoreReturnValue
    public IssueBuilder setColumnStart(@CheckForNull String columnStart) {
        this.columnStart = IntegerParser.parseInt(columnStart);
        return this;
    }

    @CanIgnoreReturnValue
    public IssueBuilder setColumnEnd(int columnEnd) {
        this.columnEnd = columnEnd;
        return this;
    }

    @CanIgnoreReturnValue
    public IssueBuilder setColumnEnd(@CheckForNull String columnEnd) {
        this.columnEnd = IntegerParser.parseInt(columnEnd);
        return this;
    }

    @CanIgnoreReturnValue
    public IssueBuilder setCategory(@CheckForNull String category) {
        this.category = category;
        return this;
    }

    @CanIgnoreReturnValue
    public IssueBuilder setType(@CheckForNull String type) {
        this.type = type;
        return this;
    }

    @CanIgnoreReturnValue
    public IssueBuilder setPackageName(@CheckForNull String packageName) {
        this.packageName = this.internPackageName(packageName);
        return this;
    }

    TreeString internPackageName(@CheckForNull String unsafePackageName) {
        if (unsafePackageName == null || StringUtils.isBlank((CharSequence)unsafePackageName)) {
            return UNDEFINED_TREE_STRING;
        }
        return this.packageNameBuilder.intern(unsafePackageName);
    }

    @CanIgnoreReturnValue
    public IssueBuilder setModuleName(@CheckForNull String moduleName) {
        this.moduleName = moduleName;
        return this;
    }

    @CanIgnoreReturnValue
    public IssueBuilder setOrigin(@CheckForNull String origin) {
        this.origin = origin;
        return this;
    }

    @CanIgnoreReturnValue
    public IssueBuilder setOriginName(@CheckForNull String originName) {
        this.originName = originName;
        return this;
    }

    @CanIgnoreReturnValue
    public IssueBuilder setReference(@CheckForNull String reference) {
        this.reference = reference;
        return this;
    }

    @CanIgnoreReturnValue
    public IssueBuilder setSeverity(@CheckForNull Severity severity) {
        this.severity = severity;
        return this;
    }

    @CanIgnoreReturnValue
    public IssueBuilder guessSeverity(@CheckForNull String severityString) {
        this.severity = Severity.guessFromString(severityString);
        return this;
    }

    @CanIgnoreReturnValue
    public IssueBuilder setMessage(@CheckForNull String message) {
        this.message = StringUtils.isBlank((CharSequence)message) ? EMPTY_TREE_STRING : this.messageBuilder.intern(StringUtils.stripToEmpty((String)message));
        return this;
    }

    @CanIgnoreReturnValue
    public IssueBuilder setDescription(@CheckForNull String description) {
        this.description = StringUtils.stripToEmpty((String)description);
        return this;
    }

    @CanIgnoreReturnValue
    public IssueBuilder setLineRanges(LineRangeList lineRanges) {
        this.lineRanges = new LineRangeList((Collection)lineRanges);
        return this;
    }

    public IssueBuilder copy(Issue copy) {
        this.fileName = copy.getFileNameTreeString();
        this.lineStart = copy.getLineStart();
        this.lineEnd = copy.getLineEnd();
        this.columnStart = copy.getColumnStart();
        this.columnEnd = copy.getColumnEnd();
        this.lineRanges = new LineRangeList();
        this.lineRanges.addAll(copy.getLineRanges());
        this.category = copy.getCategory();
        this.type = copy.getType();
        this.severity = copy.getSeverity();
        this.message = copy.getMessageTreeString();
        this.description = copy.getDescription();
        this.packageName = copy.getPackageNameTreeString();
        this.moduleName = copy.getModuleName();
        this.origin = copy.getOrigin();
        this.originName = copy.getOriginName();
        this.reference = copy.getReference();
        this.fingerprint = copy.getFingerprint();
        this.additionalProperties = copy.getAdditionalProperties();
        return this;
    }

    public Issue build() {
        Issue issue = this.buildWithConstructor();
        this.id = UUID.randomUUID();
        return issue;
    }

    public Issue buildAndClean() {
        Issue issue = this.buildWithConstructor();
        this.clean();
        return issue;
    }

    private Issue buildWithConstructor() {
        this.cleanupLineRanges();
        return new Issue(this.pathName, this.fileName, this.lineStart, this.lineEnd, this.columnStart, this.columnEnd, (Iterable<? extends LineRange>)this.lineRanges, this.category, this.type, this.packageName, this.moduleName, this.severity, this.message, this.description, this.origin, this.originName, this.reference, this.fingerprint, this.additionalProperties, this.id);
    }

    private void cleanupLineRanges() {
        if (this.lineRanges != null && !this.lineRanges.isEmpty()) {
            LineRange firstRange = this.lineRanges.get(0);
            if (this.lineStart == 0) {
                this.lineStart = firstRange.getStart();
                this.lineEnd = firstRange.getEnd();
            }
            if (firstRange.getStart() == this.lineStart && firstRange.getEnd() == this.lineEnd) {
                this.lineRanges.remove(0);
            }
        }
    }

    public Optional<Issue> buildOptional() {
        return Optional.of(this.buildAndClean());
    }

    private void clean() {
        this.id = UUID.randomUUID();
        this.lineStart = 0;
        this.lineEnd = 0;
        this.columnStart = 0;
        this.columnEnd = 0;
        this.lineRanges = new LineRangeList();
        this.fileName = UNDEFINED_TREE_STRING;
        this.packageName = UNDEFINED_TREE_STRING;
        this.category = null;
        this.type = null;
        this.severity = null;
        this.message = EMPTY_TREE_STRING;
        this.description = EMPTY;
        this.moduleName = null;
        this.additionalProperties = null;
    }

    private static String normalizeFileName(@CheckForNull String platformFileName) {
        return IssueBuilder.defaultString(Strings.CS.replace(StringUtils.strip((String)platformFileName), "\\", "/"));
    }

    private static String defaultString(@CheckForNull String string) {
        return ((String)StringUtils.defaultIfEmpty((CharSequence)string, (CharSequence)UNDEFINED)).intern();
    }

    @Override
    public void close() {
        this.fileNameBuilder.dedup();
        this.packageNameBuilder.dedup();
        this.messageBuilder.dedup();
    }
}

