/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.hm.hafner.analysis.FullTextFingerprint;
import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.VisibleForTesting;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.file.InvalidPathException;
import java.nio.file.NoSuchFileException;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class FingerprintGenerator {
    private static final Set<String> NON_SOURCE_CODE_EXTENSIONS = Set.of("o", "exe", "dll", "so", "a", "lib", "jar", "war", "zip", "7z", "gz", "bz2");

    public void run(FullTextFingerprint algorithm, Report report, Charset charset) {
        FilteredLog log = new FilteredLog("Can't create fingerprints for some files:");
        int sum = 0;
        for (Issue issue : report) {
            if (issue.hasFingerprint()) continue;
            if (this.hasAllowedExtension(issue.getFileName())) {
                sum += this.computeFingerprint(issue, algorithm, charset, log);
                continue;
            }
            issue.setFingerprint(FingerprintGenerator.createDefaultFingerprint(issue));
        }
        report.mergeLogMessages(log);
        report.logInfo("-> created fingerprints for %d issues (skipped %d issues)", sum, report.size() - sum);
    }

    private boolean hasAllowedExtension(String fileName) {
        try {
            return !NON_SOURCE_CODE_EXTENSIONS.contains(StringUtils.lowerCase((String)FilenameUtils.getExtension((String)fileName)));
        }
        catch (IllegalArgumentException exception) {
            return false;
        }
    }

    private int computeFingerprint(Issue issue, FullTextFingerprint algorithm, Charset charset, FilteredLog log) {
        String absolutePath = issue.getAbsolutePath();
        try {
            if (issue.hasFileName()) {
                String digest = algorithm.compute(absolutePath, issue.getLineStart(), charset);
                issue.setFingerprint(digest);
                return 1;
            }
        }
        catch (FileNotFoundException | NoSuchFileException exception) {
            log.logError("- '%s' file not found", new Object[]{absolutePath});
        }
        catch (IOException | UncheckedIOException | InvalidPathException exception) {
            if (exception.getCause() instanceof MalformedInputException) {
                log.logError("- '%s', provided encoding '%s' seems to be wrong", new Object[]{absolutePath, charset});
            }
            log.logError("- '%s', IO exception has been thrown: %s", new Object[]{absolutePath, exception});
        }
        issue.setFingerprint(FingerprintGenerator.createDefaultFingerprint(issue));
        return 0;
    }

    @VisibleForTesting
    static String createDefaultFingerprint(Issue issue) {
        HashCodeBuilder builder = new HashCodeBuilder();
        return String.format(Locale.ENGLISH, "FALLBACK-%x", builder.append((Object)issue.getBaseName()).append((Object)issue.getType()).append((Object)issue.getCategory()).append((Object)issue.getSeverity()).append((Object)issue.getOrigin()).append(issue.getLineStart()).build());
    }
}

