/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.benchmark.TimeTracker;
import net.sourceforge.pmd.benchmark.TimedOperation;
import net.sourceforge.pmd.benchmark.TimedOperationCategory;
import net.sourceforge.pmd.lang.LanguageProcessorRegistry;
import net.sourceforge.pmd.lang.ast.RootNode;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.lang.rule.InternalApiBridge;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RuleReference;
import net.sourceforge.pmd.lang.rule.RuleSet;
import net.sourceforge.pmd.lang.rule.impl.UnnecessaryPmdSuppressionRule;
import net.sourceforge.pmd.lang.rule.internal.RuleApplicator;
import net.sourceforge.pmd.reporting.FileAnalysisListener;
import net.sourceforge.pmd.util.log.PmdReporter;

public class RuleSets {
    private final List<RuleSet> ruleSets;
    private RuleApplicator ruleApplicator;

    public RuleSets(RuleSets ruleSets) {
        ArrayList<RuleSet> rsets = new ArrayList<RuleSet>();
        for (RuleSet rs : ruleSets.ruleSets) {
            rsets.add(new RuleSet(rs));
        }
        this.ruleSets = Collections.unmodifiableList(rsets);
    }

    public RuleSets(Collection<? extends RuleSet> ruleSets) {
        ArrayList<RuleSet> rulesets = new ArrayList<RuleSet>();
        ArrayList<RuleSet> suppressionRules = new ArrayList<RuleSet>();
        for (RuleSet ruleSet : ruleSets) {
            RuleSet.RuleSetBuilder noSuppressions = ruleSet.toBuilder();
            RuleSet.RuleSetBuilder onlySuppressions = ruleSet.toBuilder();
            noSuppressions.removeIf(rule1 -> RuleSets.followReference(rule1) instanceof UnnecessaryPmdSuppressionRule);
            onlySuppressions.removeIf(rule1 -> !(RuleSets.followReference(rule1) instanceof UnnecessaryPmdSuppressionRule));
            rulesets.add(noSuppressions.build());
            suppressionRules.add(onlySuppressions.build());
        }
        rulesets.addAll(suppressionRules);
        this.ruleSets = Collections.unmodifiableList(rulesets);
    }

    private static Rule followReference(Rule rule) {
        if (rule instanceof RuleReference) {
            return RuleSets.followReference(((RuleReference)rule).getRule());
        }
        return rule;
    }

    public RuleSets(RuleSet ruleSet) {
        this.ruleSets = Collections.singletonList(ruleSet);
    }

    public void initializeRules(LanguageProcessorRegistry lpReg, PmdReporter reporter) {
        for (RuleSet rset : this.ruleSets) {
            Iterator<Rule> iterator = rset.getRules().iterator();
            while (iterator.hasNext()) {
                Rule rule = iterator.next();
                try {
                    rule.initialize(lpReg.getProcessor(rule.getLanguage()));
                }
                catch (Exception e) {
                    reporter.errorEx("Exception while initializing rule " + rule.getName() + ", the rule will not be run", e);
                    iterator.remove();
                }
            }
        }
    }

    private RuleApplicator prepareApplicator() {
        return RuleApplicator.build(this.ruleSets.stream().flatMap(it -> it.getRules().stream())::iterator);
    }

    public RuleSet[] getAllRuleSets() {
        return this.ruleSets.toArray(new RuleSet[0]);
    }

    List<RuleSet> getRuleSetsInternal() {
        return this.ruleSets;
    }

    public Iterator<RuleSet> getRuleSetsIterator() {
        return this.ruleSets.iterator();
    }

    public Set<Rule> getAllRules() {
        HashSet<Rule> result = new HashSet<Rule>();
        for (RuleSet r : this.ruleSets) {
            result.addAll(r.getRules());
        }
        return result;
    }

    public boolean applies(TextFile file) {
        for (RuleSet ruleSet : this.ruleSets) {
            if (!InternalApiBridge.ruleSetApplies(ruleSet, file.getFileId())) continue;
            return true;
        }
        return false;
    }

    public void apply(RootNode root, FileAnalysisListener listener) {
        if (this.ruleApplicator == null) {
            this.ruleApplicator = this.prepareApplicator();
        }
        try (TimedOperation ignored = TimeTracker.startOperation(TimedOperationCategory.RULE_AST_INDEXATION);){
            this.ruleApplicator.index(root);
        }
        for (RuleSet ruleSet : this.ruleSets) {
            if (!InternalApiBridge.ruleSetApplies(ruleSet, root.getTextDocument().getFileId())) continue;
            this.ruleApplicator.apply(ruleSet.getRules(), listener);
        }
    }

    public Rule getRuleByName(String ruleName) {
        Rule rule = null;
        Iterator<RuleSet> i = this.ruleSets.iterator();
        while (i.hasNext() && rule == null) {
            RuleSet ruleSet = i.next();
            rule = ruleSet.getRuleByName(ruleName);
        }
        return rule;
    }

    public int ruleCount() {
        int count = 0;
        for (RuleSet r : this.ruleSets) {
            count += r.getRules().size();
        }
        return count;
    }

    public void removeDysfunctionalRules(Collection<Rule> collector) {
        for (RuleSet ruleSet : this.ruleSets) {
            ruleSet.removeDysfunctionalRules(collector);
        }
    }

    public long getChecksum() {
        long checksum = 1L;
        for (RuleSet ruleSet : this.ruleSets) {
            checksum = checksum * 31L + ruleSet.getChecksum();
        }
        return checksum;
    }
}

