/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast.internal;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.ast.internal.Filtermap;
import org.checkerframework.checker.nullness.qual.NonNull;

final class TreeWalker {
    private static final TreeWalker CROSS = new TreeWalker(true);
    private static final TreeWalker DONT_CROSS;
    static final TreeWalker DEFAULT;
    private final boolean crossFindBoundaries;

    private TreeWalker(boolean crossFindBoundaries) {
        this.crossFindBoundaries = crossFindBoundaries;
    }

    public boolean isCrossFindBoundaries() {
        return this.crossFindBoundaries;
    }

    TreeWalker crossFindBoundaries(boolean cross) {
        return cross ? CROSS : DONT_CROSS;
    }

    <T extends Node> NodeStream.DescendantNodeStream<T> apply(NodeStream.DescendantNodeStream<T> stream) {
        return stream.crossFindBoundaries(this.crossFindBoundaries);
    }

    <T> void findDescendantsMatching(Node node, Filtermap<? super Node, ? extends T> filtermap, List<T> results) {
        for (int i = 0; i < node.getNumChildren(); ++i) {
            Node child = node.getChild(i);
            T mapped = filtermap.apply(child);
            if (mapped != null) {
                results.add(mapped);
            }
            if (!this.isCrossFindBoundaries() && child.isFindBoundary()) continue;
            this.findDescendantsMatching(child, filtermap, results);
        }
    }

    <T extends Node> T getFirstDescendantOfType(Node node, Filtermap<? super Node, ? extends T> filtermap) {
        int n = node.getNumChildren();
        for (int i = 0; i < n; ++i) {
            T n2;
            Node child = node.getChild(i);
            Node t = (Node)filtermap.apply(child);
            if (t != null) {
                return (T)t;
            }
            if (!this.isCrossFindBoundaries() && child.isFindBoundary() || (n2 = this.getFirstDescendantOfType(child, filtermap)) == null) continue;
            return n2;
        }
        return null;
    }

    <T> List<T> findDescendantsMatching(Node node, Filtermap<? super Node, ? extends T> filtermap) {
        ArrayList results = new ArrayList();
        this.findDescendantsMatching(node, filtermap, results);
        return results;
    }

    Iterator<Node> descendantOrSelfIterator(Node top) {
        return new DescendantOrSelfIterator(top, this);
    }

    Iterator<Node> descendantIterator(Node top) {
        DescendantOrSelfIterator iter = new DescendantOrSelfIterator(top, this);
        iter.next();
        return iter;
    }

    static {
        DEFAULT = DONT_CROSS = new TreeWalker(false);
    }

    private static class DescendantOrSelfIterator
    implements Iterator<Node> {
        private final Deque<Node> queue = new ArrayDeque<Node>();
        private final TreeWalker config;
        private boolean isFirst;

        DescendantOrSelfIterator(Node top, TreeWalker walker) {
            this.config = walker;
            this.isFirst = true;
            this.queue.addFirst(top);
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public @NonNull Node next() {
            Node node = this.queue.removeFirst();
            this.enqueueChildren(node);
            this.isFirst = false;
            return node;
        }

        private void enqueueChildren(Node n) {
            if (this.config.isCrossFindBoundaries() || !n.isFindBoundary() || this.isFirst) {
                for (int i = n.getNumChildren() - 1; i >= 0; --i) {
                    this.queue.addFirst(n.getChild(i));
                }
            }
        }
    }
}

