/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cache.internal;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sourceforge.pmd.cache.internal.CachedRuleMapper;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.document.TextRange2d;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.reporting.RuleViolation;
import net.sourceforge.pmd.util.StringUtil;
import org.checkerframework.checker.nullness.qual.NonNull;

final class CachedRuleViolation
implements RuleViolation {
    private final CachedRuleMapper mapper;
    private final String description;
    private final String ruleClassName;
    private final String ruleName;
    private final String ruleTargetLanguage;
    private final Map<String, String> additionalInfo;
    private final FileLocation location;

    private CachedRuleViolation(CachedRuleMapper mapper, String description, FileId fileFileId, String ruleClassName, String ruleName, String ruleTargetLanguage, int beginLine, int beginColumn, int endLine, int endColumn, Map<String, String> additionalInfo) {
        this.mapper = mapper;
        this.description = description;
        this.location = FileLocation.range(fileFileId, TextRange2d.range2d(beginLine, beginColumn, endLine, endColumn));
        this.ruleClassName = ruleClassName;
        this.ruleName = ruleName;
        this.ruleTargetLanguage = ruleTargetLanguage;
        this.additionalInfo = additionalInfo;
    }

    @Override
    public Rule getRule() {
        return this.mapper.getRuleForClass(this.ruleClassName, this.ruleName, this.ruleTargetLanguage);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public FileLocation getLocation() {
        return this.location;
    }

    @Override
    public Map<String, String> getAdditionalInfo() {
        return this.additionalInfo;
    }

    static CachedRuleViolation loadFromStream(DataInputStream stream, FileId fileFileId, CachedRuleMapper mapper) throws IOException {
        String description = stream.readUTF();
        String ruleClassName = stream.readUTF();
        String ruleName = stream.readUTF();
        String ruleTargetLanguage = stream.readUTF();
        int beginLine = stream.readInt();
        int beginColumn = stream.readInt();
        int endLine = stream.readInt();
        int endColumn = stream.readInt();
        Map<String, String> additionalInfo = CachedRuleViolation.readAdditionalInfo(stream);
        return new CachedRuleViolation(mapper, description, fileFileId, ruleClassName, ruleName, ruleTargetLanguage, beginLine, beginColumn, endLine, endColumn, additionalInfo);
    }

    private static @NonNull Map<String, String> readAdditionalInfo(DataInputStream stream) throws IOException {
        int numAdditionalInfoKeyValuePairs = stream.readInt();
        if (numAdditionalInfoKeyValuePairs == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> additionalInfo = new LinkedHashMap<String, String>();
        while (numAdditionalInfoKeyValuePairs-- > 0) {
            String key = stream.readUTF();
            String value = stream.readUTF();
            additionalInfo.put(key, value);
        }
        return Collections.unmodifiableMap(additionalInfo);
    }

    static void storeToStream(DataOutputStream stream, RuleViolation violation) throws IOException {
        stream.writeUTF(StringUtil.nullToEmpty(violation.getDescription()));
        stream.writeUTF(StringUtil.nullToEmpty(violation.getRule().getRuleClass()));
        stream.writeUTF(StringUtil.nullToEmpty(violation.getRule().getName()));
        stream.writeUTF(StringUtil.nullToEmpty(violation.getRule().getLanguage().getId()));
        FileLocation location = violation.getLocation();
        stream.writeInt(location.getStartPos().getLine());
        stream.writeInt(location.getStartPos().getColumn());
        stream.writeInt(location.getEndPos().getLine());
        stream.writeInt(location.getEndPos().getColumn());
        Map<String, String> additionalInfo = violation.getAdditionalInfo();
        stream.writeInt(additionalInfo.size());
        for (Map.Entry<String, String> entry : additionalInfo.entrySet()) {
            stream.writeUTF(entry.getKey());
            stream.writeUTF(StringUtil.nullToEmpty(entry.getValue()));
        }
    }
}

