/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser.violations;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.parser.violations.AbstractViolationAdapter;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Strings;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.PiTestParser;

public class PitAdapter
extends AbstractViolationAdapter {
    private static final long serialVersionUID = -7811207963029906228L;
    private static final String STATUS = "status";
    private static final String SURVIVED = "SURVIVED";
    private static final String NO_COVERAGE = "NO_COVERAGE";
    private static final String KILLED = "KILLED";
    private static final String MUTATORS_PACKAGE = "org.pitest.mutationtest.engine.gregor.mutators.";
    public static final String TOTAL_MUTATIONS = "totalMutations";
    public static final String KILLED_MUTATIONS = "killedMutations";
    public static final String UNCOVERED_MUTATIONS = "uncoveredMutations";
    public static final String SURVIVED_MUTATIONS = "survivedMutations";

    PiTestParser createParser() {
        return new PiTestParser();
    }

    @Override
    boolean isValid(Violation violation) {
        return !KILLED.equals(this.getMutationStatus(violation));
    }

    @Override
    Severity convertSeverity(SEVERITY severity, Violation violation) {
        if (SURVIVED.equals(this.getMutationStatus(violation))) {
            return Severity.WARNING_NORMAL;
        }
        return Severity.WARNING_HIGH;
    }

    @Override
    void postProcess(Report report, Set<Violation> violations) {
        int total = violations.size();
        Map<String, Integer> issuesByCategory = report.getPropertyCount(Issue::getCategory);
        int noCoverage = issuesByCategory.getOrDefault(NO_COVERAGE, 0);
        int survived = issuesByCategory.getOrDefault(SURVIVED, 0);
        report.setCounter(TOTAL_MUTATIONS, total);
        report.setCounter(UNCOVERED_MUTATIONS, noCoverage);
        report.setCounter(SURVIVED_MUTATIONS, survived);
        report.setCounter(KILLED_MUTATIONS, total - noCoverage - survived);
    }

    @Override
    void extractAdditionalProperties(IssueBuilder builder, Violation violation) {
        builder.setCategory(this.getMutationStatus(violation));
        builder.setType(Strings.CS.removeStart(violation.getRule(), (CharSequence)MUTATORS_PACKAGE));
    }

    private String getMutationStatus(Violation violation) {
        return violation.getSpecifics().getOrDefault(STATUS, KILLED);
    }
}

